export const specificationsStore=defineStore('specifications',()=>{

    interface specification{
        "key":string,
        "values":string[],
        "position":number,
        "important":number
    }

    const data=ref<{[p:string]:specification}>({});
    const getData=(productId:number|string)=>{
          if(Object.keys(data.value).length==0){
              useNuxtApp().$axios.get(
                  useRuntimeConfig().public.api +'/product/'+productId+'/specifications'
              ).then((response)=>{
                  data.value=response.data;
              });
          }
    };

    return{
        data,
        getData
    }
});