export const searchStore=defineStore('search-products',()=>{

    const page=ref<number>(1);
    const status=ref<string>('pending');
    const requestUrl=ref<string>('');
    const result=ref<Record<string, any>>({});
    const appBarTitle=ref<string|null>(null);
    const sortItems:{title:string,value:number}[]=[
        {title: 'پربازدیدترین', value:21 },
        {title: 'جدیدترین', value:23 },
        {title: 'پرفروش‌ترین‌', value:24 },
        {title: 'ارزان‌ترین', value:25 },
        {title: 'گران‌ترین', value:26 },
        {title: 'سریع‌ترین ارسال', value:27 },
    ];
    const queries=ref<Record<string, any>>({});
    const endLoaded=ref<boolean>(false);
    const {$axios}=useNuxtApp();

    const changeSortProducts=(item:{title:string,value:number})=>{
        page.value=1;
        result.value.products.data=[];
        endLoaded.value=false;
        queries.value['orderBy']=item.value;
    }

    const scroll = () => {
        const loadMore = document.querySelector(`.load-more`);
        if (loadMore) {
            const observer = new IntersectionObserver(
                ([entry]) => {
                    if (entry.isIntersecting) {
                        if(status.value=='success' && !endLoaded.value){
                            page.value++;
                            loadMoreProducts();
                        }
                    }
                },
                { threshold: 0.6 }
            );
            observer.observe(loadMore);
        }
    };

    const loadMoreProducts=()=>{
        status.value='pending';
        let urlWithoutQuery = window.location.origin + window.location.pathname;
        if(queries.value && Object.keys(queries.value).length>0){
            urlWithoutQuery=urlWithoutQuery
                +'?page='+page.value+'&'
                +paramsToQueryString(queries.value);
        }
        window.history.pushState(null, "", urlWithoutQuery);
        $axios.get(getSearchUrl()).then((response)=>{
            status.value='success';
            if(result.value.products){
                result.value.products.data=[
                    ...result.value.products.data,
                    ...response.data.products.data
                ];
            }
            else{
                result.value=response.data;
            }
            if(response.data.products.data.length<10){
                endLoaded.value=true;
            }
        }).catch(()=>{
            status.value='error';
        })
    }

    const paramsToQueryString = (queries:Record<string, any>) => {
        return Object.entries(queries)
            .map(([key, value]) => {
                if (typeof value === "object") {
                    let name=key;
                    const ar=key.toString().split('_');
                    if(ar.length==2){
                        name=ar[0]+'['+ar[1]+']';
                        return Object.entries(value)
                            .map(
                                ([subKey],index) =>`${name}[${index}]=${encodeURIComponent(subKey as string)}`)
                            .join("&");
                    }
                    return Object.entries(value)
                        .map(
                            ([subKey,subValue],index) =>`${name}[${subKey}]=${encodeURIComponent(subValue as string)}`)
                        .join("&");
                }

                return `${key}=${encodeURIComponent(value)}`;
            })
            .join("&");
    };

    const setDefaultQueries=()=>{
        if(window != undefined){
            page.value=1;
            endLoaded.value=false;
            const urlObject = new URL(window.location.href);
            const params = new URLSearchParams(urlObject.search);
            queries.value = Array.from(params.entries()).reduce((acc, [key, value]) => {
                if(key!='page'){
                    const match = key.match(/^(.+?)\[(.+?)\](?:\[(.+?)\])?$/);
                    if (match) {
                        const [_, baseKey, firstKey, secondKey] = match;
                        if (secondKey) {
                            const compoundKey = `${baseKey}_${firstKey}`;
                            acc[compoundKey] = acc[compoundKey] || {};
                            acc[compoundKey][value] = true;
                        } else {
                            acc[baseKey] = acc[baseKey] || {};
                            acc[baseKey][firstKey] = value;
                        }
                    } else {
                        acc[key] = value;
                    }
                }
                return acc;
            }, {} as Record<string, any>);
            if(!queries.value['orderBy']){
                queries.value['orderBy']=21;
            }
        }
    }

    const removeFilters=()=>{
        queries.value={};
    }
    const addOrRemoveFilter=(name:string,value:string)=>{
        queries.value[name] = queries.value[name] || {};
        const entry = Object.entries(queries.value[name])
            .find(([key, selectedValue]) => selectedValue == value);
        const key = entry ? entry[0] : null;
        if (!key){
            queries.value[name][Object.keys(queries.value[name]).length]=
                value;
        }
        else{
            delete queries.value[name][key];
            if (Object.keys(queries.value[name]).length === 0) {
                delete queries.value[name];
            }
        }
    };

    const getSearchUrl=()=>{
        let url= useRuntimeConfig().public.api+requestUrl.value
            +'&page='+page.value;
        if(queries.value && Object.keys(queries.value).length>0){
            url=url+"&"+paramsToQueryString(queries.value);
        }
        return url;
    }

    const updateQueries=(value:Record<string, any>)=>{
        queries.value=value;
    }

    const updateResult=(data:Record<string, any>)=>{
        result.value=data;
        if (data.products?.data?.length < 10) {
            endLoaded.value=true;
        }
    }

    const updateRequestState=(value:string)=>{
        status.value=value;
    }

    const reset=()=>{
        page.value=1;
        endLoaded.value=false;
        updateResult({})
    }

    const updateRequestUrl=(url:string)=>{
        requestUrl.value=url;
    }

    return{
        page,
        queries,
        result,
        sortItems,
        status,
        endLoaded,
        requestUrl,
        appBarTitle,
        updateResult,
        getSearchUrl,
        updateRequestState,
        addOrRemoveFilter,
        removeFilters,
        updateQueries,
        setDefaultQueries,
        loadMoreProducts,
        scroll,
        reset,
        updateRequestUrl,
        changeSortProducts,
    }
});