export const productStore=defineStore('product',()=>{

    const activeMediaPath=ref<string|null>(null);
    const product=ref<Record<string, any>|null>();
    const activeTab=ref(0);
    const descriptionOffcanvas=ref<string>('hide');
    const globalProperties = useNuxtApp().vueApp.config.globalProperties;
    const pageContents=globalProperties['$product:page-content'];
    const tabs = shallowRef([]);
    if(pageContents && process.client){
        tabs.value=globalProperties.$sort(globalProperties['$product:page-content'],'key');
    }
    const updateTab=(key:number)=>{
        activeTab.value=key;
        const el = document.querySelector(`#tab-${key}`);
        if(el){
            el.scrollIntoView({ behavior: 'smooth' });
        }
    }

    const showDescriptionOffcanvas=()=>{
        descriptionOffcanvas.value='show';
    }

    const removeContent = (name:string) => {
        tabs.value = tabs.value.filter((item:{[p:string]:any}) => item.name !== name);
    };

    const showGalleryBox=(path?:string)=>{
        if(path){
            activeMediaPath.value=path;
        }
        else if(product.value!.gallery.length>0){
            activeMediaPath.value=null;
            setTimeout(()=>{
                activeMediaPath.value=product.value!.gallery[0].path;
            },100);
        }
    }

    const updateProduct=(value:Record<string, any>)=>{
        product.value=value;
    }


    return {
        descriptionOffcanvas,
        tabs,
        activeTab,
        product,
        activeMediaPath,
        removeContent,
        showGalleryBox,
        showDescriptionOffcanvas,
        updateTab,
        updateProduct
    }
});