import { defineStore } from 'pinia';
import { useOrderState } from './state';
import { useOrderComputed } from './computed';
import { useOrderActions } from './actions';

export const useOrderStore = defineStore('order', () => {
    const state = useOrderState();
    const computedValues = useOrderComputed(state.data,state.itemsDeducted);
    const actions = useOrderActions(state);

    return {
        ...state,
        ...computedValues,
        ...actions
    };
});
