export const galleryStore=defineStore('gallery',()=> {

    const activeMediaPath=ref<string|null>(null);
    const files=ref<Record<string, any>[]>([]);
    const {api}=useRuntimeConfig().public;
    const {$axios}=useNuxtApp();
    const groups=ref([
        { title:"رسمی", key:"official"}
    ]);
    const commentsMedia=ref<Record<string, any>[]>([]);
    const activeGroup=ref<string>('official');
    const selectedComment=ref<Record<string, any>|null>(null);
    const slideIndex=ref<number>(0);

    const init=(product:Record<string, any>)=>{
        if(!product.videos){
            product.videos=[];
        }
        files.value = [
            ...product.gallery.map((row:Record<string, any>)=> ({
                ...row,
                group:'official'
            })),
            ...product.videos.map((row:Record<string, any>)=> ({
                ...row,
                group:'official'
            })),
        ];
        commentsMedia.value=[];
        activeGroup.value='official';
        groups.value=[
            { title:"رسمی", key:"official"}
        ];
    }

    const getCommentsMedia=(productId:number)=>{
        $axios.get(api+'/product/'+productId+'/comment-media').then((response)=>{
            commentsMedia.value=response.data.data;
            if(Array.isArray(commentsMedia.value) && commentsMedia.value.length>0){
                const rows = commentsMedia.value.flatMap((row, index) =>
                    row.files.map((file:Record<string, any>) => ({
                        path: file.path,
                        group: "buyers",
                        dataIndex: index
                    }))
                );
                files.value = [...files.value, ...rows];
                console.log(rows);
                groups.value.push({
                    title:"خریداران",
                    key:"buyers"
                })
            }
        });
    }

    const onMainSlideChanged=(slide:HTMLElement,index:number)=>{
        activeGroup.value=slide.getAttribute('data-tag')!;
        slideIndex.value=index;
        const commentIndex=parseInt(slide.getAttribute('data-index')!);
        if(commentIndex>=0){
            selectedComment.value=commentsMedia.value[commentIndex];
        }
        else{
            selectedComment.value=null
        }
    }

    const changeMediaType=(key:string,product:Record<string, any>)=>{
        activeGroup.value=key;
        if(activeGroup.value=='official'){
            slideIndex.value=0;
        }
        else{
            slideIndex.value=(
                product!.gallery.length+product!.videos.length
            );
        }
    }

    const slideShowBasedActivePath=(path:string)=>{
        const index=files.value.findIndex((file:Record<string, any>)=>file.path==path);
        if(index){
            slideIndex.value=index;
        }
    }

    return {
        slideShowBasedActivePath,
        onMainSlideChanged,
        getCommentsMedia,
        init,
        changeMediaType,
        activeMediaPath,
        files,
        activeGroup,
        slideIndex,
        selectedComment,
        commentsMedia,
        groups
    }
});