export const commentFormStore = (productId: number) => {
    return defineStore(`comment-form-${productId}`, () => {

        const score=ref<number>();
        const successMessage=ref<string|null>(null);
        const loading=ref(false);

        const formData=ref<{[p:string]:any}>({
            'files':[],
            'body':''
        });

        const updateFormData=(data:Record<string, any>)=>{
            formData.value =data;
        }

        const updateScore=(value:number)=>{
            score.value=value;
        }

        return {
            loading,
            successMessage,
            formData,
            updateFormData,
            score,
            updateScore
        }

    })();
};