import { defineStore } from 'pinia';

export const useAIImageSearch = defineStore('imageSearch', () => {

    const toast = useState('toast');
    const loading = ref<boolean>(false);
    const products=ref<Record<string, any>>([]);
    const { $axios } = useNuxtApp();
    const { api } = useRuntimeConfig().public;
    const maxSizeInBytes = 2 * 1024 * 1024;
    const router=useRouter();

    const uploadImage = async (file: File) => {
        if (!file.type.startsWith('image/')) {
            toast.value = {
                type: 'error',
                message: 'فقط فایل تصویری مجاز است.',
            };
            return;
        }

        if (file.size > maxSizeInBytes) {
            toast.value = {
                type: 'error',
                message: 'حجم تصویر نباید بیشتر از ۲ مگابایت باشد.',
            };
            return;
        }

        await sendUploadRequest(file);
    };

    const sendUploadRequest = async (file: File) => {
        const formData = new FormData();
        formData.append('image', file);
        loading.value = true;
        await router.push('/image-search');
        try {
            const response=await $axios.post(api + '/products/search-by-image', formData, {
                headers: { 'Content-Type': 'multipart/form-data' },
            });
            products.value=response.data;
        }
        catch (error: any) {
            toast.value = {
                type: 'error',
                message: error?.response?.data?.message || 'خطا در آپلود تصویر.',
            };
        }
        finally {
           loading.value = false;
        }
    };

    return {
        products,
        loading,
        uploadImage,
    };
});
