import { defineAsyncComponent } from 'vue'

const UserPanelAppBar = defineAsyncComponent(() => import('@/components/users/panel/AppBar.vue'))

export default defineNuxtPlugin((nuxtApp:any)=>{

    nuxtApp.vueApp.component('userpanel-appbar',UserPanelAppBar);
    const global=nuxtApp.vueApp.config.globalProperties;

    const user=useState<any>('user',()=>'loading');

    global.$addArrayList('start-app:functions',[
        async ()=>{
            if(user.value=='loading'){
                global.$getUser();
            }
        }
    ]);

    global.$getUser=()=>{
        nuxtApp.$axios.get(
            useRuntimeConfig().public.api+'/user'
        ).then((response:any)=>{
            user.value=response.data;
            const afterEvents=global['$user:afterLogin'];
            if(afterEvents){
                afterEvents.forEach((event:()=>void)=>{ event();});
            }
        }).catch(()=>{
            user.value=null;
        });
    }

    global.$addArrayList('user-panel:menus',[
        {
            title:'خلاصه فعالیت',
            icon:['fas', 'house'],
            route:'/profile',
            index:0
        }
    ]);

    global.$addArrayList('user-panel:menus',[
        {
            title:'اطلاعات حساب کاربری',
            icon:['fas', 'user'],
            route:'/profile/personal-info',
            index:7
        }
    ]);

    global.$addArrayList('profile:quick-access',[{
        index:40,
        title:'خروج از حساب کاربری',
        icon:['fas','arrow-right-from-bracket'],
        event:function (){
            const logoutRequest=useState<string>('logout-request');
            logoutRequest.value='hide';
            setTimeout(()=>{
                logoutRequest.value='show';
            },20);
        }
    }]);
});