import { defineAsyncComponent } from 'vue'
import ProductPageAppBar from '@/components/product-page/AppBar.vue'
import ProductPageBottomNavigation from '@/components/product-page/BottomNavigation.vue'
const Introduction = defineAsyncComponent(() => import('../components/product-page/Introduction.vue'))
const SearchProductsAppbar = defineAsyncComponent(() => import('@/components/theme/mobile/SearchProductsAppbar.vue'))
const ProductSlider = defineAsyncComponent(() => import('@/components/theme/widgets/ProductSlider.vue'))
const Banners = defineAsyncComponent(() => import('@/components/theme/widgets/Banners.vue'))
const SelectedCategories = defineAsyncComponent(() => import('~/components/theme/widgets/SelectedCategories.vue'))
const HtmlCode = defineAsyncComponent(() => import('~/components/design/HtmlCode.vue'))
const Paragraph = defineAsyncComponent(() => import('@/components/design/Paragraph.vue'))
const LatestHot = defineAsyncComponent(() => import('~/components/theme/widgets/LatestHot.vue'))

export default defineNuxtPlugin((nuxtApp)=> {

    nuxtApp.vueApp.component('product-page-appbar',ProductPageAppBar);
    nuxtApp.vueApp.component('search-products-appbar',SearchProductsAppbar);
    nuxtApp.vueApp.component('ProductSlider',ProductSlider);
    nuxtApp.vueApp.component('Banners',Banners);
    nuxtApp.vueApp.component('selected-categories',SelectedCategories);
    nuxtApp.vueApp.component('HtmlCode',HtmlCode);
    nuxtApp.vueApp.component('Paragraph',Paragraph);
    nuxtApp.vueApp.component('LatestHot',LatestHot);

    const global=nuxtApp.vueApp.config.globalProperties;
    global.$addArrayList('product:page-content', [
        {
            title: 'معرفی',
            component: Introduction,
            key: 0,
            name:'introduction',
            type:'description'
        }
    ]);
    nuxtApp.vueApp.component(
        'product-page-bottom-navigation',
        ProductPageBottomNavigation
    );

    global.$getProductPath = (product: Record<string, any> | null) => {
        const setting = useState<Record<string, any>>('shopSetting');
        if (product != null && setting) {
            let path = '/product/' + setting.value['sku_code'] + '-' + product.id + '/' + product.slug;

            if (product.query && typeof product.query === 'object') {
                const queryString = new URLSearchParams(product.query).toString();
                if (queryString) {
                    path += '?' + queryString;
                }
            }
            return path;
        } else {
            return '/';
        }
    };

});
