import { defineAsyncComponent } from 'vue'

const StatisticsLastWeekSales = defineAsyncComponent(() => import('@/components/statistics/LastWeekSales.vue'))
const StatisticsRecentDay = defineAsyncComponent(() => import('@/components/statistics/RecentDay.vue'))

export default defineNuxtPlugin((nuxtApp)=>{

    const global=useNuxtApp().vueApp.config.globalProperties;

    nuxtApp.vueApp.component('StatisticsLastWeekSales',
        StatisticsLastWeekSales
    );

    nuxtApp.vueApp.component('StatisticsRecentDay',
        StatisticsRecentDay
    );

    global.$addArrayList('start-app:functions',[
        ()=>{
            setTimeout(()=>{
                useNuxtApp().$axios.get(
                    useRuntimeConfig().public.api+'/statistics/visits/update'
                );
            },2000);
        }
    ]);
});