import { defineAsyncComponent } from 'vue'

const ProductSpecifications = defineAsyncComponent(() => import('../components/specifications/Product.vue'))
const ShortCode = defineAsyncComponent(() => import('~/components/specifications/ShortCode.vue'))

export default defineNuxtPlugin((nuxtApp)=>{
    const global=nuxtApp.vueApp.config.globalProperties;
    global.$addArrayList('product:page-content', [
        {
            title: 'مشخصات',
            component:ProductSpecifications,
            key: 2,
            name:'specifications',
            type:'description'
        }
    ]);

    nuxtApp.vueApp.config.globalProperties.$addArrayList('product:page-options',[
        {
            index:5,
            component:ShortCode
        }
    ]);
});