import { defineAsyncComponent } from 'vue'

const SellersFilterItem = defineAsyncComponent(() => import('@/components/sellers/FilterItem.vue'));

export default defineNuxtPlugin((nuxtApp)=> {
    const global= nuxtApp.vueApp.config.globalProperties;
    global.$addArrayList('filters:options', [
        {
            title:'ارسال فروشنده',
            component:SellersFilterItem,
            index:5,
            param:'has_ship_by_seller',
            child:false
        }
    ]);
});