import { defineAsyncComponent } from 'vue'

const AddCommentBuyer = defineAsyncComponent(() => import('~/components/comment/AddCommentBuyer.vue'))
const ProductPage = defineAsyncComponent(() => import('~/components/comment/ProductPage.vue'))

export default defineNuxtPlugin((nuxtApp)=> {
    const global=nuxtApp.vueApp.config.globalProperties;
    global.$addArrayList('user-panel:menus',[
        {
            title:'دیدگاه ها',
            icon:['far', 'comment'],
            route:'/profile/comments',
            index:15
        }
    ]);

    global.$addArrayList('submission-product:footer',[
       AddCommentBuyer
    ]);

    global.$addArrayList('profile:quick-access',[{
        index:15,
        title:'دیدگاه ها و پرسش ها',
        icon:['far','comment'],
        route:'/panel/comments'
    }]);

    global.$addArrayList('product:page-content', [
        {
            title: 'دیدگاه ها',
            component:ProductPage,
            key: 5,
            name:'comments',
        }
    ]);
});