import { defineAsyncComponent } from 'vue'

const ColorShow = defineAsyncComponent(() => import('../components/color/Show.vue'))
const SelectComponent = defineAsyncComponent(() => import('@/components/color/SelectComponent.vue'))

export default defineNuxtPlugin((nuxtApp)=> {

    const global=nuxtApp.vueApp.config.globalProperties;
    global.$ColorShowComponent = ColorShow;

    nuxtApp.vueApp.config.globalProperties.$addArrayList('variation:items',[
        {
            title:'رنگ',
            model:'\\Modules\\Colors\\Models\\Color',
            component:SelectComponent
        }
    ]);
});