import { defineAsyncComponent } from 'vue'

const SearchSelectionCategory = defineAsyncComponent(() => import('@/components/categories/SearchSelectionCategory.vue'))

export default defineNuxtPlugin((nuxtApp)=>{

    const global=nuxtApp.vueApp.config.globalProperties;

    global.$getCategoryFromSlug=(slug:string)=>{
        const categories=useState<Record<string, any>[]>('categories');
        return categories.value.find((category)=>category.slug===slug);
    }
    global.$getCategoryFromId=(id:number)=>{
        const categories=useState<Record<string, any>[]>('categories');
        return categories.value.find((category)=>category.id===id);
    }

    global.$addArrayList('filters:options', [
        {
            title:'دسته بندی ها',
            component:SearchSelectionCategory,
            index:-1,
            param:'categories',
            whereAdd:(category_id:number)=>{
                const categories=useState<Record<string, any>[]>('categories');
                const category=categories.value.find((row)=>row.id==category_id);
                return category && category.parent_id==0;
            }
        }
    ]);
});
