import { defineAsyncComponent } from 'vue'

const SearchSelectionCategory = defineAsyncComponent(() => import('@/components/brands/SearchSelectionCategory.vue'))
const PopularBrands = defineAsyncComponent(() => import('@/components/brands/Slider.vue'))
const SearchSelectBrand = defineAsyncComponent(() => import('@/components/brands/SearchSelectBrand.vue'))

export default defineNuxtPlugin((nuxtApp)=> {

    const global= nuxtApp.vueApp.config.globalProperties;

    global.$addArrayList('filters:options', [
        {
            title:'برند ها',
            component:SearchSelectBrand,
            index:-2,
            param:'brands',
            whereAdd:(category_id:number)=>{
                const categories=useState<Record<string, any>[]>('categories');
                const category=categories.value.find((row)=>row.id==category_id);
                return category && category.parent_id!=0;
            }
        },
        {
            title:'دسته بندی ها',
            component:SearchSelectionCategory,
            index:-1,
            param:'brand-categories',
            whereAdd:(category_id:number)=>{
                return useRoute().path.toString().indexOf('brand')>0;
            }
        }
    ]);

    nuxtApp.vueApp.component('popular-brands',PopularBrands);
});