import axios from "axios";
import useApiQuery from '~/functions/apiQuery.js';
export default defineNuxtPlugin(()=>{
    const axiosInstance=axios.create({
        withCredentials:true,
        withXSRFToken:true
    });
    axiosInstance.interceptors.response.use(function (response){
        return response;
    },function (error){
        return Promise.reject(error);
    });
    return{
        provide:{
            axios:axiosInstance,
            cacheQuery:useApiQuery
        }
    }
});