import { defineAsyncComponent } from 'vue'

const SelectDefault = defineAsyncComponent(() => import('~/components/area/SelectDefault.vue'))
export default defineNuxtPlugin((nuxtApp)=>{

    const global=nuxtApp.vueApp.config.globalProperties;

    global.$addArrayList('start-app:functions',[
        async ()=> {
            const provinces=useState("provinces");
            const {data:provincesList}=await useAsyncData('provinces', () =>
                $fetch('/api/provinces')
            );
            // const {data:provincesList}=await useFetch(
            //     useRuntimeConfig().public.api+'/provinces'
            // );
            provinces.value=provincesList;
        }
    ]);

    global.$addArrayList('start-app:functions',[
        async ()=>{
            const cities=useState("cities");
            const {data:citiesList}=await useAsyncData('cities', () =>
                $fetch('/api/cities')
            );
            // const {data:citiesList}=await useFetch(
            //     useRuntimeConfig().public.api+'/cities/all'
            // );
            cities.value=citiesList;
        }
    ]);

    global.$getCityName=(cityId)=>{
        let cityName='';
        const cities=useState('cities');
        if(cities.value){
            const find=cities.value.find((city)=>city.id===cityId);
            if(find){
                cityName=find.name;
            }
        }
        return cityName;
    }

    global.$addArrayList('appbar-content',[
        SelectDefault
    ]);
});