import { defineAsyncComponent } from 'vue'

const FetchProducts = defineAsyncComponent(() => import('~/components/ads/FetchProducts.vue'))
const ShowProductAdsLabel = defineAsyncComponent(() => import('~/components/ads/ShowProductAdsLabel.vue'))
const ShowAdsInSidebar = defineAsyncComponent(() => import('~/components/ads/ShowAdsInSidebar.vue'))

export default defineNuxtPlugin((nuxtApp)=> {

    const global=nuxtApp.vueApp.config.globalProperties;
    global.$addArrayList('products-search:after-list',[
        {
            component:FetchProducts,
            index:0
        }
    ]);
    global.$addArrayList('product-search-view:before-view',[
        {
            component:ShowProductAdsLabel,
            index:0
        }
    ]);

    global.$addArrayList('products-search:before-sidebar',[
        {
            component:ShowAdsInSidebar,
            index:0
        }
    ]);

});