import { defineAsyncComponent } from 'vue'

const SelectionList = defineAsyncComponent(() => import('@/components/addresses/SelectionList.vue'))
export default defineNuxtPlugin((nuxtApp)=> {
    const global=nuxtApp.vueApp.config.globalProperties;
    global.$addArrayList('user-panel:menus',[
        {
            title:'آدرس ها',
            icon:['far', 'address-card'],
            route:'/profile/addresses',
            index:5
        }
    ]);
    global.$addArrayList('profile:quick-access',[{
        index:5,
        title:'آدرس ها',
        icon:['fas','fa-location-dot'],
        route:'/profile/addresses'
    }]);

    global.$addArrayList('shipping-page:content',[{
        index:0,
        component:SelectionList
    }]);
});