import _ from 'lodash';
export default defineNuxtPlugin((nuxtApp)=>{

    const global=nuxtApp.vueApp.config.globalProperties;

    global.$addArrayList=function (name:string,list:any[]){
        if(nuxtApp.vueApp.config.globalProperties['$'+name]==undefined){
            nuxtApp.vueApp.config.globalProperties['$'+name]=list;
        }
        else{
            nuxtApp.vueApp.config.globalProperties['$'+name]=[
                ...nuxtApp.vueApp.config.globalProperties['$'+name],
                ...list
            ];
        }
    }

    global.$sort=function (array:any[] ,key:string,order='asc'){
        //@ts-ignore
        return _.orderBy(array,key,order);
    }

    global.$numberFormat=(number:string|number,separator=',',count=3)=>{
        if(number){
            number=number.toString();
            let format='';
            let counter=0;
            for (let i =number.length-1; i >=0 ; i--) {
                format+=number[i];
                counter++;
                if(counter==count && i!=0){
                    format+=separator;
                    counter=0;
                }
            }
            number=format.split('').reverse().join('');
        }
        return number;
    }

    global.$replaceEnNumber=(number:string|number):string|number=>{
        if(number || number===0){
            number=number.toString();
            const find=['0','1','2','3','4','5','6','7','8','9'];
            const replace = ["۰", "۱", "۲", "۳", "۴", "۵", "۶", "۷", "۸", "۹"];
            for (let i=0;i<find.length;i++){
                number=number.replace(
                    new RegExp(find[i],'g'),
                    replace[i]
                );
            }
        }
        return number;
    };

    global.$replaceFaNumber=function (number:string|number|undefined){
        if(number){
            number=number.toString();
            const replace=['0','1','2','3','4','5','6','7','8','9'];
            const find = ["۰", "۱", "۲", "۳", "۴", "۵", "۶", "۷", "۸", "۹"];
            for (let i=0;i<find.length;i++){
                number=number.replace(
                    new RegExp(find[i],'g'),
                    replace[i]
                );
            }
        }
        return number;
    }

    global.$outsideClick=(elId:string,callback:(el:HTMLElement)=>void)=>{
        document.body.addEventListener('mouseup', (event: MouseEvent) => {
            const el = document.querySelector('#' + elId) as HTMLElement | null;
            if (el && !el.contains(event.target as Node)) {
                callback(el);
            }
        });
    }

    global.$serverErrors =(error: any): string[]=>{
        let errors:string[]=[];
        if (error.response && error.response.status !== 401) {
            const validateErrors = error.response.data.errors;
            if (validateErrors) {
                Object.values(validateErrors).forEach((err) => {
                    if (Array.isArray(err) && err.length > 0) {
                        errors.push(err[0]);
                    }
                });
            }

            if (errors.length === 0) {
                errors.push('خطا در ارتباط با سرور، مجددا تلاش نمایید');
            }
        }
        return errors;
    };

});