import * as _nuxt_schema from '@nuxt/schema';

declare module '@nuxt/schema' {
    interface AppConfigInput {
        __swiper?: Readonly<{
            bundled: boolean;
        }>;
    }
}
interface ModuleOptions {
    /**
     * Enable custom Swiper composables to help you access Swiper instance.
     * @example ```vue
     * <script setup>
     * const swiperRef = ref<null>(null)
     * const swiper = useSwiper(swiperRef, { loop: true, autoplay: { delay: 5000 })
     *
     * const next = () => swiper.next()
     * </script>
     * <template>
     *  <swiper-container ref="swiperRef" :init="false">
     *    <swiper-slide>Slide 1</swiper-slide>
     *    <swiper-slide>Slide 2</swiper-slide>
     *  </swiper-container>
     * </template>
     * ```
     * @default true
     */
    enableComposables?: boolean;
    /**
     * Bundle Swiper custom elements.
     * if disabled, you need to import swiper css and modules manually.
     * @see https://swiperjs.com/element#core-version--modules
     * @default true
     */
    bundled?: boolean;
}
declare const _default: _nuxt_schema.NuxtModule<ModuleOptions, ModuleOptions, false>;

export { _default as default };
export type { ModuleOptions };
