import { readdirSync } from 'fs'
import { resolve } from 'path'
import { defineNuxtModule, addPlugin, addTemplate } from '@nuxt/kit'
import { fileURLToPath } from 'node:url';
/**

 * This will let us map aliases to highcharts modules
 * (vite will need this to statically analyze the imports)
 * i.e., it can't analyze import(`highcharts/modules/${modName}.js`)
 */
const hcModDir = resolve('./node_modules/highcharts/modules')
let fns = 'export default {\r\n'
const hcMods = readdirSync(hcModDir)
  .filter(f => f.endsWith('.js') && !f.endsWith('.src.js'))
  .map((f) => {
    const mod = f.replace(/.js$/, '')
    fns += `'${mod}': () => import('highcharts/modules/${f}'),\r\n`
    return mod
  })
fns += '}'

function includeDeps (nuxt, deps) {
  /* c8 ignore start */
  if (!nuxt.options.vite) {
    nuxt.options.vite = {}
  }

  if (!nuxt.options.vite.optimizeDeps) {
    nuxt.options.vite.optimizeDeps = {}
  }
  if (!nuxt.options.vite.optimizeDeps.include) {
    nuxt.options.vite.optimizeDeps.include = []
  }
  nuxt.options.vite.optimizeDeps.include.push(...deps)
  /* c8 ignore stop */
}

export default defineNuxtModule({
  /**
   * @param {import('./types').ModuleOptions} moduleOptions
   * @param {import('@nuxt/schema').Nuxt} nuxt
   */
  setup (moduleOptions, nuxt) {
    const options = {
      ...nuxt.options.highcharts,
      ...moduleOptions
    }
    includeDeps(nuxt, [
      'highcharts',
      'highcharts/highcharts-more.js',
      'highcharts/indicators/indicators-all.src.js'
    ])

    nuxt.options.build.transpile.push(fileURLToPath(import.meta.url))
    nuxt.options.runtimeConfig.public.nuxtHighcharts = {
      pluginOptions: options,
      hcMods
    }

    // TBD: Nuxt3
    // To use, import hcMods from '#build/nuxt-highcharts.hcMods.js'
    // Lazy import:
    // const importedMod = await hcMods[modName]() ... will import
    addTemplate({
      filename: 'nuxt-highcharts.hcMods.js',
      getContents: () => fns
    })

    addTemplate({
      src: fileURLToPath(new URL('./components.js', import.meta.url)),
      filename: 'nuxt-highcharts.components.js'
    })

    addPlugin({
      ssr: false,
      src: fileURLToPath(new URL('./plugin.js', import.meta.url)),
    })
  }
})
