import { defineNuxtModule, createResolver, addComponent, addImports } from '@nuxt/kit';

const components = [
  "LCircle",
  "LCircleMarker",
  "LControl",
  "LControlAttribution",
  "LControlLayers",
  "LControlScale",
  "LControlZoom",
  "LFeatureGroup",
  "LGeoJson",
  "LIcon",
  "LImageOverlay",
  "LLayerGroup",
  "LMap",
  "LMarker",
  "LPolygon",
  "LPolyline",
  "LPopup",
  "LRectangle",
  "LTileLayer",
  "LTooltip",
  "LWmsTileLayer"
];
const module = defineNuxtModule({
  meta: {
    name: "nuxt-leaflet",
    configKey: "leaflet",
    compatibility: {
      nuxt: ">=3.0.0"
    }
  },
  // Default configuration options of the Nuxt module
  defaults: {},
  async setup(options, nuxt) {
    const resolver = createResolver(import.meta.url);
    nuxt.options.css.push("leaflet/dist/leaflet.css");
    for (const component of components) {
      addComponent({
        name: component,
        export: component,
        filePath: "@vue-leaflet/vue-leaflet",
        chunkName: `nuxt-leaflet/${component}`,
        mode: "all"
      });
    }
    if (options.markerCluster) {
      nuxt.options.css.push("leaflet.markercluster/dist/MarkerCluster.css");
      nuxt.options.css.push("leaflet.markercluster/dist/MarkerCluster.Default.css");
      addImports({
        name: "useLMarkerCluster",
        as: "useLMarkerCluster",
        from: resolver.resolve("runtime/composables/useLMarkerCluster")
      });
    }
    if (options.heat) {
      addImports({
        name: "useLHeat",
        as: "useLHeat",
        from: resolver.resolve("runtime/composables/useLHeat")
      });
    }
  }
});

export { components, module as default };
