import { type PropType } from 'vue';
import { PersianDate } from './utils/modules/core';
import type { Obj, Attrs, Langs, RecursivePartial, Styles, Inputs, PickerPlace, TypePart, CalendarPart, Disable, Formats, MonthDays, Months, Shortcuts, DefaultDate } from './utils/modules/types';
export { PersianDate };
declare const _default: import("vue").DefineComponent<import("vue").ExtractPropTypes<{
    /**
     * the format of the model value
     * @type String
     * @see https://alireza-ab.ir/persian-date/formats#
     * @desc default value in "date" type is "YYYY-MM-DD"
     * 		default value in "datetime" type is "YYYY-MM-DD HH:mm"
     * 		default value in "time" type is "HH:mm"
     */
    format: {
        type: StringConstructor;
    };
    /**
     * the format of the input value
     * @type String
     * @see https://alireza-ab.ir/persian-date/formats#
     * @desc default value equal to the value of "type" prop
     */
    inputFormat: {
        type: StringConstructor;
    };
    /**
     * the format of the value that shows in the footer of picker
     * @type String
     * @see https://alireza-ab.ir/persian-date/formats#
     * @desc default value in "date" type is "?D ?MMMM"
     * 		default value in "datetime" type is "?D ?MMMM HH:mm"
     * 		default value in "time" type is "HH:mm"
     */
    displayFormat: {
        type: StringConstructor;
    };
    /**
     * the type of picker
     * @default "date"
     * @type String
     * @values date | time | datetime
     * @since 2.0.0
     */
    type: {
        type: PropType<"date" | "time" | "datetime">;
        default: string;
        validator: (val: string) => boolean;
    };
    /**
     * the date of start of the picker
     * @type String
     * @example 1400/7/1 | 1400-7
     */
    from: {
        type: StringConstructor;
        default: (props: Obj) => "" | "1300";
    };
    /**
     * the date of end of the picker
     * @type String
     * @example 1400/7/1 | 1400-7
     */
    to: {
        type: StringConstructor;
        default: (props: Obj) => "23:59" | "1499";
    };
    /**
     * show or hide the picker
     * @default false
     * @type Boolean
     */
    show: {
        default: boolean;
        type: BooleanConstructor;
    };
    /**
     * show the picker with click on the some sections
     * @default "all"
     * @type String
     * @values all | input | icon | none
     */
    clickOn: {
        default: string;
        type: PropType<"all" | "input" | "icon" | "none">;
        validator: (val: string) => boolean;
    };
    /**
     * show the picker in modal mode
     * @default true
     * @type Boolean
     */
    modal: {
        default: boolean;
        type: BooleanConstructor;
    };
    /**
     * text for label tag
     * @type String
     */
    label: {
        type: StringConstructor;
    };
    /**
     * number of column
     * @default "{ 576: 1 }"
     * @type Object | Number
     * @desc 1. you can send the number of column
     *  	or send the object of the number of
     *  	column in the breakpoint.
     * 		2. if the breaking point in the object
     * 		is not specified, the default value it's 2
     */
    column: {
        default: () => {
            576: number;
        };
        type: PropType<number | Record<number, number>>;
    };
    /**
     * submit when date selected or not
     * @default true
     * @type Boolean
     */
    autoSubmit: {
        default: boolean;
        type: BooleanConstructor;
    };
    /**
     * mode of select date
     * @default "range"
     * @type String
     * @values range | single
     */
    mode: {
        default: string;
        type: PropType<"single" | "range">;
        validator: (val: string) => boolean;
    };
    /**
     * the locale of datepicker
     * @default "fa"
     * @type String
     * @values fa | en | fa,en |  en,fa
     * @desc Except above values, you can add
     *  	the language in "localeConfig" prop and use it.
     * @since 2.0.0
     */
    locale: {
        default: string;
        type: StringConstructor;
    };
    /**
     * user can clear the selected dates or not
     * @default false
     * @type Boolean
     * @since 2.0.0
     */
    clearable: {
        default: boolean;
        type: BooleanConstructor;
    };
    /**
     * disable some dates or time
     * @type [Array, String, Function, RegExp]
     * @since 2.0.0
     */
    disable: {
        type: PropType<Disable>;
    };
    /**
     * the config for locales
     * @type Object
     * @since 2.0.0
     */
    localeConfig: {
        type: PropType<RecursivePartial<Langs>>;
    };
    /**
     * the styles of the picker
     * @type Object
     * @since 2.0.0
     */
    styles: {
        type: PropType<Styles>;
    };
    /**
     * the color of the picker
     * @type String
     * @values red | pink | orange | green | purple | gray
     * @since 2.0.0
     */
    color: {
        type: PropType<"blue" | "red" | "pink" | "orange" | "green" | "purple" | "gray">;
        validator: (val: string) => boolean;
    };
    /**
     * use two input for dispaly
     * @type Boolean
     * @default false
     * @since 2.2.0
     */
    dualInput: {
        type: BooleanConstructor;
        default: boolean;
    };
    /**
     * show icon inside of input
     * @type Boolean
     * @default false
     * @since 2.2.0
     */
    iconInside: {
        type: BooleanConstructor;
        default: boolean;
    };
    /**
     * shortcut for select date and time quickly
     * @type Boolean | Object
     * @since 2.2.0
     */
    shortcut: {
        type: PropType<boolean | Shortcuts>;
        default: boolean;
    };
}>, {}, {
    core: PersianDate;
    onDisplay: PersianDate | undefined;
    fromDate: PersianDate | undefined;
    toDate: PersianDate | undefined;
    selectedDates: PersianDate[];
    selectedTimes: PersianDate[];
    showDatePicker: boolean;
    showYearSelect: boolean;
    showMonthSelect: boolean;
    showTopOfInput: boolean;
    displayValue: string[];
    inputName: Inputs;
    pickerPlace: PickerPlace;
    documentWidth: number;
    langs: Langs;
    currentLocale: string;
    interval: ReturnType<typeof setInterval> | null;
    submitedValue: PersianDate[];
}, {
    lang(): Langs[string];
    attrs(): Attrs;
    years(): number[];
    columnCount(): number;
    monthDays(): MonthDays[][];
    months(): Months;
    nextLocale(): string;
    formats(): Formats;
    defaultDate(): DefaultDate;
    inputs(): Inputs[];
    tabIndex(): number | undefined;
    shortcuts(): Shortcuts | false;
}, {
    showPart(part: CalendarPart): void;
    changeSelectedMonth(month: "add" | "sub" | number): void;
    changeSelectedYear(year: number): void;
    validate(date: PersianDate, part: TypePart): boolean;
    isDisableBetween(first: PersianDate, second: PersianDate): boolean;
    selectDate(date: PersianDate, part: TypePart): number;
    setModel(date?: PersianDate | PersianDate[] | string | string[]): void;
    goToToday(): void;
    checkDate(date: unknown, part: CalendarPart | TypePart): boolean;
    isInDisable(date: PersianDate, disable?: Disable): boolean;
    showPicker(el: "icon" | "input", index: 0 | 1): void;
    selectWithArrow(e: KeyboardEvent): Promise<void>;
    selectInRangeDate(e: any): void;
    submitDate(close?: boolean): void;
    getColumn({ parentNode }: HTMLElement): number | string;
    nearestDate(date: PersianDate): PersianDate;
    locate(): void;
    changeLocale(): void;
    clear(inputName: Inputs): void;
    startChangeTime(timeIndex: number, unit: "minute" | "hour", operator: "add" | "sub"): void;
    stopChangeTime(): void;
    selectShorcut(dates: PersianDate[]): void;
    setDate(dates: string | string[]): void;
}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, ("open" | "clear" | "select" | "close" | "submit" | "update:modelValue")[], "open" | "clear" | "select" | "close" | "submit" | "update:modelValue", import("vue").PublicProps, Readonly<import("vue").ExtractPropTypes<{
    /**
     * the format of the model value
     * @type String
     * @see https://alireza-ab.ir/persian-date/formats#
     * @desc default value in "date" type is "YYYY-MM-DD"
     * 		default value in "datetime" type is "YYYY-MM-DD HH:mm"
     * 		default value in "time" type is "HH:mm"
     */
    format: {
        type: StringConstructor;
    };
    /**
     * the format of the input value
     * @type String
     * @see https://alireza-ab.ir/persian-date/formats#
     * @desc default value equal to the value of "type" prop
     */
    inputFormat: {
        type: StringConstructor;
    };
    /**
     * the format of the value that shows in the footer of picker
     * @type String
     * @see https://alireza-ab.ir/persian-date/formats#
     * @desc default value in "date" type is "?D ?MMMM"
     * 		default value in "datetime" type is "?D ?MMMM HH:mm"
     * 		default value in "time" type is "HH:mm"
     */
    displayFormat: {
        type: StringConstructor;
    };
    /**
     * the type of picker
     * @default "date"
     * @type String
     * @values date | time | datetime
     * @since 2.0.0
     */
    type: {
        type: PropType<"date" | "time" | "datetime">;
        default: string;
        validator: (val: string) => boolean;
    };
    /**
     * the date of start of the picker
     * @type String
     * @example 1400/7/1 | 1400-7
     */
    from: {
        type: StringConstructor;
        default: (props: Obj) => "" | "1300";
    };
    /**
     * the date of end of the picker
     * @type String
     * @example 1400/7/1 | 1400-7
     */
    to: {
        type: StringConstructor;
        default: (props: Obj) => "23:59" | "1499";
    };
    /**
     * show or hide the picker
     * @default false
     * @type Boolean
     */
    show: {
        default: boolean;
        type: BooleanConstructor;
    };
    /**
     * show the picker with click on the some sections
     * @default "all"
     * @type String
     * @values all | input | icon | none
     */
    clickOn: {
        default: string;
        type: PropType<"all" | "input" | "icon" | "none">;
        validator: (val: string) => boolean;
    };
    /**
     * show the picker in modal mode
     * @default true
     * @type Boolean
     */
    modal: {
        default: boolean;
        type: BooleanConstructor;
    };
    /**
     * text for label tag
     * @type String
     */
    label: {
        type: StringConstructor;
    };
    /**
     * number of column
     * @default "{ 576: 1 }"
     * @type Object | Number
     * @desc 1. you can send the number of column
     *  	or send the object of the number of
     *  	column in the breakpoint.
     * 		2. if the breaking point in the object
     * 		is not specified, the default value it's 2
     */
    column: {
        default: () => {
            576: number;
        };
        type: PropType<number | Record<number, number>>;
    };
    /**
     * submit when date selected or not
     * @default true
     * @type Boolean
     */
    autoSubmit: {
        default: boolean;
        type: BooleanConstructor;
    };
    /**
     * mode of select date
     * @default "range"
     * @type String
     * @values range | single
     */
    mode: {
        default: string;
        type: PropType<"single" | "range">;
        validator: (val: string) => boolean;
    };
    /**
     * the locale of datepicker
     * @default "fa"
     * @type String
     * @values fa | en | fa,en |  en,fa
     * @desc Except above values, you can add
     *  	the language in "localeConfig" prop and use it.
     * @since 2.0.0
     */
    locale: {
        default: string;
        type: StringConstructor;
    };
    /**
     * user can clear the selected dates or not
     * @default false
     * @type Boolean
     * @since 2.0.0
     */
    clearable: {
        default: boolean;
        type: BooleanConstructor;
    };
    /**
     * disable some dates or time
     * @type [Array, String, Function, RegExp]
     * @since 2.0.0
     */
    disable: {
        type: PropType<Disable>;
    };
    /**
     * the config for locales
     * @type Object
     * @since 2.0.0
     */
    localeConfig: {
        type: PropType<RecursivePartial<Langs>>;
    };
    /**
     * the styles of the picker
     * @type Object
     * @since 2.0.0
     */
    styles: {
        type: PropType<Styles>;
    };
    /**
     * the color of the picker
     * @type String
     * @values red | pink | orange | green | purple | gray
     * @since 2.0.0
     */
    color: {
        type: PropType<"blue" | "red" | "pink" | "orange" | "green" | "purple" | "gray">;
        validator: (val: string) => boolean;
    };
    /**
     * use two input for dispaly
     * @type Boolean
     * @default false
     * @since 2.2.0
     */
    dualInput: {
        type: BooleanConstructor;
        default: boolean;
    };
    /**
     * show icon inside of input
     * @type Boolean
     * @default false
     * @since 2.2.0
     */
    iconInside: {
        type: BooleanConstructor;
        default: boolean;
    };
    /**
     * shortcut for select date and time quickly
     * @type Boolean | Object
     * @since 2.2.0
     */
    shortcut: {
        type: PropType<boolean | Shortcuts>;
        default: boolean;
    };
}>> & Readonly<{
    onSubmit?: (...args: any[]) => any;
    onSelect?: (...args: any[]) => any;
    onClose?: (...args: any[]) => any;
    onOpen?: (...args: any[]) => any;
    onClear?: (...args: any[]) => any;
    "onUpdate:modelValue"?: (...args: any[]) => any;
}>, {
    type: "time" | "date" | "datetime";
    show: boolean;
    mode: "range" | "single";
    to: string;
    column: number | Record<number, number>;
    from: string;
    clickOn: "input" | "all" | "none" | "icon";
    modal: boolean;
    autoSubmit: boolean;
    locale: string;
    clearable: boolean;
    dualInput: boolean;
    iconInside: boolean;
    shortcut: boolean | Shortcuts;
}, {}, {
    PDPArrow: import("vue").DefineComponent<import("vue").ExtractPropTypes<{
        direction: {
            default: string;
            type: PropType<"left" | "right" | "up" | "down">;
        };
        inverse: {
            default: boolean;
            type: BooleanConstructor;
        };
    }>, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<import("vue").ExtractPropTypes<{
        direction: {
            default: string;
            type: PropType<"left" | "right" | "up" | "down">;
        };
        inverse: {
            default: boolean;
            type: BooleanConstructor;
        };
    }>> & Readonly<{}>, {
        inverse: boolean;
        direction: "left" | "right" | "up" | "down";
    }, {}, {}, {}, string, import("vue").ComponentProvideOptions, true, {}, any>;
    PDPIcon: import("vue").DefineComponent<import("vue").ExtractPropTypes<{
        icon: {
            type: PropType<"clear" | "date" | "datetime" | "time">;
            required: true;
        };
    }>, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<import("vue").ExtractPropTypes<{
        icon: {
            type: PropType<"clear" | "date" | "datetime" | "time">;
            required: true;
        };
    }>> & Readonly<{}>, {}, {}, {}, {}, string, import("vue").ComponentProvideOptions, true, {}, any>;
    PDPAlt: import("vue").DefineComponent<import("vue").ExtractPropTypes<{
        name: {
            type: StringConstructor;
            required: true;
        };
        format: {
            type: StringConstructor;
            required: true;
        };
        dates: {
            type: PropType<PersianDate[]>;
            required: true;
        };
    }>, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<import("vue").ExtractPropTypes<{
        name: {
            type: StringConstructor;
            required: true;
        };
        format: {
            type: StringConstructor;
            required: true;
        };
        dates: {
            type: PropType<PersianDate[]>;
            required: true;
        };
    }>> & Readonly<{}>, {}, {}, {}, {}, string, import("vue").ComponentProvideOptions, true, {}, any>;
}, {}, string, import("vue").ComponentProvideOptions, true, {}, any>;
export default _default;
declare module 'vue' {
    interface GlobalComponents {
    }
    interface GlobalDirectives {
    }
}
declare global {
    const __VLS_intrinsicElements: __VLS_IntrinsicElements;
    const __VLS_directiveBindingRestFields: {
        instance: null;
        oldValue: null;
        modifiers: any;
        dir: any;
    };
    const __VLS_unref: typeof import('vue').unref;
    const __VLS_placeholder: any;
    const __VLS_nativeElements: {
        a: HTMLAnchorElement;
        abbr: HTMLElement;
        address: HTMLElement;
        area: HTMLAreaElement;
        article: HTMLElement;
        aside: HTMLElement;
        audio: HTMLAudioElement;
        b: HTMLElement;
        base: HTMLBaseElement;
        bdi: HTMLElement;
        bdo: HTMLElement;
        blockquote: HTMLQuoteElement;
        body: HTMLBodyElement;
        br: HTMLBRElement;
        button: HTMLButtonElement;
        canvas: HTMLCanvasElement;
        caption: HTMLTableCaptionElement;
        cite: HTMLElement;
        code: HTMLElement;
        col: HTMLTableColElement;
        colgroup: HTMLTableColElement;
        data: HTMLDataElement;
        datalist: HTMLDataListElement;
        dd: HTMLElement;
        del: HTMLModElement;
        details: HTMLDetailsElement;
        dfn: HTMLElement;
        dialog: HTMLDialogElement;
        div: HTMLDivElement;
        dl: HTMLDListElement;
        dt: HTMLElement;
        em: HTMLElement;
        embed: HTMLEmbedElement;
        fieldset: HTMLFieldSetElement;
        figcaption: HTMLElement;
        figure: HTMLElement;
        footer: HTMLElement;
        form: HTMLFormElement;
        h1: HTMLHeadingElement;
        h2: HTMLHeadingElement;
        h3: HTMLHeadingElement;
        h4: HTMLHeadingElement;
        h5: HTMLHeadingElement;
        h6: HTMLHeadingElement;
        head: HTMLHeadElement;
        header: HTMLElement;
        hgroup: HTMLElement;
        hr: HTMLHRElement;
        html: HTMLHtmlElement;
        i: HTMLElement;
        iframe: HTMLIFrameElement;
        img: HTMLImageElement;
        input: HTMLInputElement;
        ins: HTMLModElement;
        kbd: HTMLElement;
        label: HTMLLabelElement;
        legend: HTMLLegendElement;
        li: HTMLLIElement;
        link: HTMLLinkElement;
        main: HTMLElement;
        map: HTMLMapElement;
        mark: HTMLElement;
        menu: HTMLMenuElement;
        meta: HTMLMetaElement;
        meter: HTMLMeterElement;
        nav: HTMLElement;
        noscript: HTMLElement;
        object: HTMLObjectElement;
        ol: HTMLOListElement;
        optgroup: HTMLOptGroupElement;
        option: HTMLOptionElement;
        output: HTMLOutputElement;
        p: HTMLParagraphElement;
        picture: HTMLPictureElement;
        pre: HTMLPreElement;
        progress: HTMLProgressElement;
        q: HTMLQuoteElement;
        rp: HTMLElement;
        rt: HTMLElement;
        ruby: HTMLElement;
        s: HTMLElement;
        samp: HTMLElement;
        script: HTMLScriptElement;
        search: HTMLElement;
        section: HTMLElement;
        select: HTMLSelectElement;
        slot: HTMLSlotElement;
        small: HTMLElement;
        source: HTMLSourceElement;
        span: HTMLSpanElement;
        strong: HTMLElement;
        style: HTMLStyleElement;
        sub: HTMLElement;
        summary: HTMLElement;
        sup: HTMLElement;
        table: HTMLTableElement;
        tbody: HTMLTableSectionElement;
        td: HTMLTableCellElement;
        template: HTMLTemplateElement;
        textarea: HTMLTextAreaElement;
        tfoot: HTMLTableSectionElement;
        th: HTMLTableCellElement;
        thead: HTMLTableSectionElement;
        time: HTMLTimeElement;
        title: HTMLTitleElement;
        tr: HTMLTableRowElement;
        track: HTMLTrackElement;
        u: HTMLElement;
        ul: HTMLUListElement;
        var: HTMLElement;
        video: HTMLVideoElement;
        wbr: HTMLElement;
        animate: SVGAnimateElement;
        animateMotion: SVGAnimateMotionElement;
        animateTransform: SVGAnimateTransformElement;
        circle: SVGCircleElement;
        clipPath: SVGClipPathElement;
        defs: SVGDefsElement;
        desc: SVGDescElement;
        ellipse: SVGEllipseElement;
        feBlend: SVGFEBlendElement;
        feColorMatrix: SVGFEColorMatrixElement;
        feComponentTransfer: SVGFEComponentTransferElement;
        feComposite: SVGFECompositeElement;
        feConvolveMatrix: SVGFEConvolveMatrixElement;
        feDiffuseLighting: SVGFEDiffuseLightingElement;
        feDisplacementMap: SVGFEDisplacementMapElement;
        feDistantLight: SVGFEDistantLightElement;
        feDropShadow: SVGFEDropShadowElement;
        feFlood: SVGFEFloodElement;
        feFuncA: SVGFEFuncAElement;
        feFuncB: SVGFEFuncBElement;
        feFuncG: SVGFEFuncGElement;
        feFuncR: SVGFEFuncRElement;
        feGaussianBlur: SVGFEGaussianBlurElement;
        feImage: SVGFEImageElement;
        feMerge: SVGFEMergeElement;
        feMergeNode: SVGFEMergeNodeElement;
        feMorphology: SVGFEMorphologyElement;
        feOffset: SVGFEOffsetElement;
        fePointLight: SVGFEPointLightElement;
        feSpecularLighting: SVGFESpecularLightingElement;
        feSpotLight: SVGFESpotLightElement;
        feTile: SVGFETileElement;
        feTurbulence: SVGFETurbulenceElement;
        filter: SVGFilterElement;
        foreignObject: SVGForeignObjectElement;
        g: SVGGElement;
        image: SVGImageElement;
        line: SVGLineElement;
        linearGradient: SVGLinearGradientElement;
        marker: SVGMarkerElement;
        mask: SVGMaskElement;
        metadata: SVGMetadataElement;
        mpath: SVGMPathElement;
        path: SVGPathElement;
        pattern: SVGPatternElement;
        polygon: SVGPolygonElement;
        polyline: SVGPolylineElement;
        radialGradient: SVGRadialGradientElement;
        rect: SVGRectElement;
        set: SVGSetElement;
        stop: SVGStopElement;
        svg: SVGSVGElement;
        switch: SVGSwitchElement;
        symbol: SVGSymbolElement;
        text: SVGTextElement;
        textPath: SVGTextPathElement;
        tspan: SVGTSpanElement;
        use: SVGUseElement;
        view: SVGViewElement;
    };
    type __VLS_IntrinsicElements = import('vue/jsx-runtime').JSX.IntrinsicElements;
    type __VLS_Element = import('vue/jsx-runtime').JSX.Element;
    type __VLS_GlobalComponents = import('vue').GlobalComponents & Pick<typeof import('vue'), 'Transition' | 'TransitionGroup' | 'KeepAlive' | 'Suspense' | 'Teleport'>;
    type __VLS_GlobalDirectives = import('vue').GlobalDirectives;
    type __VLS_IsAny<T> = 0 extends 1 & T ? true : false;
    type __VLS_PickNotAny<A, B> = __VLS_IsAny<A> extends true ? B : A;
    type __VLS_unknownDirective = (arg1: unknown, arg2: unknown, arg3: unknown, arg4: unknown) => void;
    type __VLS_WithComponent<N0 extends string, LocalComponents, N1 extends string, N2 extends string, N3 extends string> = N1 extends keyof LocalComponents ? N1 extends N0 ? Pick<LocalComponents, N0 extends keyof LocalComponents ? N0 : never> : {
        [K in N0]: LocalComponents[N1];
    } : N2 extends keyof LocalComponents ? N2 extends N0 ? Pick<LocalComponents, N0 extends keyof LocalComponents ? N0 : never> : {
        [K in N0]: LocalComponents[N2];
    } : N3 extends keyof LocalComponents ? N3 extends N0 ? Pick<LocalComponents, N0 extends keyof LocalComponents ? N0 : never> : {
        [K in N0]: LocalComponents[N3];
    } : N1 extends keyof __VLS_GlobalComponents ? N1 extends N0 ? Pick<__VLS_GlobalComponents, N0 extends keyof __VLS_GlobalComponents ? N0 : never> : {
        [K in N0]: __VLS_GlobalComponents[N1];
    } : N2 extends keyof __VLS_GlobalComponents ? N2 extends N0 ? Pick<__VLS_GlobalComponents, N0 extends keyof __VLS_GlobalComponents ? N0 : never> : {
        [K in N0]: __VLS_GlobalComponents[N2];
    } : N3 extends keyof __VLS_GlobalComponents ? N3 extends N0 ? Pick<__VLS_GlobalComponents, N0 extends keyof __VLS_GlobalComponents ? N0 : never> : {
        [K in N0]: __VLS_GlobalComponents[N3];
    } : {
        [K in N0]: unknown;
    };
    type __VLS_FunctionalComponentProps<T, K> = '__ctx' extends keyof __VLS_PickNotAny<K, {}> ? K extends {
        __ctx?: {
            props?: infer P;
        };
    } ? NonNullable<P> : never : T extends (props: infer P, ...args: any) => any ? P : {};
    type __VLS_IsFunction<T, K> = K extends keyof T ? __VLS_IsAny<T[K]> extends false ? unknown extends T[K] ? false : true : false : false;
    type __VLS_NormalizeComponentEvent<Props, Events, onEvent extends keyof Props, Event extends keyof Events, CamelizedEvent extends keyof Events> = (__VLS_IsFunction<Props, onEvent> extends true ? Props : __VLS_IsFunction<Events, Event> extends true ? {
        [K in onEvent]?: Events[Event];
    } : __VLS_IsFunction<Events, CamelizedEvent> extends true ? {
        [K in onEvent]?: Events[CamelizedEvent];
    } : Props) & Record<string, unknown>;
    type __VLS_UnionToIntersection<U> = (U extends unknown ? (arg: U) => unknown : never) extends ((arg: infer P) => unknown) ? P : never;
    type __VLS_OverloadUnionInner<T, U = unknown> = U & T extends (...args: infer A) => infer R ? U extends T ? never : __VLS_OverloadUnionInner<T, Pick<T, keyof T> & U & ((...args: A) => R)> | ((...args: A) => R) : never;
    type __VLS_OverloadUnion<T> = Exclude<__VLS_OverloadUnionInner<(() => never) & T>, T extends () => never ? never : () => never>;
    type __VLS_ConstructorOverloads<T> = __VLS_OverloadUnion<T> extends infer F ? F extends (event: infer E, ...args: infer A) => any ? {
        [K in E & string]: (...args: A) => void;
    } : never : never;
    type __VLS_NormalizeEmits<T> = __VLS_PrettifyGlobal<__VLS_UnionToIntersection<__VLS_ConstructorOverloads<T> & {
        [K in keyof T]: T[K] extends any[] ? {
            (...args: T[K]): void;
        } : never;
    }>>;
    type __VLS_PrettifyGlobal<T> = {
        [K in keyof T]: T[K];
    } & {};
    type __VLS_PickFunctionalComponentCtx<T, K> = NonNullable<__VLS_PickNotAny<'__ctx' extends keyof __VLS_PickNotAny<K, {}> ? K extends {
        __ctx?: infer Ctx;
    } ? Ctx : never : any, T extends (props: any, ctx: infer Ctx) => any ? Ctx : any>>;
    type __VLS_UseTemplateRef<T> = Readonly<import('vue').ShallowRef<T | null>>;
    function __VLS_getVForSourceType(source: number): [number, number, number][];
    function __VLS_getVForSourceType(source: string): [string, number, number][];
    function __VLS_getVForSourceType<T extends any[]>(source: T): [
        item: T[number],
        key: number,
        index: number
    ][];
    function __VLS_getVForSourceType<T extends {
        [Symbol.iterator](): Iterator<any>;
    }>(source: T): [
        item: T extends {
            [Symbol.iterator](): Iterator<infer T1>;
        } ? T1 : never,
        key: number,
        index: undefined
    ][];
    function __VLS_getVForSourceType<T extends number | {
        [Symbol.iterator](): Iterator<any>;
    }>(source: T): [
        item: number | (Exclude<T, number> extends {
            [Symbol.iterator](): Iterator<infer T1>;
        } ? T1 : never),
        key: number,
        index: undefined
    ][];
    function __VLS_getVForSourceType<T>(source: T): [
        item: T[keyof T],
        key: keyof T,
        index: number
    ][];
    function __VLS_getSlotParams<T>(slot: T): Parameters<__VLS_PickNotAny<NonNullable<T>, (...args: any[]) => any>>;
    function __VLS_getSlotParam<T>(slot: T): Parameters<__VLS_PickNotAny<NonNullable<T>, (...args: any[]) => any>>[0];
    function __VLS_asFunctionalDirective<T>(dir: T): T extends import('vue').ObjectDirective ? NonNullable<T['created' | 'beforeMount' | 'mounted' | 'beforeUpdate' | 'updated' | 'beforeUnmount' | 'unmounted']> : T extends (...args: any) => any ? T : __VLS_unknownDirective;
    function __VLS_withScope<T, K>(ctx: T, scope: K): ctx is T & K;
    function __VLS_makeOptional<T>(t: T): {
        [K in keyof T]?: T[K];
    };
    function __VLS_asFunctionalComponent<T, K = T extends new (...args: any) => any ? InstanceType<T> : unknown>(t: T, instance?: K): T extends new (...args: any) => any ? (props: (K extends {
        $props: infer Props;
    } ? Props : any) & Record<string, unknown>, ctx?: any) => __VLS_Element & {
        __ctx?: {
            attrs?: any;
            slots?: K extends {
                $slots: infer Slots;
            } ? Slots : any;
            emit?: K extends {
                $emit: infer Emit;
            } ? Emit : any;
        } & {
            props?: (K extends {
                $props: infer Props;
            } ? Props : any) & Record<string, unknown>;
            expose?(exposed: K): void;
        };
    } : T extends () => any ? (props: {}, ctx?: any) => ReturnType<T> : T extends (...args: any) => any ? T : (_: {} & Record<string, unknown>, ctx?: any) => {
        __ctx?: {
            attrs?: any;
            expose?: any;
            slots?: any;
            emit?: any;
            props?: {} & Record<string, unknown>;
        };
    };
    function __VLS_elementAsFunction<T>(tag: T, endTag?: T): (_: T & Record<string, unknown>) => void;
    function __VLS_functionalComponentArgsRest<T extends (...args: any) => any>(t: T): 2 extends Parameters<T>['length'] ? [any] : [];
    function __VLS_normalizeSlot<S>(s: S): S extends () => infer R ? (props: {}) => R : S;
    function __VLS_tryAsConstant<const T>(t: T): T;
}
