"use strict";Object.defineProperty(exports, "__esModule", { value: true });exports.default = void 0;var _default = exports.default = defineNuxtConfig({
  compatibilityDate: '2024-11-01',
  devtools: { enabled: true },
  app: {
    head: {
      meta: [
      { name: 'theme-color', content: '#ef394e' }],

      link: [
      { rel: 'manifest', href: '/manifest.json' },
      {
        rel: 'preload',
        href: '/fonts/Shabnam/Shabnam.woff2',
        as: 'font',
        type: 'font/woff2',
        crossorigin: ''
      }]

    }
  },
  runtimeConfig: {
    public: {
      api: 'https://api.valamarket.ir/api',
      serverUrl: 'https://api.valamarket.ir',
      appUrl: 'https://valamarket.ir'
    }
  },
  css: [
  '~/assets/css/all.scss'],

  modules: [
  'nuxt-highcharts',
  '@nuxtjs/tailwindcss',
  'nuxt-swiper',
  '@pinia/nuxt',
  '@nuxtjs/leaflet',
  '@vite-pwa/nuxt',
  '@nuxt/image'],

  devServer: {
    port: 3002,
    host: '127.0.0.1'
  },
  // @ts-ignore
  pwa: {
    registerType: 'autoUpdate',
    workbox: {
      cleanupOutdatedCaches: true,
      cacheId: 'lara-shop-cache-v3',
      runtimeCaching: [],
      skipWaiting: true,
      clientsClaim: true
    }
  },
  image: {
    domains: ['127.0.0.1'],
    provider: 'ipx'
  }
}); /* v9-da5b5654309c1355 */
