import useMonthsList from '@/functions/MonthsList';

export default function (){

    const global=useNuxtApp().vueApp.config.globalProperties;

    const orderStatutes=global['$order:statutes'];

    const months:{[p:number]:string}=useMonthsList();

    const daysOfWeek = [
        "یک‌شنبه",
        "دوشنبه",
        "سه‌شنبه",
        "چهارشنبه",
        "پنج‌شنبه",
        "جمعه",
        "شنبه"
    ];
    const getOrderDate=function (createdAt:number){
        const date=global.$getDate(createdAt);
        let result='';
        const ex=date.toString().split('/');
        if(ex.length==3 && months[parseInt(ex[1])]){
            result=`${ex[2]} ${months[parseInt(ex[1])]} ${ex[0]}`;
        }
        return result;
    }

    const getSubmissionDate=function (createdAt:number){
        const mDate = new Date(createdAt*1000);
        const date=global.$getDate(createdAt);
        const dayOfWeekIndex = mDate.getDay();
        let result='';
        const ex=date.toString().split('/');
        if(ex.length==3 && months[parseInt(ex[1])]){
            result=`${ daysOfWeek[dayOfWeekIndex]} ${ex[2]} ${months[parseInt(ex[1])]}`;
        }
        return result;
    }

    const getTotalShippingCost=(order:Record<string, any>):string=>{
        let fixedCost=0;
        let variableCost=0;
        order.submissions.forEach((submission:Record<string, any>)=>{
            if(submission.shipping_cost>=0){
                fixedCost+=submission.shipping_cost;
            }
            else{
                variableCost=-1;
            }
        });
        if(fixedCost==0 && variableCost==-1){
            return 'پس کرایه';
        }
        else if(fixedCost>0){
            return global.$numberFormat(fixedCost)+ ' تومان' +
            (variableCost==-1 ? ' پس کرایه' : '');
        }
        else{
            return  "رایگان";
        }
    }

    const getShippingCost=(submission:{[p:string]:any}):string=>{
        let fixedCost=0;
        let variableCost=0;
        if(submission.shipping_cost>=0){
            fixedCost=submission.shipping_cost;
        }
        else{
            variableCost=-1;
        }
        if(fixedCost==0 && variableCost==-1){
            return 'پس کرایه';
        }
        else if(fixedCost>0){
            return global.$numberFormat(fixedCost)+ ' تومان' +
            (variableCost==-1 ? ' پس کرایه' : '');
        }
        else{
            return  "رایگان";
        }
    }

    const getShippingPrice=(submission:Record<string, any>):number=>{
        let price=0;
        submission.items.forEach((item:Record<string, any>)=>{
            price+=item.price2;
        });
        return  price;
    }

    return {
        getShippingPrice,
        getTotalShippingCost,
        getShippingCost,
        getOrderDate,
        getSubmissionDate,
        orderStatutes
    }
}