export function comparison() {

    const data = ref<{ [p: string]: any }[] | null>([]);
    const characteristicsId = ref<Record<number, any>>({});
    const page = ref(1);
    const endLoaded = ref(false);
    const products = ref<{ data: any[] }>({ data: [] });
    const sendRequest = ref(false);
    const category_id = ref(0);

    const getComparisonData = async (arrayId: number[]) => {
        if (!arrayId.length) return;
        const query = arrayId.map((id, i) => `product_id[${i}]=${id}`).join('&');
        const { data: result, error } = await useFetch<{ [p: string]: any }[]>(`${useRuntimeConfig().public.api}/product/compare?${query}`);
        if (!error.value && result.value) {
            data.value = result.value;
            result.value.forEach(({ specifications }) => updateCharacteristicsId(specifications));
        }
    };

    const updateCharacteristicsId = (specifications: Record<string, any>) => {
        const objectId = Object.keys(specifications).reduce((acc, key) => {
            acc[+key] = { id: key, ...specifications[key] };
            return acc;
        }, {} as Record<number, any>);
        characteristicsId.value = { ...characteristicsId.value, ...objectId };
    };

    const scroll = () => {
        const loadMore=document.querySelector('.load-more');
        if(loadMore){
            const observer = new IntersectionObserver(
                ([entry]) => {
                    if (entry.isIntersecting && !sendRequest.value && !endLoaded.value) {
                        page.value++;
                        searchProducts(category_id.value);
                    }
                },
                { threshold: 0.6 }
            );
            observer.observe(loadMore);
        }
    };

    const searchProducts = async (catId: number) => {
        if (sendRequest.value) return;
        sendRequest.value = true;
        category_id.value = catId;
        try {
            const { data: newProducts } = await useNuxtApp().$axios.get(`${useRuntimeConfig().public.api}/site/products?category_id=${catId}&variation=true&page=${page.value}`);
            products.value.data = products.value.data.concat(newProducts.data);
            if (newProducts.data.length < 15) endLoaded.value = true;
        } finally {
            sendRequest.value = false;
        }
    };

    return {
        characteristicsId,
        data,
        products,
        sendRequest,
        scroll,
        searchProducts,
        getComparisonData
    };
}
