export default function (name,hour,url){
    const cache=useState(name);
    const cacheTime=useState(name+'-time');
    const nowTime=new Date().getTime();
    const loading=useState(name+'-loading');
    if(!loading.value && cache.value==null ||
        cacheTime.value<(nowTime+(hour*60*1000))){
        loading.value=true;
        useNuxtApp().$axios.get(url).then(response=>{
            cache.value=response.data;
            cacheTime.value=nowTime;
            loading.value=false;
        }).catch((e)=>{
            cache.value=e;
            loading.value=false;
        });
    }
}