import Modal from '@/components/Modal.vue'
import Offcanvas from '@/components/Offcanvas.vue'
import {ref} from "vue";
import {productStore} from "~/stores/product";
const useReportPrice = () => {

    const theme = useState('theme');
    const user=useState('user');
    const formBox = ref<InstanceType<typeof Modal> | InstanceType<typeof Offcanvas> | null>(null)
    const productState = productStore()
    const successMessage = ref<string | null>(null);
    const onlineShop=ref<boolean>(false);
    const formKey=ref<number>(0);
    const form=ref<{ sendForm:()=>void,loading:boolean }|null>(null);
    const shop_name=ref(null);
    const price=ref(null);
    const result = () => {
        successMessage.value='ثبت گزارش با موفقیت انجام شد';
        price.value=null;
        shop_name.value=null;
        formKey.value++;
        setTimeout(()=>{
            successMessage.value=null;
        },3000);
    }

    watch(()=>onlineShop.value,()=>{
        formKey.value++;
    });

    return{
        onlineShop,
        successMessage,
        productState,
        Modal,
        Offcanvas,
        formBox,
        user,
        theme,
        formKey,
        form,
        shop_name,
        price,
        result
    }

}

export default useReportPrice;