// composables/useAddressSelection.ts
import { ref, computed, onMounted, watch } from 'vue';
import { useRouter } from 'vue-router';
import { addressStore } from '~/stores/address';
import Modal from '~/components/Modal.vue';
import Offcanvas from '~/components/Offcanvas.vue';
type ModalType = InstanceType<typeof Modal>;
type OffcanvasType = InstanceType<typeof Offcanvas>;

export const useAddressSelection = () => {

    const selectBoxRef = ref<ModalType | OffcanvasType | null>(null);
    const selectedAddressId = useState('selected-address-id');
    const addressState = addressStore();
    const toast = useState('toast');
    const router = useRouter();

    const selectedAddress = computed(() =>
        addressState.addresses.find(address => address.id === selectedAddressId.value) || null
    );

    const changeAddress = (address: Record<string, any>) => {
        selectedAddressId.value = address.id;
        selectBoxRef.value?.hide();
    };

    const showCreateForm = () => {
        selectBoxRef.value?.hide();
        addressState.showCreateForm();
    };

    const showEditForm = (address: Record<string, any>) => {
        selectBoxRef.value?.hide();
        addressState.showEditForm(address.id);
    };

    watch(
        () => addressState.addresses,
        () => {
            if (addressState.addresses.length > 0 && !selectedAddressId.value) {
                selectedAddressId.value = addressState.addresses[0].id;
            } else if (addressState.addresses.length === 0) {
                toast.value = {
                    message: 'برای ثبت سفارش باید ابتدا آدرس خود را ثبت کنید',
                    type: 'error'
                };
                router.push('/profile/addresses');
            }
        }
    );

    onMounted(() => {
        addressState.getAddresses();
    });

    return {
        selectBoxRef,
        addressState,
        selectedAddress,
        changeAddress,
        showCreateForm,
        showEditForm
    };
};
