import {searchStore} from "~/stores/search-products";

export function useSearchProducts(){

    const global=useNuxtApp().vueApp.config.globalProperties;
    const theme=useState('theme');
    const searchState=searchStore();
    searchState.updateResult({});
    searchState.setDefaultQueries();

    let afterProductContents=global['$products-search:after-list'] as {component:Component,index:number}[]
    afterProductContents=global.$sort(afterProductContents,'index');

    let beforeSidebar=global['$products-search:before-sidebar'] as {component:Component,index:number}[]
    beforeSidebar=global.$sort(beforeSidebar,'index');


    const pageContentSelector = '.page-content';

    onMounted(() => {
        const pageContent = document.querySelector(pageContentSelector) as HTMLElement;
        pageContent?.addEventListener('scroll', searchState.scroll);
    });

    onUnmounted(() => {
        const pageContent = document.querySelector(pageContentSelector) as HTMLElement;
        pageContent?.removeEventListener('scroll', searchState.scroll);
    });

    watch(()=>useRoute().query['q'],()=>{
        searchState.setDefaultQueries();
        searchState.updateResult({});
        searchState.loadMoreProducts();
    });

    watch(()=>searchState.queries,()=>{
        if(searchState.result.products){
            searchState.reset();
            searchState.loadMoreProducts();
        }
    }, {deep:true});

    return {
        theme,
        afterProductContents,
        searchState,
        beforeSidebar
    }
}