import type {ModalType} from "~/types/core/ModalType";
import type {FormType} from "~/types/core/FormType";

export function useLegalAccountForm(){

    const boxRef=ref<ModalType|null>(null);
    const formRef=ref<FormType|null>(null);
    const theme=useState('theme');
    const user=useState<Record<string, any>>('user');
    const cities=useState<Record<string, any>[]|null>('cities');
    const provinces=useState<Record<string, any>[]|null>('provinces');
    const result=(response:{data:Record<string, any>})=>{
        if(response.data.status=='ok'){
            boxRef.value?.hide();
            user.value={...user.value,...response.data.data};
        }
    }

    const tableData=computed(()=>{
        if(user.value.companyName){
            return [
                {
                    'title':'نام سازمان',
                    'value':user.value.companyName
                },
                {
                    'title':'کد اقتصادی',
                    'value':user.value.companyEconomicNumber
                },
                {
                    'title':'شناسه ملی',
                    'value':user.value.companyNationalIdentityNumber
                },
                {
                    'title':'شماره ثبت',
                    'value':user.value.companyRegistrationNumber
                },
                {
                    'title':'استان',
                    'value':getProvinceName()
                },
                {
                    'title':'شهر',
                    'value':getCityName()
                },
                {
                    'title':'تلفن ثابت',
                    'value':user.value.tell
                }
            ];
        }
        return  [];
    });

    const getProvinceName=()=>{
        return provinces.value?.find((province)=>province.id==user.value.province_id)?.name;
    }

    const getCityName=()=>{
        return cities.value?.find((city)=>city.id==user.value.city_id)?.name;
    }

    const isLastRow=(index:number)=>{
        const columns = 2;
        const totalRows = Math.ceil(tableData.value.length / columns);
        const currentRow = Math.floor(index / columns) + 1;
        return currentRow === totalRows;
    }

    return {
        boxRef,
        user,
        tableData,
        formRef,
        theme,
        result,
        isLastRow
    }
}