export function useSelectTagListView(config:Record<string, any>) {

    const searchText = ref<string>('');
    const listItems=ref<any[]>([]);
    const listIndex=ref<number>(0);


    const previousItems=()=>{
        if(listIndex.value>0){
            listItems.value.splice(listIndex.value,1);
            listIndex.value--;
        }
    }

    const showChildList=(item:Record<string, any>)=>{
        const list=getItemsList(item[config.itemValue ?? 'value'] as number);
        if(list.length>0){
            listIndex.value++;
            listItems.value[listIndex.value]=list;
        }
    }

    const getItemsList=function(value:number){
        let items=[];
        for (let i = 0; i <config.items.length ; i++) {
            if(config.items[i][config.nestedProperty]==value){
                items.push(config.items[i]);
            }
        }
        return items;
    }

    onMounted(()=>{
        if(config.nestedProperty){
            listItems.value[listIndex.value]=getItemsList(0);
        }
        else{
            listItems.value[0]=config.items;
        }
    });


    return {
        searchText,
        listIndex,
        listItems,
        getItemsList,
        showChildList,
        previousItems
    }
}