import {input} from "~/functions/input";
export function useSelectTag(props:Record<string, any>,model:Record<string, any>) {

    interface Item {
        [key: string]: any;
    }

    const { error,validateInput } = input(props, model);

    const theme = useState<string>('theme');
    const showList = ref(false);
    const text = ref<string | null>(null);
    const selectIcon = ref<any>(null);
    const icon = ref<string | null>(null);
    const addRule = inject<(fn: () => boolean) => void>('addRule');
    const removeRule = inject<(fn: () => boolean) => void>('removeRule');
    const selectViewBox=ref<HTMLElement|null>(null);

    onMounted(() => {

        document.body.addEventListener('mouseup', (event: MouseEvent) => {
            if (selectViewBox.value && !selectViewBox.value.contains(event.target as Node) && showList.value) {
                toggleList();
            }
        });

        if(props.multiSelect){
            model.value={};
        }
        if (addRule) addRule(validate);
        if (model.value) {
            const item = findItemWithValue(model.value);
            if (item) selectItem(item);
        }
    });

    onUnmounted(()=>{
        if (removeRule) removeRule(validate);
    });
    const validate = (): boolean => {
        return validateInput(props);
    };

    const findItemWithValue = (value: string | number | null): Item | null => {
        return (props.items as Record<string, any>[])
            .find(item => item[props.itemValue ?? 'value'] == value) || null;
    };

    const selectItem = (item: Item) => {
        if(props.multiSelect){
            model.value[item[props.itemValue ?? 'value']]=
                !model.value[item[props.itemValue ?? 'value']];
            if(!model.value[item[props.itemValue ?? 'value']]){
                delete model.value[item[props.itemValue ?? 'value']];
            }
        }
        else{
            model.value = item[props.itemValue ?? 'value'];
            text.value = item[props.itemText ?? 'title'];
            showList.value = false;
        }
        icon.value = item.icon || null;
    };

    const toggleList = () => {
        if(!props.disable){
            showList.value = !showList.value;
            if (selectIcon.value) {
                selectIcon.value.$el.style.transform =
                    showList.value ? 'rotate(180deg)' : 'rotate(0deg)';
            }
        }
    };

    const removeMultiSelectedItem=(key:number|string)=>{
        delete model.value[key];
    }

    const afterClose=()=>{
        showList.value=false;
        selectIcon.value.$el.style.transform =
            showList.value ? 'rotate(180deg)' : 'rotate(0deg)';
    }

    watch(() => props.items, () => {
            if (model.value) {
                const item = findItemWithValue(model.value);
                if (item) selectItem(item);
            }
        }
    );

    watch(() => model.value, () => {
            const item = findItemWithValue(model.value);
            if (item) selectItem(item);
        }
    );
    return {
        error,
        text,
        selectIcon,
        icon,
        addRule,
        theme,
        showList,
        selectViewBox,
        afterClose,
        findItemWithValue,
        removeMultiSelectedItem,
        selectItem,
        toggleList
    }
}
