import  {searchStore} from "~/stores/search-products";

export function useColorFilter(props:Record<string, any>){
    const store=searchStore();
    const showList=ref<boolean>(false);
    const colors=ref<Record<string, string>[]>([]);
    const selectedColors=ref<Record<string, boolean>>({});
    const {$axios}=useNuxtApp();
    const {api}=useRuntimeConfig().public;

    onMounted(()=>{
        let category_id=props.category_id;
        if(!category_id && store.result && store.result.products && store.result.products.data[0]){
            category_id=store.result.products.data[0].category_id;
        }
        if(category_id){
            getColors(category_id);
        }
    });

    const getColors=(category_id:number)=>{
        $axios.get(api+'/search/'+category_id+'/colors')
            .then((response)=>{
            colors.value=response.data;
            if(store.queries['colors']){
                const updatedColors = { ...selectedColors.value };
                Object.values(store.queries['colors'] as number[]).forEach((value) => {
                    updatedColors[value] = true;
                });
                selectedColors.value = updatedColors;
            }
        });
    }
    const addOrRemoveFilter=(colorId:string)=>{
        selectedColors.value[colorId]=!selectedColors.value[colorId];
        store.addOrRemoveFilter('colors',colorId);
    }

    watch(()=>store.queries,()=>{
        if(Object.keys(store.queries).length===0){
            selectedColors.value={};
        }
    });

    return {
        showList,
        colors,
        selectedColors,
        store,
        addOrRemoveFilter
    }
}