import  {searchStore} from "~/stores/search-products";

export function useBrandFilter(){

    const store=searchStore();
    const brands=useState<Record<string, string>[]>('brands');
    const categories=useState<Record<string, string>[]>('categories');
    const category=ref<Record<string, string>|null>();
    const params=useRoute().params;
    const showList=ref<boolean>(false);
    const selectedBrands=ref<Record<string, boolean>>({});
    const {$axios}=useNuxtApp();
    const {api}= useRuntimeConfig().public;

    onMounted(()=>{
        const slug=params['childcategory'] ?? params['category']
        category.value=categories.value.find((category)=>category.slug==slug);
        if(!brands.value){
            getBrandsList();
        }
        if (store.queries['brands'] && typeof store.queries['brands'] === 'object' && !Array.isArray(store.queries['brands'])) {
            const values = Object.values(store.queries['brands']);
            values.forEach((id)=>{
                selectedBrands.value[id as string] = true;
            });
        }
    });

    const getBrandsList=()=>{
        $axios.get(api+'/brands/list').then((response)=>{
            brands.value=response.data;
        });
    };

    const filteredBrand=computed(()=>{
        if (!category.value) {
            return brands.value;
        }
        return brands.value!.filter(brand => {
            if (!brand.categories) return false;
            const categoryList = brand.categories.toString().split(",");
            return categoryList.includes(category.value!.id.toString());
        });
    });

    const addOrRemoveFilter=(brandId:number)=>{
        store.addOrRemoveFilter('brands',brandId.toString());
    }


    return {
        selectedBrands,
        showList,
        store,
        filteredBrand,
        brands,
        addOrRemoveFilter
    }
}