import {addressStore} from '~/stores/address';

export function useStepForm(){
    const store=addressStore();
    const provinces=useState<Record<string, any>[]>('provinces');
    const cities=useState<{[p:string]:string|null}[]>('cities');
    const formKey=ref<number>(0);
    const form=ref<any>(null);
    const {$axios}=useNuxtApp();
    const provinceName=ref<string|null>(null);
    const cityName=ref<string|null>(null);
    const getAddressFromLocation=async ()=>{
        const url
            ="https://map.ir/reverse/?lat="+store.location[0]+"&lon="+store.location[1]
            +"&x-api-key="+store.apiKey;

        const {data:result,error} =await useFetch<Record<string, any>>(url);
        if(result.value!==null && result.value.address!==undefined){
            store.formData['address']=result.value.address;
            provinceName.value=result.value.province;
            cityName.value=result.value.district;
        }
    }

    onMounted(()=>{
        getAddressFromLocation();
    });

    const provinceCities=computed(()=>{
        if(store.formData.province_id){
            return  cities.value.filter((city)=>city.province_id==store.formData.province_id);
        }
        else{
            return [];
        }
    });

    const submit=()=>{
        form.value!.sendForm();
    }

    watch(()=>store.formData.province_id,()=>{
        store.formData.city_id=null;
        formKey.value=formKey.value+1;
    });

    watch(()=>provinceName.value,()=>{
        const province=provinces.value.find((row)=>row.name==provinceName.value);
        if(province){
            store.formData.province_id=province.id;
        }
    });

    watch(()=>provinceCities.value,()=>{
        if(cityName){
            const city=provinceCities.value.find((row)=>row.name==cityName.value);
            if(city){
                store.formData.city_id=city.id;
            }
        }
    })

    return {
        store,
        form,
        submit,
        formKey,
        provinces,
        provinceCities
    }
}