import { c as useNuxtApp, b as useRuntimeConfig } from './server.mjs';
import { ref } from 'vue';
import { defineStore } from 'pinia';

const specificationsStore = defineStore("specifications", () => {
  const data = ref({});
  const getData = (productId) => {
    if (Object.keys(data.value).length == 0) {
      useNuxtApp().$axios.get(
        useRuntimeConfig().public.api + "/product/" + productId + "/specifications"
      ).then((response) => {
        data.value = response.data;
      });
    }
  };
  return {
    data,
    getData
  };
});

export { specificationsStore as s };
//# sourceMappingURL=specifications-Vu5A47gN.mjs.map
