import { ref } from 'vue';

function input(props, model) {
  const error = ref(false);
  const inputKeyUp = function() {
    validateInput(props);
  };
  const validateInput = function(props2) {
    let result = true;
    if (props2.rules) {
      result = validate(
        model.value,
        props2.rules,
        props2.label
      );
    }
    if (result === true) {
      error.value = false;
    } else {
      error.value = result;
    }
    return result;
  };
  const validate = function(value, rules, label) {
    if (typeof rules == "string") {
      rules = rules.toString().split("|");
    }
    let result = true;
    for (let i = 0; i < rules.length; i++) {
      if (result === true && rules[i] !== void 0 && rules[i] != null) {
        if (typeof rules[i] == "function") {
          result = rules[i](value, label);
        } else {
          const ruleArrName = rules[i].toString().split(":");
          if (ruleArrName.length === 2) {
            result = functions[ruleArrName[0]](value, label, ruleArrName[1]);
          } else {
            result = functions[ruleArrName[0]](value, label);
          }
        }
      }
    }
    return result;
  };
  const functions = {
    "min": function(value, label, length) {
      if (value.toString().trim().length < length) {
        return "" + label + " \u062D\u062F\u0627\u0642\u0644 \u0628\u0627\u06CC\u062F \u062F\u0627\u0631\u0627\u06CC " + length + " \u06A9\u0627\u0631\u0627\u06A9\u062A\u0631 \u0628\u0627\u0634\u062F";
      }
      return true;
    },
    "max": function(value, label, length) {
      if (value.toString().trim().length > length) {
        return "" + label + " \u062D\u062F\u0627\u06A9\u062B\u0631 \u0628\u0627\u06CC\u062F \u062F\u0627\u0631\u0627\u06CC " + length + " \u06A9\u0627\u0631\u0627\u06A9\u062A\u0631 \u0628\u0627\u0634\u062F";
      }
      return true;
    },
    "nationalCode": function(value, label) {
      let result = "\u06A9\u062F \u0645\u0644\u06CC \u0645\u0639\u062A\u0628\u0631 \u0646\u0645\u06CC \u0628\u0627\u0634\u062F";
      if (!isNaN(parseInt(value)) && value.toString().length === 10) {
        let sum = 0;
        for (let i = 0; i < 9; i++) {
          let n = parseInt(value[i]);
          sum += (10 - i) * n;
        }
        const ret = sum % 11;
        const parity = parseInt(value[9]);
        if (ret < 2 && ret === parity || ret >= 2 && ret === 11 - parity) {
          result = true;
        }
      }
      return result;
    },
    "required": function(value, label) {
      if (value == null || value.toString().trim() === "") {
        return "" + label + " \u0646\u0645\u06CC \u062A\u0648\u0627\u0646\u062F \u062E\u0627\u0644\u06CC \u0628\u0627\u0634\u062F";
      } else {
        return true;
      }
    },
    "mobile": function(value, label) {
      let result = "" + label + " \u0648\u0627\u0631\u062F \u0634\u062F\u0647 \u0645\u0639\u062A\u0628\u0631 \u0646\u0645\u06CC \u0628\u0627\u0634\u062F";
      if (!isNaN(value)) {
        value = parseInt(value);
        if (value.toString().length === 10 && value.toString().charAt(0) === "9") {
          return true;
        }
      }
      return result;
    },
    "length": function(value, label, length) {
      if (value.toString().trim().length !== length) {
        return `${label} \u0628\u0627\u06CC\u062F \u0634\u0627\u0645\u0644 ${length} \u06A9\u0627\u0631\u0627\u06A9\u062A\u0631 \u0628\u0627\u0634\u062F`;
      }
      return true;
    },
    "email": function validateEmail(value, label) {
      const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      if (!value.toString().trim().match(emailRegex)) {
        return `${label} \u0628\u0627\u06CC\u062F \u06CC\u06A9 \u0627\u06CC\u0645\u06CC\u0644 \u0645\u0639\u062A\u0628\u0631 \u0628\u0627\u0634\u062F`;
      }
      return true;
    }
  };
  const checknationalCode = function(value, label) {
    let result = "\u06A9\u062F \u0645\u0644\u06CC \u0645\u0639\u062A\u0628\u0631 \u0646\u0645\u06CC \u0628\u0627\u0634\u062F";
    if (!isNaN(parseInt(value)) && value.toString().length === 10) {
      let sum = 0;
      for (let i = 0; i < 9; i++) {
        let n = parseInt(value[i]);
        sum += (10 - i) * n;
      }
      const ret = sum % 11;
      const parity = parseInt(value[9]);
      if (ret < 2 && ret == parity || ret >= 2 && ret == 11 - parity) {
        result = true;
      }
    }
    return result;
  };
  return {
    error,
    checknationalCode,
    inputKeyUp,
    validateInput,
    functions
  };
}

export { input as i };
//# sourceMappingURL=input-CqSTwEhb.mjs.map
