import { defineStore } from 'pinia';
import { ref, computed } from 'vue';
import { c as useNuxtApp, u as useState, b as useRuntimeConfig, j as useRouter } from './server.mjs';

const useOrderState = () => ({
  loading: ref(false),
  data: ref({}),
  submissionInfo: ref(null),
  paymentMethod: ref(""),
  formData: ref({}),
  errorInContinue: ref({}),
  itemsDeducted: ref({})
});
const useOrderComputed = (data, itemsDeducted) => {
  const global = useNuxtApp().vueApp.config.globalProperties;
  const finalPrice = computed(() => {
    var _a2, _b2;
    var _a, _b;
    let price = 0;
    const submissions = (_a2 = (_a = data.value) == null ? void 0 : _a.submissions) != null ? _a2 : {};
    for (const submission of Object.values(submissions)) {
      const products = submission.products;
      for (const product of products) {
        price += product.count * product.variation.price2;
      }
      const infoPrice = parseInt((_b2 = (_b = submission.info) == null ? void 0 : _b.price) != null ? _b2 : "0");
      if (infoPrice > 0) {
        price += infoPrice;
      }
    }
    return price;
  });
  const totalPrice = computed(() => {
    var _a2;
    var _a;
    let price = 0;
    const submissions = (_a2 = (_a = data.value) == null ? void 0 : _a.submissions) != null ? _a2 : {};
    for (const submission of Object.values(submissions)) {
      const products = submission.products;
      for (const product of products) {
        price += product.count * product.variation.price2;
      }
    }
    return price;
  });
  const finalPriceExcludingShipping = computed(() => {
    var _a2;
    var _a;
    let price = 0;
    const submissions = (_a2 = (_a = data.value) == null ? void 0 : _a.submissions) != null ? _a2 : {};
    for (const submission of Object.values(submissions)) {
      const products = submission.products;
      for (const product of products) {
        price += product.count * product.variation.price2;
      }
    }
    return price;
  });
  const totalShippingCost = computed(() => {
    var _a2, _b;
    var _a;
    const submissions = (_a2 = (_a = data.value) == null ? void 0 : _a.submissions) != null ? _a2 : {};
    let total = 0;
    let hasAfterPrice = false;
    for (const submission of Object.values(submissions)) {
      const info = submission.info;
      const price = parseInt((_b = info == null ? void 0 : info.price) != null ? _b : "0");
      if (price > 0) {
        total += price;
      } else if (price === -1) {
        hasAfterPrice = true;
      }
    }
    if (total === 0) {
      return hasAfterPrice ? "\u067E\u0633 \u06A9\u0631\u0627\u06CC\u0647" : "\u0631\u0627\u06CC\u06AF\u0627\u0646";
    }
    return global.$replaceEnNumber(global.$numberFormat(total)) + " \u062A\u0648\u0645\u0627\u0646" + (hasAfterPrice ? " + \u067E\u0633 \u06A9\u0631\u0627\u06CC\u0647" : "");
  });
  const shopSetting = useState("shopSetting");
  const taxes = () => {
    const taxPercent = parseInt(shopSetting.value.taxes || "0");
    return taxPercent > 0 ? Math.floor(finalPriceExcludingShipping.value * taxPercent / 100) : 0;
  };
  const payableAmount = computed(() => {
    let amount = finalPrice.value + taxes();
    const keys = Object.keys(itemsDeducted.value);
    for (let i = 0; i < keys.length; i++) {
      amount -= itemsDeducted.value[keys[i]].value;
    }
    return amount;
  });
  return {
    finalPrice,
    totalPrice,
    totalShippingCost,
    payableAmount,
    taxes
  };
};
const useOrderActions = (state) => {
  const { serverUrl, api } = useRuntimeConfig().public;
  const toast = useState("toast");
  const { $axios } = useNuxtApp();
  const getOrderInfo = async (addressId) => {
    state.loading.value = true;
    state.errorInContinue.value = {};
    const apiUrl = api + "/user/cart/submissions?address_id=" + addressId;
    try {
      const response = await useNuxtApp().$axios.get(apiUrl);
      state.data.value = response.data;
    } catch (error) {
      console.error("Error fetching order info:", error);
    } finally {
      state.loading.value = false;
    }
  };
  const payment = async () => {
    const apiUrl = api + "/user/add-order";
    state.loading.value = true;
    try {
      const response = await $axios.post(apiUrl, state.formData.value);
      if (response.data.status === "ok") {
        if (parseInt(response.data["paymentId"]) > 0) {
          (void 0).location.href = serverUrl + "/shop/gateway-connect?paymentId=" + response.data["paymentId"];
        } else if (parseInt(response.data["paymentId"]) == 0) {
          useRouter().push("/verify/checkout/" + response.data["order_id"]);
        }
      }
    } catch (error) {
      toast.value = {
        type: "error",
        message: "\u062E\u0637\u0627 \u062F\u0631 \u062B\u0628\u062A \u0633\u0641\u0627\u0631\u0634 \u0645\u062C\u062F\u062F\u0627 \u062A\u0644\u0627\u0634 \u0646\u0645\u0627\u06CC\u06CC\u062F"
      };
    } finally {
      state.loading.value = false;
    }
  };
  const changePaymentMethod = (method) => {
    state.paymentMethod.value = method;
  };
  const updateItemsDeducted = (value) => {
    state.itemsDeducted.value = value;
  };
  return {
    getOrderInfo,
    payment,
    changePaymentMethod,
    updateItemsDeducted
  };
};
const useOrderStore = defineStore("order", () => {
  const state = useOrderState();
  const computedValues = useOrderComputed(state.data, state.itemsDeducted);
  const actions = useOrderActions(state);
  return {
    ...state,
    ...computedValues,
    ...actions
  };
});

export { useOrderStore as u };
//# sourceMappingURL=index-Co4X6G3O.mjs.map
