import _sfc_main$2 from './view-CjWxkU96.mjs';
import { defineComponent, ref, watch, mergeProps, unref, computed, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderClass, ssrRenderAttr, ssrRenderList, ssrInterpolate } from 'vue/server-renderer';
import { u as useState, b as useRuntimeConfig } from './server.mjs';
import { _ as _sfc_main$3 } from './View-DJhaXJ-z.mjs';
import './NuxtImg-DBEieluz.mjs';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';
import './v3-CqizLg04.mjs';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import 'unhead/plugins';
import './Skeleton-B5XQTW8R.mjs';
import 'pinia';
import 'vue-router';
import 'highcharts';
import 'lodash';
import '@vue/shared';
import './List-2tRGzJIt.mjs';
import './search-products-xw_89Bg_.mjs';
import './ProductView-CNzvSvNo.mjs';
import './Score-BYZAscMc.mjs';
import './ProductLoading-DIaXfK3g.mjs';

const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "CategoriesSlider",
  __ssrInlineRender: true,
  props: {
    selectedCategoryId: {},
    selectCategory: { type: Function }
  },
  setup(__props) {
    const { serverUrl } = useRuntimeConfig().public;
    const categories = useState("categories");
    const mainCategories = computed(() => {
      return categories.value.filter((category) => category.parent_id == 0);
    });
    const injectStyles = [
      `.swiper-button-next,
  .swiper-button-prev {
      background-color: white;
      border-radius: 100% ;
      width:35px;
      height:35px;
      border:1px solid #dedede;
  }
  .swiper-button-next svg,
  .swiper-button-prev svg {
     width:20px;
     height:20px;
     color:black;
  }`
    ];
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<swiper-container${ssrRenderAttrs(mergeProps({
        navigation: true,
        "slides-per-view": "auto",
        injectStyles,
        "space-between": 10,
        class: "px-3 categories-slider"
      }, _attrs), "swiper-container")}><swiper-slide class="${ssrRenderClass([{ "active": _ctx.selectedCategoryId == 0 }, "w-[130px] cursor-pointer"])}"><div class="flex flex-col items-center py-5"><img${ssrRenderAttr("src", unref(serverUrl) + "/upload/shopping-cart.png")} alt="\u0647\u0645\u0647" class="w-[80px]"><span class="text-sm text-center mt-2">\u0647\u0645\u0647</span></div></swiper-slide><!--[-->`);
      ssrRenderList(unref(mainCategories), (category) => {
        _push(`<swiper-slide class="${ssrRenderClass([{ "active": _ctx.selectedCategoryId == category.id }, "w-[130px] cursor-pointer"])}"><div class="flex flex-col items-center justify-between py-3 h-[160px]"><img${ssrRenderAttr("src", unref(serverUrl) + "/upload/" + category.image)}${ssrRenderAttr("alt", category.name)} class="w-[80px]"><span class="text-sm text-center mt-3">${ssrInterpolate(category.name)}</span></div></swiper-slide>`);
      });
      _push(`<!--]--></swiper-container>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/promotions/CategoriesSlider.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "incredible-offers",
  __ssrInlineRender: true,
  setup(__props) {
    const theme = useState("theme");
    const selectedCategoryId = ref(0);
    const changeCategory = (categoryId) => {
      selectedCategoryId.value = categoryId;
    };
    watch(() => selectedCategoryId.value, () => {
      let url = useRuntimeConfig().public.appUrl + "/incredible-offers";
      if (selectedCategoryId.value > 0) {
        url += "?category_id=" + selectedCategoryId.value;
      }
      (void 0).history.pushState(
        {},
        "",
        url
      );
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_SlidersView = _sfc_main$2;
      const _component_PromotionsCategoriesSlider = _sfc_main$1;
      const _component_ThemeSearchView = _sfc_main$3;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "incredible-offers" }, _attrs))}>`);
      if (unref(theme) === "desktop") {
        _push(`<div class="page-header"></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_component_SlidersView, { setting: { "group": "incredible-offers" } }, null, _parent));
      _push(ssrRenderComponent(_component_PromotionsCategoriesSlider, {
        "selected-category-id": unref(selectedCategoryId),
        "select-category": changeCategory,
        class: "my-3"
      }, null, _parent));
      _push(ssrRenderComponent(_component_ThemeSearchView, {
        "request-url": "/promotions/search/products?category_id=" + unref(selectedCategoryId),
        category_id: unref(selectedCategoryId)
      }, null, _parent));
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/incredible-offers.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=incredible-offers-Cdx5UVh_.mjs.map
