import { _ as _sfc_main$1 } from './ProductLoading-DIaXfK3g.mjs';
import { _ as _sfc_main$2 } from './ProductView-CNzvSvNo.mjs';
import { defineComponent, ref, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderClass, ssrRenderList } from 'vue/server-renderer';
import { defineStore } from 'pinia';
import { u as useState, c as useNuxtApp, b as useRuntimeConfig, j as useRouter } from './server.mjs';
import './Skeleton-B5XQTW8R.mjs';
import './NuxtImg-DBEieluz.mjs';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';
import './v3-CqizLg04.mjs';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import 'unhead/plugins';
import './Score-BYZAscMc.mjs';
import 'vue-router';
import 'highcharts';
import 'lodash';
import '@vue/shared';

const useAIImageSearch = defineStore("imageSearch", () => {
  const toast = useState("toast");
  const loading = ref(false);
  const products = ref([]);
  const { $axios } = useNuxtApp();
  const { api } = useRuntimeConfig().public;
  const maxSizeInBytes = 2 * 1024 * 1024;
  const router = useRouter();
  const uploadImage = async (file) => {
    if (!file.type.startsWith("image/")) {
      toast.value = {
        type: "error",
        message: "\u0641\u0642\u0637 \u0641\u0627\u06CC\u0644 \u062A\u0635\u0648\u06CC\u0631\u06CC \u0645\u062C\u0627\u0632 \u0627\u0633\u062A."
      };
      return;
    }
    if (file.size > maxSizeInBytes) {
      toast.value = {
        type: "error",
        message: "\u062D\u062C\u0645 \u062A\u0635\u0648\u06CC\u0631 \u0646\u0628\u0627\u06CC\u062F \u0628\u06CC\u0634\u062A\u0631 \u0627\u0632 \u06F2 \u0645\u06AF\u0627\u0628\u0627\u06CC\u062A \u0628\u0627\u0634\u062F."
      };
      return;
    }
    await sendUploadRequest(file);
  };
  const sendUploadRequest = async (file) => {
    var _a, _b;
    const formData = new FormData();
    formData.append("image", file);
    loading.value = true;
    await router.push("/image-search");
    try {
      const response = await $axios.post(api + "/products/search-by-image", formData, {
        headers: { "Content-Type": "multipart/form-data" }
      });
      products.value = response.data;
    } catch (error) {
      toast.value = {
        type: "error",
        message: ((_b = (_a = error == null ? void 0 : error.response) == null ? void 0 : _a.data) == null ? void 0 : _b.message) || "\u062E\u0637\u0627 \u062F\u0631 \u0622\u067E\u0644\u0648\u062F \u062A\u0635\u0648\u06CC\u0631."
      };
    } finally {
      loading.value = false;
    }
  };
  return {
    products,
    loading,
    uploadImage
  };
});
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "image-search",
  __ssrInlineRender: true,
  setup(__props) {
    ref(null);
    const theme = useState("theme");
    const searchState = useAIImageSearch();
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ThemeSearchProductLoading = _sfc_main$1;
      const _component_ThemeSearchProductView = _sfc_main$2;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "py-5 search-products by-image" }, _attrs))}>`);
      if (unref(searchState).loading) {
        _push(ssrRenderComponent(_component_ThemeSearchProductLoading, null, null, _parent));
      } else if (unref(searchState).products.length > 0) {
        _push(`<div class="${ssrRenderClass([{ "grid grid-cols-2 md:grid-cols-3": unref(theme) != "mobile" }, "products-list"])}"><!--[-->`);
        ssrRenderList(unref(searchState).products, (product) => {
          _push(ssrRenderComponent(_component_ThemeSearchProductView, {
            product,
            key: product.id
          }, null, _parent));
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<div class="flex flex-col items-center py-10 text-gray-500 h-full justify-center"><p class="text-xl">\u0645\u062D\u0635\u0648\u0644 \u0645\u0634\u0627\u0628\u0647\u06CC \u06CC\u0627\u0641\u062A \u0646\u0634\u062F ! </p><button class="select-button px-5 py-3 mt-5"> \u0627\u0646\u062A\u062E\u0627\u0628 \u062A\u0635\u0648\u06CC\u0631 \u062C\u062F\u06CC\u062F </button></div>`);
      }
      _push(`<input type="file" class="hidden" accept="image/*">`);
      if (unref(searchState).products.length > 0) {
        _push(`<button class="select-button px-2 z-10 py-2.5 mt-5 text-xs absolute left-[15px] bottom-20"> \u0627\u0646\u062A\u062E\u0627\u0628 \u062A\u0635\u0648\u06CC\u0631 \u062C\u062F\u06CC\u062F </button>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/image-search.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=image-search-DOvJq-5N.mjs.map
