import { u as useState, c as useNuxtApp, e as useRoute, A as useAsyncData, b as useRuntimeConfig, g as __nuxt_component_0$2, J as _sfc_main$p, j as useRouter, a as _sfc_main$o, f as cartStore, I as _sfc_main$q, k as __nuxt_component_3$1, _ as _sfc_main$i$1, h as _sfc_main$k$1 } from './server.mjs';
import { _ as _sfc_main$l } from './NuxtImg-DBEieluz.mjs';
import { _ as _sfc_main$r } from './TextInput-BtVMT3NE.mjs';
import { _ as _sfc_main$u } from './PositionView-ByKT-amv.mjs';
import { defineComponent, ref, withAsyncContext, unref, withCtx, createVNode, resolveDynamicComponent, createBlock, openBlock, renderSlot, createCommentVNode, mergeProps, computed, resolveComponent, createTextVNode, toDisplayString, watch, isRef, Fragment, renderList, useModel, useSSRContext } from 'vue';
import { ssrRenderClass, ssrRenderComponent, ssrRenderSlot, ssrRenderVNode, ssrRenderList, ssrRenderAttrs, ssrRenderAttr, ssrInterpolate } from 'vue/server-renderer';
import { _ as __nuxt_component_3 } from './Skeleton-B5XQTW8R.mjs';
import { _ as _sfc_main$n } from './products-6mNvaXLL.mjs';
import { _ as _sfc_main$s } from './Component-C6QGchKb.mjs';
import { _ as _sfc_main$t } from './Button-CglX5dCL.mjs';
import { _ as _sfc_main$m } from './MoreText-CtkeWBXn.mjs';
import { u as useHead } from './v3-CqizLg04.mjs';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';
import 'pinia';
import 'vue-router';
import 'highcharts';
import 'lodash';
import '@vue/shared';
import './SendDetail-CCtW5pOV.mjs';
import './user-utils-B9JSuaai.mjs';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import 'unhead/plugins';

const _sfc_main$k = /* @__PURE__ */ defineComponent({
  __name: "Categories",
  __ssrInlineRender: true,
  props: {
    categories: {}
  },
  setup(__props) {
    const allCategories = useState("categories");
    const getParent = (parentId) => {
      return allCategories.value.find((category) => category.id == parentId);
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_router_link = resolveComponent("router-link");
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<ul${ssrRenderAttrs(mergeProps({ class: "py-3" }, _attrs))}><!--[-->`);
      ssrRenderList(_ctx.categories, (category) => {
        _push(`<li class="py-1.5">`);
        _push(ssrRenderComponent(_component_router_link, {
          to: "/search?q=" + category.name,
          class: "flex"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(_component_fa_icon, {
                icon: ["fas", "fa-search"],
                class: "text-gray-500 pt-1 px-4"
              }, null, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_router_link, {
                to: "/search/" + category.slug
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<span${_scopeId2}>${ssrInterpolate(category.name)}</span>`);
                    if (getParent(category.id)) {
                      _push3(`<div class="py-3"${_scopeId2}><span class="text-gray-500"${_scopeId2}>\u062F\u0631 \u062F\u0633\u062A\u0647 </span><span class="text-blue-400"${_scopeId2}>${ssrInterpolate(getParent(category.id).name)}</span></div>`);
                    } else {
                      _push3(`<!---->`);
                    }
                  } else {
                    return [
                      createVNode("span", null, toDisplayString(category.name), 1),
                      getParent(category.id) ? (openBlock(), createBlock("div", {
                        key: 0,
                        class: "py-3"
                      }, [
                        createVNode("span", { class: "text-gray-500" }, "\u062F\u0631 \u062F\u0633\u062A\u0647 "),
                        createVNode("span", { class: "text-blue-400" }, toDisplayString(getParent(category.id).name), 1)
                      ])) : createCommentVNode("", true)
                    ];
                  }
                }),
                _: 2
              }, _parent2, _scopeId));
            } else {
              return [
                createVNode(_component_fa_icon, {
                  icon: ["fas", "fa-search"],
                  class: "text-gray-500 pt-1 px-4"
                }),
                createVNode(_component_router_link, {
                  to: "/search/" + category.slug
                }, {
                  default: withCtx(() => [
                    createVNode("span", null, toDisplayString(category.name), 1),
                    getParent(category.id) ? (openBlock(), createBlock("div", {
                      key: 0,
                      class: "py-3"
                    }, [
                      createVNode("span", { class: "text-gray-500" }, "\u062F\u0631 \u062F\u0633\u062A\u0647 "),
                      createVNode("span", { class: "text-blue-400" }, toDisplayString(getParent(category.id).name), 1)
                    ])) : createCommentVNode("", true)
                  ]),
                  _: 2
                }, 1032, ["to"])
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</li>`);
      });
      _push(`<!--]--></ul>`);
    };
  }
});
const _sfc_setup$k = _sfc_main$k.setup;
_sfc_main$k.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/fast-search/Categories.vue");
  return _sfc_setup$k ? _sfc_setup$k(props, ctx) : void 0;
};
const _sfc_main$j = /* @__PURE__ */ defineComponent({
  __name: "SimilarPhrases",
  __ssrInlineRender: true,
  props: {
    phrases: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_router_link = resolveComponent("router-link");
      const _component_fa_icon = resolveComponent("fa-icon");
      if (_ctx.phrases.length > 0) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "border-t" }, _attrs))}><ul><!--[-->`);
        ssrRenderList(_ctx.phrases, (text) => {
          _push(`<li class="py-3">`);
          _push(ssrRenderComponent(_component_router_link, {
            to: "/search?q=" + text
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(ssrRenderComponent(_component_fa_icon, {
                  icon: ["fas", "fa-search"],
                  class: "text-gray-500 px-4"
                }, null, _parent2, _scopeId));
                _push2(`<span${_scopeId}>${ssrInterpolate(text)}</span>`);
              } else {
                return [
                  createVNode(_component_fa_icon, {
                    icon: ["fas", "fa-search"],
                    class: "text-gray-500 px-4"
                  }),
                  createVNode("span", null, toDisplayString(text), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        });
        _push(`<!--]--></ul></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$j = _sfc_main$j.setup;
_sfc_main$j.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/fast-search/SimilarPhrases.vue");
  return _sfc_setup$j ? _sfc_setup$j(props, ctx) : void 0;
};
const _sfc_main$i = /* @__PURE__ */ defineComponent({
  __name: "PopularSearch",
  __ssrInlineRender: true,
  props: {
    strings: {}
  },
  setup(__props) {
    const injectStyles = [
      `.swiper-button-next,
  .swiper-button-prev {
      background-color: white;
      border-radius: 100% ;
      width:25px;
      height:25px;
      border:1px solid #dedede;
      margin-top:-12px;
  }
  .swiper-button-next svg,
  .swiper-button-prev svg {
     width:14px;
     height:14px;
     color:black;
  }
  `
    ];
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_router_link = resolveComponent("router-link");
      _push(`<div${ssrRenderAttrs(_attrs)}><div class="w-full"><div class="flex items-center">`);
      _push(ssrRenderComponent(_component_fa_icon, {
        icon: ["fas", "fa-fire-flame-curved"],
        class: "py-4"
      }, null, _parent));
      _push(`<span class="text-black px-3"> \u062C\u0633\u062A\u062C\u0648\u0647\u0627\u06CC \u067E\u0631\u0637\u0631\u0641\u062F\u0627\u0631 </span></div></div><swiper-container slides-per-view="auto"${ssrRenderAttr("space-between", 15)}${ssrRenderAttr("navigation", true)} class="pb-3"${ssrRenderAttr("injectStyles", injectStyles)}><!--[-->`);
      ssrRenderList(_ctx.strings, (text) => {
        _push(`<swiper-slide class="w-auto px-3 py-1.5 border rounded-lg">`);
        _push(ssrRenderComponent(_component_router_link, {
          to: "/search?q=" + text
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span${_scopeId}>${ssrInterpolate(text)}</span>`);
            } else {
              return [
                createVNode("span", null, toDisplayString(text), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</swiper-slide>`);
      });
      _push(`<!--]--></swiper-container></div>`);
    };
  }
});
const _sfc_setup$i = _sfc_main$i.setup;
_sfc_main$i.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/fast-search/PopularSearch.vue");
  return _sfc_setup$i ? _sfc_setup$i(props, ctx) : void 0;
};
const _sfc_main$h = /* @__PURE__ */ defineComponent({
  __name: "Recent",
  __ssrInlineRender: true,
  props: {
    strings: {},
    clearHistory: { type: Function }
  },
  setup(__props) {
    const injectStyles = [
      `.swiper-button-next,
  .swiper-button-prev {
      background-color: white;
      border-radius: 100% ;
      width:25px;
      height:25px;
      border:1px solid #dedede;
      margin-top:-12px;
  }
  .swiper-button-next svg,
  .swiper-button-prev svg {
     width:14px;
     height:14px;
     color:black;
  }
  `
    ];
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_router_link = resolveComponent("router-link");
      _push(`<!--[--><div class="w-full flex items-center justify-between"><div class="flex items-center">`);
      _push(ssrRenderComponent(_component_fa_icon, {
        icon: ["fas", "fa-clock"],
        class: "py-5"
      }, null, _parent));
      _push(`<span class="text-black px-3"> \u062C\u0633\u062A\u062C\u0648\u0647\u0627\u06CC \u0627\u062E\u06CC\u0631 </span></div>`);
      _push(ssrRenderComponent(_component_fa_icon, {
        icon: ["fas", "fa-trash"],
        class: "text-gray-500 cursor-pointer",
        onClick: ($event) => _ctx.clearHistory()
      }, null, _parent));
      _push(`</div><swiper-container slides-per-view="auto"${ssrRenderAttr("space-between", 15)}${ssrRenderAttr("navigation", true)} class="pb-3"${ssrRenderAttr("injectStyles", injectStyles)}><!--[-->`);
      ssrRenderList(_ctx.strings, (text) => {
        _push(`<swiper-slide class="w-auto px-3 py-1.5 border rounded-lg">`);
        _push(ssrRenderComponent(_component_router_link, {
          to: "/search?q=" + text
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span${_scopeId}>${ssrInterpolate(text)}</span>`);
            } else {
              return [
                createVNode("span", null, toDisplayString(text), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</swiper-slide>`);
      });
      _push(`<!--]--></swiper-container><!--]-->`);
    };
  }
});
const _sfc_setup$h = _sfc_main$h.setup;
_sfc_main$h.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/fast-search/Recent.vue");
  return _sfc_setup$h ? _sfc_setup$h(props, ctx) : void 0;
};
const _sfc_main$g = {
  __name: "Result",
  __ssrInlineRender: true,
  props: {
    hideSearchBox: Function
  },
  setup(__props) {
    const props = __props;
    const loading = ref(false);
    const searchText = ref("");
    const searchResult = ref({});
    const popularSearches = ref([]);
    const searchHistory = ref([]);
    const theme = useState("theme");
    const search = () => {
      if (!loading.value) {
        loading.value = true;
        const url = useRuntimeConfig().public.api + "/products/fast-search?text=" + searchText.value.toString().trim();
        useNuxtApp().$axios.get(url).then((response) => {
          loading.value = false;
          searchResult.value = response.data;
        }).catch(() => {
          loading.value = false;
        });
      }
    };
    const updateSearchHistory = (text) => {
      if (searchHistory.value.includes(text) === false) {
        searchHistory.value.unshift(text);
        if (searchHistory.value.length > 10) {
          searchHistory.value.splice(searchHistory.value.length - 1, 1);
        }
        localStorage.setItem(
          "search-history",
          searchHistory.value.join(",")
        );
      }
    };
    const submit = () => {
      useRouter().push("/search/?q=" + searchText.value);
      updateSearchHistory(searchText.value);
      props.hideSearchBox();
    };
    const clearHistory = () => {
      searchHistory.value = [];
      localStorage.removeItem("search-history");
    };
    watch(() => searchText.value, () => {
      if (searchText.value.toString().trim().length > 3) {
        search();
      }
      if (!searchText.value) {
        searchResult.value = {};
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_FormTextInput = _sfc_main$r;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_Loading = _sfc_main$k$1;
      const _component_DesignPositionView = _sfc_main$u;
      const _component_ThemeFastSearchCategories = _sfc_main$k;
      const _component_ThemeFastSearchSimilarPhrases = _sfc_main$j;
      const _component_ThemeFastSearchPopularSearch = _sfc_main$i;
      const _component_ThemeFastSearchRecent = _sfc_main$h;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "fast-search-result" }, _attrs))}>`);
      _push(ssrRenderComponent(_component_FormTextInput, {
        modelValue: unref(searchText),
        "onUpdate:modelValue": ($event) => isRef(searchText) ? searchText.value = $event : null,
        enter: submit,
        placeholder: unref(theme) === "mobile" ? "\u062C\u0633\u062A\u062C\u0648 \u062F\u0631 \u0647\u0645\u0647 \u06A9\u0627\u0644\u0627 \u0647\u0627" : null,
        autofocus: "",
        name: "search-text"
      }, {
        perfix: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex items-center"${_scopeId}>`);
            ssrRenderSlot(_ctx.$slots, "input-perfix", {}, null, _push2, _parent2, _scopeId);
            _push2(ssrRenderComponent(_component_fa_icon, {
              icon: ["fas", "search"],
              class: "text-gray-500"
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "flex items-center" }, [
                renderSlot(_ctx.$slots, "input-perfix"),
                createVNode(_component_fa_icon, {
                  icon: ["fas", "search"],
                  class: "text-gray-500"
                })
              ])
            ];
          }
        }),
        suffix: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (unref(loading)) {
              _push2(`<div class="flex items-center"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_Loading, { type: "small" }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              unref(loading) ? (openBlock(), createBlock("div", {
                key: 0,
                class: "flex items-center"
              }, [
                createVNode(_component_Loading, { type: "small" })
              ])) : createCommentVNode("", true)
            ];
          }
        }),
        _: 3
      }, _parent));
      _push(`<div class="flex flex-col content">`);
      if (Object.keys(unref(searchResult)).length === 0) {
        _push(`<div class="px-2">`);
        _push(ssrRenderComponent(_component_DesignPositionView, { position: "fast_search-box" }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(searchResult).categories) {
        _push(ssrRenderComponent(_component_ThemeFastSearchCategories, {
          categories: unref(searchResult).categories,
          clearHistory
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      if (unref(searchResult).similarPhrases) {
        _push(ssrRenderComponent(_component_ThemeFastSearchSimilarPhrases, {
          phrases: unref(searchResult).similarPhrases
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      if (unref(popularSearches).length > 0) {
        _push(ssrRenderComponent(_component_ThemeFastSearchPopularSearch, { strings: unref(popularSearches) }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      if (unref(searchHistory).length > 0) {
        _push(ssrRenderComponent(_component_ThemeFastSearchRecent, {
          strings: unref(searchHistory),
          clearHistory
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div>`);
    };
  }
};
const _sfc_setup$g = _sfc_main$g.setup;
_sfc_main$g.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/fast-search/Result.vue");
  return _sfc_setup$g ? _sfc_setup$g(props, ctx) : void 0;
};
const _sfc_main$f = /* @__PURE__ */ defineComponent({
  __name: "Input",
  __ssrInlineRender: true,
  setup(__props) {
    const global = useNuxtApp().vueApp.config.globalProperties;
    const shopSetting = useState("shopSetting");
    const theme = useState("theme");
    const showResultBox = ref(false);
    const offcanvasRef = ref(null);
    const searchBoxTrailingComponents = global["$fast-search:box-trailing"];
    watch(() => showResultBox.value, () => {
      const cover = (void 0).querySelector(".bg-cover");
      if (cover) {
        showResultBox.value == true ? cover.style.display = "block" : cover.style.display = "none";
      }
    });
    const hideSearchBox = () => {
      var _a;
      if (theme.value == "desktop") {
        showResultBox.value = false;
      } else {
        (_a = offcanvasRef.value) == null ? void 0 : _a.hide();
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_ThemeFastSearchResult = _sfc_main$g;
      const _component_Offcanvas = _sfc_main$o;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "relative w-full fast-search-box" }, _attrs))}><div class="rounded-lg flex items-center justify-between h-search-input"><div class="flex items-center flex-grow">`);
      _push(ssrRenderComponent(_component_fa_icon, {
        icon: ["fas", "fa-search"],
        class: "text-gray-500 m-3"
      }, null, _parent));
      _push(`<div class="text-gray-500"> \u062C\u0633\u062A \u0648 \u062C\u0648 `);
      if (unref(shopSetting)) {
        _push(`<span class="shop-name"> \u062F\u0631 ${ssrInterpolate(unref(shopSetting).name)}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div>`);
      if (unref(searchBoxTrailingComponents)) {
        _push(`<!--[-->`);
        ssrRenderList(unref(searchBoxTrailingComponents), (component, key) => {
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(component), { key }, null), _parent);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
      if (unref(showResultBox) && unref(theme) == "desktop") {
        _push(`<div class="h-search-box" id="h-search-box">`);
        _push(ssrRenderComponent(_component_ThemeFastSearchResult, { "hide-search-box": hideSearchBox }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_component_Offcanvas, {
        ref_key: "offcanvasRef",
        ref: offcanvasRef,
        direction: "bottom",
        "content-class": "w-full"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_ThemeFastSearchResult, null, {
              "input-perfix": withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(ssrRenderComponent(_component_fa_icon, {
                    icon: ["fas", "fa-arrow-right"],
                    onClick: ($event) => unref(offcanvasRef).hide(),
                    class: "px-4 cursor-pointer"
                  }, null, _parent3, _scopeId2));
                } else {
                  return [
                    createVNode(_component_fa_icon, {
                      icon: ["fas", "fa-arrow-right"],
                      onClick: ($event) => unref(offcanvasRef).hide(),
                      class: "px-4 cursor-pointer"
                    }, null, 8, ["onClick"])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_ThemeFastSearchResult, null, {
                "input-perfix": withCtx(() => [
                  createVNode(_component_fa_icon, {
                    icon: ["fas", "fa-arrow-right"],
                    onClick: ($event) => unref(offcanvasRef).hide(),
                    class: "px-4 cursor-pointer"
                  }, null, 8, ["onClick"])
                ]),
                _: 1
              })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
    };
  }
});
const _sfc_setup$f = _sfc_main$f.setup;
_sfc_main$f.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/fast-search/Input.vue");
  return _sfc_setup$f ? _sfc_setup$f(props, ctx) : void 0;
};
const _sfc_main$e = /* @__PURE__ */ defineComponent({
  __name: "DesktopProfileLink",
  __ssrInlineRender: true,
  setup(__props) {
    const user = useState("user");
    const show = ref(false);
    const global = useNuxtApp().vueApp.config.globalProperties;
    const quickAccessItems = global.$sort(
      global["$profile:quick-access"],
      "index"
    );
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0$2;
      const _component_fa_icon = resolveComponent("fa-icon");
      if (!unref(user)) {
        _push(ssrRenderComponent(_component_nuxt_link, mergeProps({
          to: "/login",
          class: "border rounded-md flex items-center py-2 px-4"
        }, _attrs), {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(_component_fa_icon, {
                icon: ["fas", "right-to-bracket"],
                class: "rotate-180"
              }, null, _parent2, _scopeId));
              _push2(`<span class="pr-2"${_scopeId}> \u0648\u0631\u0648\u062F | \u062B\u0628\u062A \u0646\u0627\u0645 </span>`);
            } else {
              return [
                createVNode(_component_fa_icon, {
                  icon: ["fas", "right-to-bracket"],
                  class: "rotate-180"
                }),
                createVNode("span", { class: "pr-2" }, " \u0648\u0631\u0648\u062F | \u062B\u0628\u062A \u0646\u0627\u0645 ")
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "relative" }, _attrs))}><button class="flex items-center pb-3 cursor-pointer">`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["far", "user"],
          class: "text-xl"
        }, null, _parent));
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fas", "angle-down"],
          class: "px-2"
        }, null, _parent));
        _push(`</button>`);
        if (unref(show)) {
          _push(`<div class="header-popup z-50" id="panel-quick-access"><ul><li class="flex items-center px-3">`);
          _push(ssrRenderComponent(_component_nuxt_link, {
            to: "/profile",
            class: "w-full py-5 flex items-center justify-between border-b"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                if (unref(user).first_name) {
                  _push2(`<span class="font-bold text-black"${_scopeId}>${ssrInterpolate(unref(user).first_name + " " + unref(user).last_name)}</span>`);
                } else {
                  _push2(`<span class="font-bold text-black"${_scopeId}>${ssrInterpolate(_ctx.$replaceEnNumber(unref(user).username))}</span>`);
                }
                _push2(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "angle-left"] }, null, _parent2, _scopeId));
              } else {
                return [
                  unref(user).first_name ? (openBlock(), createBlock("span", {
                    key: 0,
                    class: "font-bold text-black"
                  }, toDisplayString(unref(user).first_name + " " + unref(user).last_name), 1)) : (openBlock(), createBlock("span", {
                    key: 1,
                    class: "font-bold text-black"
                  }, toDisplayString(_ctx.$replaceEnNumber(unref(user).username)), 1)),
                  createVNode(_component_fa_icon, { icon: ["fas", "angle-left"] })
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`</li><!--[-->`);
          ssrRenderList(unref(quickAccessItems), (item, key) => {
            var _a;
            _push(`<li class="flex items-center px-3 cursor-pointer">`);
            _push(ssrRenderComponent(_component_fa_icon, {
              icon: item.icon,
              class: "text-xl pl-2"
            }, null, _parent));
            _push(ssrRenderComponent(_component_nuxt_link, {
              to: (_a = item.route) != null ? _a : null,
              onClick: ($event) => item.event ? item.event() : null,
              class: [{ "border-b": key != unref(quickAccessItems).length - 1 }, "flex text-black py-3 mr-2 flex-grow justify-between"]
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`<span class="font-bold"${_scopeId}>${ssrInterpolate(item.title)}</span>`);
                } else {
                  return [
                    createVNode("span", { class: "font-bold" }, toDisplayString(item.title), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
            _push(`</li>`);
          });
          _push(`<!--]--></ul></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      }
    };
  }
});
const _sfc_setup$e = _sfc_main$e.setup;
_sfc_main$e.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/users/DesktopProfileLink.vue");
  return _sfc_setup$e ? _sfc_setup$e(props, ctx) : void 0;
};
const _sfc_main$d = /* @__PURE__ */ defineComponent({
  __name: "DesktopIcon",
  __ssrInlineRender: true,
  setup(__props) {
    const show = ref(false);
    const store = cartStore();
    const showCartBox = () => {
      if (store.cartData["current"] && store.cartData["current"].products.length > 0) {
        show.value = true;
      }
    };
    const hideCartBox = () => {
      show.value = false;
    };
    const products = computed(() => {
      return store.cartData["current"].products;
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0$2;
      const _component_IconBadge = _sfc_main$q;
      const _component_router_link = resolveComponent("router-link");
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_CartProducts = _sfc_main$n;
      const _component_IconsToman = __nuxt_component_3$1;
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_nuxt_link, { to: "/cart" }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_IconBadge, {
              icon: ["fas", "cart-shopping"],
              onMouseenter: showCartBox,
              onMouseleave: hideCartBox,
              class: "mx-4 cursor-pointer",
              count: unref(store).cartData["current"] ? unref(store).cartData["current"].products.length : null
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_IconBadge, {
                icon: ["fas", "cart-shopping"],
                onMouseenter: showCartBox,
                onMouseleave: hideCartBox,
                class: "mx-4 cursor-pointer",
                count: unref(store).cartData["current"] ? unref(store).cartData["current"].products.length : null
              }, null, 8, ["count"])
            ];
          }
        }),
        _: 1
      }, _parent));
      if (unref(show)) {
        _push(`<div class="header-cart-popup z-50"><div class="flex justify-between items-center p-3"><span class="text-xs">${ssrInterpolate(_ctx.$replaceEnNumber(unref(products).length))} \u06A9\u0627\u0644\u0627 </span>`);
        _push(ssrRenderComponent(_component_router_link, {
          to: "/cart",
          class: "text-xs p-1 text-blue-400"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span${_scopeId}>\u0645\u0634\u0627\u0647\u062F\u0647 \u0633\u0628\u062F \u062E\u0631\u06CC\u062F</span>`);
              _push2(ssrRenderComponent(_component_fa_icon, {
                icon: ["fas", "fa-angle-left"],
                class: "pr-3"
              }, null, _parent2, _scopeId));
            } else {
              return [
                createVNode("span", null, "\u0645\u0634\u0627\u0647\u062F\u0647 \u0633\u0628\u062F \u062E\u0631\u06CC\u062F"),
                createVNode(_component_fa_icon, {
                  icon: ["fas", "fa-angle-left"],
                  class: "pr-3"
                })
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div><div class="content cart">`);
        _push(ssrRenderComponent(_component_CartProducts, { products: unref(products) }, null, _parent));
        _push(`</div><div class="flex items-center justify-between border-t"><div class="flex flex-col"><span class="p-2 text-gray-600 text-sm"> \u0645\u0628\u0644\u063A \u0642\u0627\u0628\u0644 \u067E\u0631\u062F\u0627\u062E\u062A </span><span class="p-2 font-bold !text-black flex items-center">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(unref(store).getFinalCartPrice())))} `);
        _push(ssrRenderComponent(_component_IconsToman, { class: "mb-2" }, null, _parent));
        _push(`</span></div>`);
        _push(ssrRenderComponent(_component_nuxt_link, {
          to: "/cart",
          class: "c-btn px-3 m-4 text-white"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(` \u062B\u0628\u062A \u0633\u0641\u0627\u0631\u0634 `);
            } else {
              return [
                createTextVNode(" \u062B\u0628\u062A \u0633\u0641\u0627\u0631\u0634 ")
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup$d = _sfc_main$d.setup;
_sfc_main$d.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/cart/DesktopIcon.vue");
  return _sfc_setup$d ? _sfc_setup$d(props, ctx) : void 0;
};
const _sfc_main$c = /* @__PURE__ */ defineComponent({
  __name: "MegaMenu",
  __ssrInlineRender: true,
  props: {
    showMenus: { type: Boolean }
  },
  setup(__props) {
    const props = __props;
    const show = ref(props.showMenus);
    const categories = useState("categories");
    const selectedCategory = ref(null);
    const getCategories = (parentId) => {
      return categories.value.filter((category) => category.parent_id == parentId);
    };
    watch(() => props.showMenus, () => {
      const cover = (void 0).querySelector(".bg-cover");
      if (cover) {
        props.showMenus ? cover.style.display = "block" : cover.style.display = "none";
      }
      show.value = props.showMenus;
    });
    watch(() => show.value, () => {
      if (!show.value) {
        const cover = (void 0).querySelector(".bg-cover");
        if (cover) {
          show.value ? cover.style.display = "block" : cover.style.display = "none";
        }
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0$2;
      const _component_fa_icon = resolveComponent("fa-icon");
      if (unref(show)) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "desktop-header-mega-menu text-sm" }, _attrs))}><div class="main-categories"><ul><!--[-->`);
        ssrRenderList(getCategories(0), (category) => {
          _push(`<!--[-->`);
          if (category.parent_id == 0) {
            _push(`<li class="${ssrRenderClass([unref(selectedCategory) == category ? "active" : ""])}">`);
            _push(ssrRenderComponent(_component_nuxt_link, {
              to: "/main/" + category.slug,
              onClick: ($event) => show.value = false
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  if (category.icon) {
                    _push2(ssrRenderComponent(_component_fa_icon, {
                      icon: category.icon
                    }, null, _parent2, _scopeId));
                  } else {
                    _push2(`<!---->`);
                  }
                  _push2(`<span class="px-1.5"${_scopeId}>${ssrInterpolate(category.name)}</span>`);
                } else {
                  return [
                    category.icon ? (openBlock(), createBlock(_component_fa_icon, {
                      key: 0,
                      icon: category.icon
                    }, null, 8, ["icon"])) : createCommentVNode("", true),
                    createVNode("span", { class: "px-1.5" }, toDisplayString(category.name), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
            _push(`</li>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]--></ul></div>`);
        if (unref(selectedCategory)) {
          _push(`<div class="w-full flex-grow child-categories">`);
          _push(ssrRenderComponent(_component_nuxt_link, {
            to: "/search/" + unref(selectedCategory).slug,
            class: "p-4 block font-bold",
            onClick: ($event) => show.value = false
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<span${_scopeId}>\u0647\u0645\u0647 \u0645\u062D\u0635\u0648\u0644\u0627\u062A ${ssrInterpolate(unref(selectedCategory).name)}</span>`);
              } else {
                return [
                  createVNode("span", null, "\u0647\u0645\u0647 \u0645\u062D\u0635\u0648\u0644\u0627\u062A " + toDisplayString(unref(selectedCategory).name), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`<ul><!--[-->`);
          ssrRenderList(getCategories(unref(selectedCategory).id), (child1) => {
            _push(`<!--[--><li class="font-bold text-black">`);
            _push(ssrRenderComponent(_component_nuxt_link, {
              to: "/search/" + child1.slug,
              class: "flex items-center",
              onClick: ($event) => show.value = false
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`<span${_scopeId}>${ssrInterpolate(child1.name)}</span>`);
                  _push2(ssrRenderComponent(_component_fa_icon, {
                    icon: ["fas", "angle-left"],
                    class: "px-1.5"
                  }, null, _parent2, _scopeId));
                } else {
                  return [
                    createVNode("span", null, toDisplayString(child1.name), 1),
                    createVNode(_component_fa_icon, {
                      icon: ["fas", "angle-left"],
                      class: "px-1.5"
                    })
                  ];
                }
              }),
              _: 2
            }, _parent));
            _push(`</li><!--[-->`);
            ssrRenderList(getCategories(child1.id), (child2) => {
              _push(`<li>`);
              _push(ssrRenderComponent(_component_nuxt_link, {
                to: child2.url === null ? "/search/" + child1.slug + "/" + child2.slug : child2.url,
                onClick: ($event) => show.value = false
              }, {
                default: withCtx((_, _push2, _parent2, _scopeId) => {
                  if (_push2) {
                    _push2(`<span${_scopeId}>${ssrInterpolate(child2.name)}</span>`);
                  } else {
                    return [
                      createVNode("span", null, toDisplayString(child2.name), 1)
                    ];
                  }
                }),
                _: 2
              }, _parent));
              _push(`</li>`);
            });
            _push(`<!--]--><!--]-->`);
          });
          _push(`<!--]--></ul></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$c = _sfc_main$c.setup;
_sfc_main$c.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/desktop/MegaMenu.vue");
  return _sfc_setup$c ? _sfc_setup$c(props, ctx) : void 0;
};
const _sfc_main$b = /* @__PURE__ */ defineComponent({
  __name: "HeaderMenus",
  __ssrInlineRender: true,
  setup(__props) {
    const showMenus = ref(false);
    const themeSetting = useState("theme-setting");
    const isExternalLink = (link) => {
      return /^https?:\/\//.test(link);
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_ThemeDesktopMegaMenu = _sfc_main$c;
      const _component_nuxt_link = __nuxt_component_0$2;
      _push(`<ul${ssrRenderAttrs(mergeProps({
        class: "flex items-center text-[14px] text-gray-600",
        id: "header-menus"
      }, _attrs))}><li class="hover-line"><div></div></li><li class="border-l flex items-center p-2"><a href="#" class="font-bold text-black">`);
      _push(ssrRenderComponent(_component_fa_icon, {
        icon: ["fas", "fa-bars"],
        class: "px-2"
      }, null, _parent));
      _push(`<span>\u062F\u0633\u062A\u0647\u200C\u0628\u0646\u062F\u06CC \u06A9\u0627\u0644\u0627\u0647\u0627</span></a>`);
      _push(ssrRenderComponent(_component_ThemeDesktopMegaMenu, {
        ref: "megaMenu",
        showMenus: unref(showMenus)
      }, null, _parent));
      _push(`</li>`);
      if (unref(themeSetting)["header"]) {
        _push(`<!--[-->`);
        ssrRenderList(unref(themeSetting)["header"].menus, (menu) => {
          _push(`<li class="flex items-center cursor-pointer p-2">`);
          if (isExternalLink(menu.link)) {
            _push(`<a${ssrRenderAttr("href", menu.link)} target="_blank" rel="noopener noreferrer">`);
            if (menu.icon) {
              _push(ssrRenderComponent(_component_fa_icon, {
                icon: menu.icon.split(" "),
                class: "px-2"
              }, null, _parent));
            } else {
              _push(`<!---->`);
            }
            _push(`<span>${ssrInterpolate(menu.title)}</span></a>`);
          } else {
            _push(ssrRenderComponent(_component_nuxt_link, {
              to: "/" + menu.link
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  if (menu.icon) {
                    _push2(ssrRenderComponent(_component_fa_icon, {
                      icon: menu.icon.split(" "),
                      class: "px-2"
                    }, null, _parent2, _scopeId));
                  } else {
                    _push2(`<!---->`);
                  }
                  _push2(`<span${_scopeId}>${ssrInterpolate(menu.title)}</span>`);
                } else {
                  return [
                    menu.icon ? (openBlock(), createBlock(_component_fa_icon, {
                      key: 0,
                      icon: menu.icon.split(" "),
                      class: "px-2"
                    }, null, 8, ["icon"])) : createCommentVNode("", true),
                    createVNode("span", null, toDisplayString(menu.title), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
          }
          _push(`</li>`);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`</ul>`);
    };
  }
});
const _sfc_setup$b = _sfc_main$b.setup;
_sfc_main$b.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/desktop/HeaderMenus.vue");
  return _sfc_setup$b ? _sfc_setup$b(props, ctx) : void 0;
};
const _sfc_main$a = /* @__PURE__ */ defineComponent({
  __name: "SelectDefault",
  __ssrInlineRender: true,
  setup(__props) {
    const theme = useState("theme");
    const cityId = ref(null);
    const boxRef = ref(null);
    const provinces = useState("provinces");
    const cities = useState("cities");
    const selectedProvince = ref(null);
    const searchText = ref("");
    const selectCity = (city) => {
      boxRef.value.hide();
      cityId.value = city.id;
      localStorage.setItem("city-id", cityId.value);
    };
    const getCityName = computed(() => {
      var _a, _b;
      return ((_b = (_a = cities.value) == null ? void 0 : _a.find((city) => city.id == cityId.value)) == null ? void 0 : _b.name) || "";
    });
    const getCityProvince = computed(() => {
      var _a, _b, _c;
      const city = (_a = cities.value) == null ? void 0 : _a.find((city2) => city2.id == cityId.value);
      if (city) {
        return ((_c = (_b = provinces.value) == null ? void 0 : _b.find((province) => province.id == city.province_id)) == null ? void 0 : _c.name) || "";
      }
      return "";
    });
    watch(() => selectedProvince.value, () => {
      searchText.value = "";
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_FormTextInput = _sfc_main$r;
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<!--[-->`);
      if (unref(theme) == "desktop" || ("useRoute" in _ctx ? _ctx.useRoute : unref(useRoute))().path == "/") {
        _push(`<div class="text-sm py-3 lg:p-0">`);
        if (!unref(cityId)) {
          _push(`<span>\u0627\u0646\u062A\u062E\u0627\u0628 \u0634\u0647\u0631</span>`);
        } else {
          _push(`<div><span>\u0627\u0631\u0633\u0627\u0644 \u0628\u0647 </span><span>${ssrInterpolate(unref(getCityName))}</span><span> , ${ssrInterpolate(unref(getCityProvince))}</span></div>`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(theme) == "desktop" ? _sfc_main$i$1 : _sfc_main$o), {
        ref_key: "boxRef",
        ref: boxRef,
        title: unref(selectedProvince) ? "\u0627\u0646\u062A\u062E\u0627\u0628 \u0634\u0647\u0631" : "\u0627\u0646\u062A\u062E\u0627\u0628 \u0627\u0633\u062A\u0627\u0646",
        "content-class": "w-full"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="lg:w-[500px]"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_FormTextInput, {
              placeholder: unref(selectedProvince) ? "\u0646\u0627\u0645 \u0634\u0647\u0631 .." : "\u0646\u0627\u0645 \u0627\u0633\u062A\u0627\u0646 ...",
              modelValue: unref(searchText),
              "onUpdate:modelValue": ($event) => isRef(searchText) ? searchText.value = $event : null,
              "hide-label": "",
              class: "w-full"
            }, null, _parent2, _scopeId));
            if (!unref(selectedProvince)) {
              _push2(`<ul${_scopeId}><!--[-->`);
              ssrRenderList(unref(provinces), (province) => {
                _push2(`<!--[-->`);
                if (province.name.indexOf(unref(searchText)) >= 0) {
                  _push2(`<li class="p-3 text-sm text-gray-700 cursor-pointer"${_scopeId}>${ssrInterpolate(province.name)}</li>`);
                } else {
                  _push2(`<!---->`);
                }
                _push2(`<!--]-->`);
              });
              _push2(`<!--]--></ul>`);
            } else {
              _push2(`<div${_scopeId}><div class="p-3"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "arrow-right"] }, null, _parent2, _scopeId));
              _push2(`<span class="px-2"${_scopeId}>\u0647\u0645\u0647 \u0627\u0633\u062A\u0627\u0646 \u0647\u0627</span></div><ul${_scopeId}><!--[-->`);
              ssrRenderList(unref(cities).filter((city) => city.province_id == unref(selectedProvince).id), (city) => {
                _push2(`<!--[-->`);
                if (city.name.indexOf(unref(searchText)) >= 0) {
                  _push2(`<li class="p-3 text-sm text-gray-700 cursor-pointer"${_scopeId}>${ssrInterpolate(city.name)}</li>`);
                } else {
                  _push2(`<!---->`);
                }
                _push2(`<!--]-->`);
              });
              _push2(`<!--]--></ul></div>`);
            }
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "lg:w-[500px]" }, [
                createVNode(_component_FormTextInput, {
                  placeholder: unref(selectedProvince) ? "\u0646\u0627\u0645 \u0634\u0647\u0631 .." : "\u0646\u0627\u0645 \u0627\u0633\u062A\u0627\u0646 ...",
                  modelValue: unref(searchText),
                  "onUpdate:modelValue": ($event) => isRef(searchText) ? searchText.value = $event : null,
                  "hide-label": "",
                  class: "w-full"
                }, null, 8, ["placeholder", "modelValue", "onUpdate:modelValue"]),
                !unref(selectedProvince) ? (openBlock(), createBlock("ul", { key: 0 }, [
                  (openBlock(true), createBlock(Fragment, null, renderList(unref(provinces), (province) => {
                    return openBlock(), createBlock(Fragment, {
                      key: province.id
                    }, [
                      province.name.indexOf(unref(searchText)) >= 0 ? (openBlock(), createBlock("li", {
                        key: 0,
                        onClick: ($event) => selectedProvince.value = province,
                        class: "p-3 text-sm text-gray-700 cursor-pointer"
                      }, toDisplayString(province.name), 9, ["onClick"])) : createCommentVNode("", true)
                    ], 64);
                  }), 128))
                ])) : (openBlock(), createBlock("div", { key: 1 }, [
                  createVNode("div", {
                    onClick: ($event) => selectedProvince.value = null,
                    class: "p-3"
                  }, [
                    createVNode(_component_fa_icon, { icon: ["fas", "arrow-right"] }),
                    createVNode("span", { class: "px-2" }, "\u0647\u0645\u0647 \u0627\u0633\u062A\u0627\u0646 \u0647\u0627")
                  ], 8, ["onClick"]),
                  createVNode("ul", null, [
                    (openBlock(true), createBlock(Fragment, null, renderList(unref(cities).filter((city) => city.province_id == unref(selectedProvince).id), (city) => {
                      return openBlock(), createBlock(Fragment, {
                        key: city.id
                      }, [
                        city.name.indexOf(unref(searchText)) >= 0 ? (openBlock(), createBlock("li", {
                          key: 0,
                          onClick: ($event) => selectCity(city),
                          class: "p-3 text-sm text-gray-700 cursor-pointer"
                        }, toDisplayString(city.name), 9, ["onClick"])) : createCommentVNode("", true)
                      ], 64);
                    }), 128))
                  ])
                ]))
              ])
            ];
          }
        }),
        _: 1
      }), _parent);
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup$a = _sfc_main$a.setup;
_sfc_main$a.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/area/SelectDefault.vue");
  return _sfc_setup$a ? _sfc_setup$a(props, ctx) : void 0;
};
const _sfc_main$9 = /* @__PURE__ */ defineComponent({
  __name: "Header",
  __ssrInlineRender: true,
  setup(__props) {
    const shopSetting = useState("shopSetting");
    const themeSetting = useState("theme-setting");
    const user = useState("user");
    const hideMenusSection = ref(false);
    const { serverUrl } = useRuntimeConfig().public;
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0$2;
      const _component_NuxtImg = _sfc_main$l;
      const _component_ThemeFastSearchInput = _sfc_main$f;
      const _component_Skeleton = __nuxt_component_3;
      const _component_UsersDesktopProfileLink = _sfc_main$e;
      const _component_CartDesktopIcon = _sfc_main$d;
      const _component_ThemeDesktopHeaderMenus = _sfc_main$b;
      const _component_AreaSelectDefault = _sfc_main$a;
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: ["desktop-header z-40", unref(themeSetting)["header"].className]
      }, _attrs))}>`);
      if (unref(themeSetting)["header"].banner) {
        _push(`<img alt="banner" class="w-full"${ssrRenderAttr("src", unref(themeSetting)["header"].banner)}>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<header class="bg-white border-b px-5 pt-3 w-full"><div class="w-full flex justify-between items-center"><div class="flex items-center flex-grow"><div class="logo">`);
      if (unref(shopSetting)) {
        _push(ssrRenderComponent(_component_nuxt_link, { to: "/" }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(_component_NuxtImg, {
                src: unref(serverUrl) + "/" + unref(shopSetting)["icon"],
                class: "logo",
                format: "webp",
                width: 96,
                height: 50,
                alt: unref(shopSetting).name
              }, null, _parent2, _scopeId));
            } else {
              return [
                createVNode(_component_NuxtImg, {
                  src: unref(serverUrl) + "/" + unref(shopSetting)["icon"],
                  class: "logo",
                  format: "webp",
                  width: 96,
                  height: 50,
                  alt: unref(shopSetting).name
                }, null, 8, ["src", "alt"])
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
      _push(ssrRenderComponent(_component_ThemeFastSearchInput, null, null, _parent));
      _push(`</div><div class="flex items-center actions">`);
      if (unref(user) == "loading") {
        _push(ssrRenderComponent(_component_Skeleton, { class: "w-[100px] h-[35px] mx-4 rounded-md" }, null, _parent));
      } else {
        _push(ssrRenderComponent(_component_UsersDesktopProfileLink, { class: "mx-4" }, null, _parent));
      }
      _push(`<div class="w-[1px] h-8 mb-2 mx-2 bg-gray-200"></div>`);
      _push(ssrRenderComponent(_component_CartDesktopIcon, null, null, _parent));
      _push(`</div></div>`);
      if (!unref(hideMenusSection)) {
        _push(`<div class="w-full flex justify-between">`);
        _push(ssrRenderComponent(_component_ThemeDesktopHeaderMenus, null, null, _parent));
        _push(ssrRenderComponent(_component_AreaSelectDefault, null, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</header></div>`);
    };
  }
});
const _sfc_setup$9 = _sfc_main$9.setup;
_sfc_main$9.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/desktop/Header.vue");
  return _sfc_setup$9 ? _sfc_setup$9(props, ctx) : void 0;
};
const _sfc_main$8 = /* @__PURE__ */ defineComponent({
  __name: "Support",
  __ssrInlineRender: true,
  setup(__props) {
    const theme = useState("theme");
    const themeSetting = useState("theme-setting");
    const shopSetting = useState("shopSetting");
    const { serverUrl } = useRuntimeConfig().public;
    return (_ctx, _push, _parent, _attrs) => {
      const _component_NuxtImg = _sfc_main$l;
      const _component_fa_icon = resolveComponent("fa-icon");
      if (unref(theme) == "desktop") {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex items-center justify-between support-box" }, _attrs))}><div>`);
        if (unref(themeSetting)["footer"].showLogo) {
          _push(ssrRenderComponent(_component_NuxtImg, {
            src: unref(serverUrl) + "/" + unref(shopSetting).icon,
            class: "logo",
            format: "webp",
            width: 96,
            height: 96,
            loading: "lazy",
            alt: unref(shopSetting).name
          }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="text-sm py-3"><div class="flex items-center"><span> \u062A\u0644\u0641\u0646 \u067E\u0634\u062A\u06CC\u0628\u0627\u0646\u06CC : ${ssrInterpolate(_ctx.$replaceEnNumber(unref(shopSetting).phone))}</span><div class="h-4 bg-gray-200 w-0.5 mx-3"></div><span> \u06F7 \u0631\u0648\u0632 \u0647\u0641\u062A\u0647\u060C \u06F2\u06F4 \u0633\u0627\u0639\u062A\u0647 \u067E\u0627\u0633\u062E\u06AF\u0648\u06CC \u0634\u0645\u0627 \u0647\u0633\u062A\u06CC\u0645 </span></div>`);
        if (unref(themeSetting)["footer"].email) {
          _push(`<div class="pt-5"><span>\u0627\u06CC\u0645\u06CC\u0644: </span><span>${ssrInterpolate(unref(themeSetting)["footer"].email)}</span></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div><button class="border rounded-md py-2 px-3 text-gray-500"><span>\u0628\u0627\u0632\u06AF\u0634\u062A \u0628\u0647 \u0628\u0627\u0644\u0627</span>`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fas", "fa-angle-up"],
          class: "pr-2"
        }, null, _parent));
        _push(`</button></div>`);
      } else {
        _push(`<div${ssrRenderAttrs(_attrs)}><div class="w-full flex justify-center"><button class="text-blue-400"><span>\u0628\u0627\u0632\u06AF\u0634\u062A \u0628\u0647 \u0628\u0627\u0644\u0627</span>`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fas", "fa-angle-up"],
          class: "pr-2"
        }, null, _parent));
        _push(`</button></div><div class="my-4 flex justify-between items-center"><div class="flex items-center"><div>`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fas", "headset"],
          class: "text-2xl"
        }, null, _parent));
        _push(`</div><div class="flex flex-col px-4"><span>\u06F7 \u0631\u0648\u0632 \u0647\u0641\u062A\u0647\u060C \u06F2\u06F4 \u0633\u0627\u0639\u062A\u0647</span>`);
        if (unref(themeSetting)["footer"]) {
          _push(`<span class="pt-2"> \u0627\u06CC\u0645\u06CC\u0644 : ${ssrInterpolate(unref(themeSetting)["footer"].email)}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div><div>`);
        if (unref(shopSetting)) {
          _push(`<a${ssrRenderAttr("href", `tel:${unref(shopSetting).phone}`)} class="font-bold border rounded-lg border-black px-3 py-2"> \u062A\u0645\u0627\u0633 \u0628\u0627 \u0645\u0627 </a>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div></div>`);
      }
    };
  }
});
const _sfc_setup$8 = _sfc_main$8.setup;
_sfc_main$8.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/footer/Support.vue");
  return _sfc_setup$8 ? _sfc_setup$8(props, ctx) : void 0;
};
const _sfc_main$7 = /* @__PURE__ */ defineComponent({
  __name: "SupportItems",
  __ssrInlineRender: true,
  setup(__props) {
    const themeSetting = useState("theme-setting");
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0$2;
      if (unref(themeSetting)["footer"].features && unref(themeSetting)["footer"].features.length > 0) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "py-10 text-xs flex" }, _attrs))}><!--[-->`);
        ssrRenderList(unref(themeSetting)["footer"].features, (item, index) => {
          _push(`<div class="w-full">`);
          _push(ssrRenderComponent(_component_nuxt_link, {
            to: item.link,
            class: "flex flex-col items-center"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<img${ssrRenderAttr("alt", item.title)}${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/" + item.image)}${_scopeId}><span${_scopeId}>${ssrInterpolate(item.title)}</span>`);
              } else {
                return [
                  createVNode("img", {
                    alt: item.title,
                    src: ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/" + item.image
                  }, null, 8, ["alt", "src"]),
                  createVNode("span", null, toDisplayString(item.title), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</div>`);
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$7 = _sfc_main$7.setup;
_sfc_main$7.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/SupportItems.vue");
  return _sfc_setup$7 ? _sfc_setup$7(props, ctx) : void 0;
};
const _sfc_main$6 = /* @__PURE__ */ defineComponent({
  __name: "SocialNetworks",
  __ssrInlineRender: true,
  setup(__props) {
    const themeSetting = useState("theme-setting");
    return (_ctx, _push, _parent, _attrs) => {
      if (unref(themeSetting).footer["socialNetworks"]) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "justify-center flex lg:justify-start" }, _attrs))}>`);
        if (unref(themeSetting).footer["socialNetworks"].aparat) {
          _push(`<a class="py-2"${ssrRenderAttr("href", unref(themeSetting).footer["socialNetworks"].aparat)} target="_blank"><img alt="aparat"${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/images/aparat.svg")}></a>`);
        } else {
          _push(`<!---->`);
        }
        if (unref(themeSetting).footer["socialNetworks"].instagram) {
          _push(`<a class="p-2"${ssrRenderAttr("href", unref(themeSetting).footer["socialNetworks"].instagram)} target="_blank"><img alt="instagram"${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/images/instagram.svg")}></a>`);
        } else {
          _push(`<!---->`);
        }
        if (unref(themeSetting).footer["socialNetworks"].telegram) {
          _push(`<a class="p-2"${ssrRenderAttr("href", unref(themeSetting).footer["socialNetworks"].telegram)} target="_blank"><img alt="telegram"${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/images/telegram.svg")}></a>`);
        } else {
          _push(`<!---->`);
        }
        if (unref(themeSetting).footer["socialNetworks"].linkedin) {
          _push(`<a class="p-2"${ssrRenderAttr("href", unref(themeSetting).footer["socialNetworks"].linkedin)} target="_blank"><img alt="linkedin"${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/images/linkedin.svg")}></a>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$6 = _sfc_main$6.setup;
_sfc_main$6.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/footer/SocialNetworks.vue");
  return _sfc_setup$6 ? _sfc_setup$6(props, ctx) : void 0;
};
const _sfc_main$5 = /* @__PURE__ */ defineComponent({
  __name: "NewsletterForm",
  __ssrInlineRender: true,
  props: {
    "modelValue": {},
    "modelModifiers": {}
  },
  emits: ["update:modelValue"],
  setup(__props) {
    const email = useModel(__props, "modelValue");
    const sendRequest = () => {
    };
    const validate = computed(() => {
      var _a;
      const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      return (_a = email.value) == null ? void 0 : _a.toString().trim().match(emailRegex);
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_FormComponent = _sfc_main$s;
      const _component_FormTextInput = _sfc_main$r;
      const _component_FormButton = _sfc_main$t;
      _push(ssrRenderComponent(_component_FormComponent, mergeProps({
        "send-function": sendRequest,
        class: "flex"
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_FormTextInput, {
              label: "\u0622\u062F\u0631\u0633 \u0627\u06CC\u0645\u06CC\u0644",
              name: "email",
              class: "w-full",
              "hide-label": "",
              placeholder: "\u0627\u06CC\u0645\u06CC\u0644 \u0634\u0645\u0627",
              rules: ["required", "email"],
              modelValue: email.value,
              "onUpdate:modelValue": ($event) => email.value = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_FormButton, {
              "class-name": unref(validate) ? "btn-danger" : "btn-secondary"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(` \u062B\u0628\u062A `);
                } else {
                  return [
                    createTextVNode(" \u062B\u0628\u062A ")
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_FormTextInput, {
                label: "\u0622\u062F\u0631\u0633 \u0627\u06CC\u0645\u06CC\u0644",
                name: "email",
                class: "w-full",
                "hide-label": "",
                placeholder: "\u0627\u06CC\u0645\u06CC\u0644 \u0634\u0645\u0627",
                rules: ["required", "email"],
                modelValue: email.value,
                "onUpdate:modelValue": ($event) => email.value = $event
              }, null, 8, ["modelValue", "onUpdate:modelValue"]),
              createVNode(_component_FormButton, {
                "class-name": unref(validate) ? "btn-danger" : "btn-secondary"
              }, {
                default: withCtx(() => [
                  createTextVNode(" \u062B\u0628\u062A ")
                ]),
                _: 1
              }, 8, ["class-name"])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
});
const _sfc_setup$5 = _sfc_main$5.setup;
_sfc_main$5.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/footer/NewsletterForm.vue");
  return _sfc_setup$5 ? _sfc_setup$5(props, ctx) : void 0;
};
const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  __name: "View",
  __ssrInlineRender: true,
  setup(__props) {
    const shopSetting = useState("shopSetting");
    const themeSetting = useState("theme-setting");
    const { serverUrl } = useRuntimeConfig().public;
    const theme = useState("theme");
    const linkBoxStatus = ref({});
    const hasAnyStore = computed(() => {
      return themeSetting.value["footer"].appStores && Object.values(themeSetting.value["footer"].appStores).some((value) => typeof value === "string" && value.trim() != "");
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ThemeFooterSupport = _sfc_main$8;
      const _component_ThemeSupportItems = _sfc_main$7;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_nuxt_link = __nuxt_component_0$2;
      const _component_ThemeFooterSocialNetworks = _sfc_main$6;
      const _component_ThemeFooterNewsletterForm = _sfc_main$5;
      const _component_ThemeWidgetsMoreText = _sfc_main$m;
      const _component_NuxtImg = _sfc_main$l;
      if (unref(themeSetting) && unref(themeSetting)["footer"] && unref(shopSetting)) {
        _push(`<div${ssrRenderAttrs(mergeProps({
          class: ["border-t py-3 px-2 md:px-5", [unref(themeSetting)["footer"].className]]
        }, _attrs))}>`);
        _push(ssrRenderComponent(_component_ThemeFooterSupport, null, null, _parent));
        if (unref(theme) == "desktop") {
          _push(ssrRenderComponent(_component_ThemeSupportItems, null, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="lg:flex py-5">`);
        if (unref(themeSetting)["footer"].linkGroups) {
          _push(`<!--[-->`);
          ssrRenderList(unref(themeSetting)["footer"].linkGroups, (group, index) => {
            _push(`<div class="w-full"><p class="py-2 border-b flex justify-between items-center lg:border-none lg:py-0"><span class="headline">${ssrInterpolate(group.title)}</span>`);
            if (unref(theme) != "desktop") {
              _push(ssrRenderComponent(_component_fa_icon, {
                icon: [
                  "fas",
                  unref(linkBoxStatus)[index] ? "angle-up" : "angle-down"
                ]
              }, null, _parent));
            } else {
              _push(`<!---->`);
            }
            _push(`</p>`);
            if (unref(linkBoxStatus)[index] || unref(theme) == "desktop") {
              _push(`<ul><!--[-->`);
              ssrRenderList(group.links, (link) => {
                _push(`<!--[-->`);
                if (link.link) {
                  _push(`<li class="text-gray-500 py-2 text-sm">`);
                  if (link.link.toString().indexOf("https") == -1) {
                    _push(ssrRenderComponent(_component_nuxt_link, {
                      to: link.link
                    }, {
                      default: withCtx((_, _push2, _parent2, _scopeId) => {
                        if (_push2) {
                          _push2(`${ssrInterpolate(link.title)}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(link.title), 1)
                          ];
                        }
                      }),
                      _: 2
                    }, _parent));
                  } else {
                    _push(`<a${ssrRenderAttr("href", link.link)} target="_blank">${ssrInterpolate(link.title)}</a>`);
                  }
                  _push(`</li>`);
                } else {
                  _push(`<!---->`);
                }
                _push(`<!--]-->`);
              });
              _push(`<!--]--></ul>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</div>`);
          });
          _push(`<!--]-->`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="w-full"><p class="headline">\u0647\u0645\u0631\u0627\u0647 \u0645\u0627 \u0628\u0627\u0634\u06CC\u062F!</p>`);
        _push(ssrRenderComponent(_component_ThemeFooterSocialNetworks, null, null, _parent));
        _push(ssrRenderComponent(_component_ThemeFooterNewsletterForm, null, null, _parent));
        _push(`</div></div>`);
        if (unref(theme) == "desktop" && unref(hasAnyStore)) {
          _push(`<div class="w-full footer-app-links"><div class="font-bold"> \u062F\u0627\u0646\u0644\u0648\u062F \u0627\u067E\u0644\u06CC\u06A9\u06CC\u0634\u0646 ${ssrInterpolate(unref(shopSetting).name)}</div><div class="flex items-center">`);
          if (unref(themeSetting)["footer"].appStores["googlePlay"]) {
            _push(`<a class="mx-2" target="_blank"${ssrRenderAttr("href", unref(themeSetting)["footer"].appStores["googlePlay"])}><img alt="google-play"${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/images/google-play.svg")}></a>`);
          } else {
            _push(`<!---->`);
          }
          if (unref(themeSetting)["footer"].appStores["cafebazaar"]) {
            _push(`<a class="mx-2"${ssrRenderAttr("href", unref(themeSetting)["footer"].appStores["cafebazaar"])} target="_blank"><img alt="coffe-bazzar"${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/images/coffe-bazzar.svg")}></a>`);
          } else {
            _push(`<!---->`);
          }
          if (unref(themeSetting)["footer"].appStores["myket"]) {
            _push(`<a class="mx-2"${ssrRenderAttr("href", unref(themeSetting)["footer"].appStores["myket"])} target="_blank"><img alt="myket"${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/images/myket.svg")}></a>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<a class="mx-2 more" href="" target="_blank"><img alt="more"${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.appUrl + "/images/more.svg")}></a></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="lg:flex items-start"><div class="w-full flex-grow">`);
        if (unref(themeSetting)["footer"].introduction) {
          _push(ssrRenderComponent(_component_ThemeWidgetsMoreText, {
            text: unref(themeSetting)["footer"].introduction,
            length: 400
          }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
        if (unref(themeSetting)["footer"].licenses) {
          _push(`<div class="flex flex-row"><!--[-->`);
          ssrRenderList(unref(themeSetting)["footer"].licenses, (licenses, key) => {
            _push(`<div class="license-pic"><a${ssrRenderAttr("href", licenses.link)} target="_blank">`);
            _push(ssrRenderComponent(_component_NuxtImg, {
              src: unref(serverUrl) + "/" + licenses.image,
              class: "w-full h-auto rounded-xl",
              format: "webp",
              width: 100,
              height: 100,
              fit: "inside",
              loading: "lazy",
              alt: "license"
            }, null, _parent));
            _push(`</a></div>`);
          });
          _push(`<!--]--></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
        if (unref(themeSetting)["footer"].copyright) {
          _push(`<p class="border-t pt-5 pb-3 text-center">${ssrInterpolate(unref(themeSetting)["footer"].copyright)}</p>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/footer/View.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "Scaffold",
  __ssrInlineRender: true,
  props: {
    hideNavigation: { type: Boolean },
    hideAppBar: { type: Boolean }
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      var _a;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "scaffold" }, _attrs))}>`);
      if (!_ctx.hideAppBar) {
        _push(`<div class="${ssrRenderClass([[(_a = ("useRoute" in _ctx ? _ctx.useRoute : unref(useRoute))().meta["appBarClassName"]) != null ? _a : ""], "appbar w-full"])}">`);
        ssrRenderSlot(_ctx.$slots, "appbar", { class: "appbar w-full" }, null, _push, _parent);
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="body page-content">`);
      ssrRenderSlot(_ctx.$slots, "body", {}, null, _push, _parent);
      _push(`</div>`);
      if (!_ctx.hideNavigation) {
        _push(`<div class="bottom-navigation">`);
        ssrRenderSlot(_ctx.$slots, "bottom-navigation", {}, null, _push, _parent);
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/Scaffold.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "AppBar",
  __ssrInlineRender: true,
  setup(__props) {
    const route = useRoute();
    useRouter();
    const appBarContents = useNuxtApp().vueApp.config.globalProperties["$appbar-content"];
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_ThemeFastSearchInput = _sfc_main$f;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "w-full flex flex-col h-auto" }, _attrs))}><div class="flex items-center justify-between h-[65px]"><div class="${ssrRenderClass([{ "w-full": !unref(route).meta["appBarTrailing"] }, "flex items-center"])}">`);
      if (unref(route).path != "/") {
        _push(`<button>`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fas", "arrow-right"],
          class: "pl-3 cursor-pointer"
        }, null, _parent));
        _push(`</button>`);
      } else {
        _push(`<!---->`);
      }
      if (!unref(route).meta["appBarTitle"]) {
        _push(ssrRenderComponent(_component_ThemeFastSearchInput, { class: "w-full" }, null, _parent));
      } else {
        _push(`<span class="title">${ssrInterpolate(unref(route).meta["appBarTitle"])}</span>`);
      }
      _push(`</div>`);
      if (unref(route).meta["appBarTrailing"]) {
        ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(route).meta["appBarTrailing"]), null, null), _parent);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
      if (unref(appBarContents)) {
        _push(`<!--[-->`);
        ssrRenderList(unref(appBarContents), (component, key) => {
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(component), { key }, null), _parent);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/mobile/AppBar.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = {
  __name: "BottomNavigationBar",
  __ssrInlineRender: true,
  setup(__props) {
    const route = useRoute();
    const items = [
      {
        title: "\u0635\u0641\u062D\u0647 \u0627\u0635\u0644\u06CC",
        icon: ["fas", "home"],
        route: "/"
      },
      {
        title: "\u062F\u0633\u062A\u0647 \u0628\u0646\u062F\u06CC \u0647\u0627",
        icon: ["fas", "sitemap"],
        route: "/categories"
      },
      {
        title: "\u0633\u0628\u062F \u062E\u0631\u06CC\u062F",
        component: _sfc_main$p,
        route: "/cart"
      },
      {
        title: "\u062D\u0633\u0627\u0628 \u06A9\u0627\u0631\u0628\u0631\u06CC",
        icon: ["fas", "user"],
        route: "/profile"
      }
    ];
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0$2;
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex justify-between items-center px-5 bottom-navigation-bar" }, _attrs))}><!--[-->`);
      ssrRenderList(items, (item, key) => {
        _push(ssrRenderComponent(_component_nuxt_link, {
          key,
          to: item.route,
          class: [{ "active": unref(route).path === item.route }, "flex flex-col"]
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (item.icon !== void 0) {
                _push2(ssrRenderComponent(_component_fa_icon, {
                  icon: item.icon
                }, null, _parent2, _scopeId));
              } else {
                ssrRenderVNode(_push2, createVNode(resolveDynamicComponent(item.component), null, null), _parent2, _scopeId);
              }
              _push2(`<span class="text-[11px] pt-1.5"${_scopeId}>${ssrInterpolate(item.title)}</span>`);
            } else {
              return [
                item.icon !== void 0 ? (openBlock(), createBlock(_component_fa_icon, {
                  key: 0,
                  icon: item.icon
                }, null, 8, ["icon"])) : (openBlock(), createBlock(resolveDynamicComponent(item.component), { key: 1 })),
                createVNode("span", { class: "text-[11px] pt-1.5" }, toDisplayString(item.title), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
      });
      _push(`<!--]--></div>`);
    };
  }
};
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/mobile/BottomNavigationBar.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "default",
  __ssrInlineRender: true,
  async setup(__props) {
    var _a;
    let __temp, __restore;
    const shopSetting = useState("shopSetting");
    useHead({
      title: "\u0641\u0631\u0648\u0634\u06AF\u0627\u0647 \u0627\u06CC\u0646\u062A\u0631\u0646\u062A\u06CC " + ((_a = shopSetting.value) == null ? void 0 : _a.name),
      meta: [{
        name: "description",
        content: ""
      }]
    });
    const theme = useState("theme");
    ref(800);
    const global = useNuxtApp().vueApp.config.globalProperties;
    const mainComponent = global["$app:main-content"];
    const route = useRoute();
    const { data: categories } = ([__temp, __restore] = withAsyncContext(() => useAsyncData(
      "categories",
      () => $fetch("/api/category")
    )), __temp = await __temp, __restore(), __temp);
    if (categories) {
      useState("categories", () => categories);
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ThemeDesktopHeader = _sfc_main$9;
      const _component_ThemeFooterView = _sfc_main$4;
      const _component_Scaffold = _sfc_main$3;
      const _component_ThemeMobileAppBar = _sfc_main$2;
      const _component_ThemeMobileBottomNavigationBar = _sfc_main$1;
      _push(`<!--[--><div class="${ssrRenderClass(unref(theme))}">`);
      if (unref(theme) == "desktop") {
        _push(`<div class="page-content h-screen flex flex-col overflow-auto">`);
        if (!unref(route).meta["hideHeader"]) {
          _push(ssrRenderComponent(_component_ThemeDesktopHeader, null, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="page-content relative w-full max-w-[1660px] mx-auto">`);
        ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
        if (!unref(route).meta["hideFooter"]) {
          _push(ssrRenderComponent(_component_ThemeFooterView, null, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="bg-cover inset-0 z-20 bg-black/40 fixed hidden"></div></div></div>`);
      } else {
        _push(ssrRenderComponent(_component_Scaffold, { class: "h-svh" }, {
          appbar: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (unref(route).meta["appBarComponent"]) {
                ssrRenderVNode(_push2, createVNode(resolveDynamicComponent(unref(route).meta["appBarComponent"]), null, null), _parent2, _scopeId);
              } else {
                _push2(ssrRenderComponent(_component_ThemeMobileAppBar, null, null, _parent2, _scopeId));
              }
            } else {
              return [
                unref(route).meta["appBarComponent"] ? (openBlock(), createBlock(resolveDynamicComponent(unref(route).meta["appBarComponent"]), { key: 0 })) : (openBlock(), createBlock(_component_ThemeMobileAppBar, { key: 1 }))
              ];
            }
          }),
          body: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              ssrRenderSlot(_ctx.$slots, "default", {}, null, _push2, _parent2, _scopeId);
              if (("useRoute" in _ctx ? _ctx.useRoute : unref(useRoute))().path == "/") {
                _push2(ssrRenderComponent(_component_ThemeFooterView, null, null, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
            } else {
              return [
                renderSlot(_ctx.$slots, "default"),
                ("useRoute" in _ctx ? _ctx.useRoute : unref(useRoute))().path == "/" ? (openBlock(), createBlock(_component_ThemeFooterView, { key: 0 })) : createCommentVNode("", true)
              ];
            }
          }),
          "bottom-navigation": withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (!("useRoute" in _ctx ? _ctx.useRoute : unref(useRoute))().meta["bottomNavigation"]) {
                _push2(ssrRenderComponent(_component_ThemeMobileBottomNavigationBar, null, null, _parent2, _scopeId));
              } else {
                ssrRenderVNode(_push2, createVNode(resolveDynamicComponent(("useRoute" in _ctx ? _ctx.useRoute : unref(useRoute))().meta["bottomNavigation"]), null, null), _parent2, _scopeId);
              }
            } else {
              return [
                !("useRoute" in _ctx ? _ctx.useRoute : unref(useRoute))().meta["bottomNavigation"] ? (openBlock(), createBlock(_component_ThemeMobileBottomNavigationBar, { key: 0 })) : (openBlock(), createBlock(resolveDynamicComponent(("useRoute" in _ctx ? _ctx.useRoute : unref(useRoute))().meta["bottomNavigation"]), { key: 1 }))
              ];
            }
          }),
          _: 3
        }, _parent));
      }
      _push(`</div><!--[-->`);
      ssrRenderList(unref(mainComponent), (component) => {
        ssrRenderVNode(_push, createVNode(resolveDynamicComponent(component), null, null), _parent);
      });
      _push(`<!--]--><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layouts/default.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=default-cWV7T9Kg.mjs.map
