import { _ as _sfc_main$5 } from './Layout-tZUvOK2Y.mjs';
import { _ as _sfc_main$6 } from './Box-P2bb9SjA.mjs';
import { defineComponent, resolveComponent, withCtx, unref, createVNode, createBlock, createCommentVNode, openBlock, mergeProps, ref, resolveDynamicComponent, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrRenderAttrs, ssrRenderSlot, ssrRenderAttr, ssrRenderList, ssrRenderClass, ssrInterpolate, ssrRenderVNode } from 'vue/server-renderer';
import { a as addressStore, _ as _sfc_main$7 } from './CreateOrEdit-LLCfqsZZ.mjs';
import { u as useState, b as useRuntimeConfig, a as _sfc_main$o, _ as _sfc_main$i } from './server.mjs';
import { p as publicAssetsURL } from '../_/nitro.mjs';
import './TextInput-BtVMT3NE.mjs';
import '@vue-leaflet/vue-leaflet';
import 'pinia';
import './Component-C6QGchKb.mjs';
import './user-utils-B9JSuaai.mjs';
import './SelectTag-Cc2QTMT4.mjs';
import './input-CqSTwEhb.mjs';
import 'vue-router';
import 'highcharts';
import 'lodash';
import '@vue/shared';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';

const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  __name: "Detail",
  __ssrInlineRender: true,
  props: {
    data: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<ul${ssrRenderAttrs(mergeProps({ class: "text-gray-700 text-[15px] my-3 py-3" }, _attrs))}>`);
      if (_ctx.$getCityName(_ctx.data.city_id)) {
        _push(`<li class="p-1.5">`);
        _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "city"] }, null, _parent));
        _push(`<span class="px-1.5">${ssrInterpolate(_ctx.$getCityName(_ctx.data.city_id))}</span></li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.data.postalCode != null) {
        _push(`<li class="p-1.5">`);
        _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "envelope"] }, null, _parent));
        _push(`<span class="px-1.5">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.data.postalCode))}</span></li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.data.recipient_mobile_number) {
        _push(`<li class="p-1.5">`);
        _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "mobile-screen-button"] }, null, _parent));
        _push(`<span class="px-1.5">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.data.recipient_mobile_number))}</span></li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.data.recipient_name) {
        _push(`<li class="p-1.5">`);
        _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "user"] }, null, _parent));
        _push(`<span class="px-1.5">${ssrInterpolate(_ctx.data.recipient_name + " " + _ctx.data.recipient_last_name)}</span></li>`);
      } else {
        _push(`<!---->`);
      }
      ssrRenderSlot(_ctx.$slots, "items", { data: _ctx.data }, null, _push, _parent);
      _push(`</ul>`);
    };
  }
});
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/addresses/Detail.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "OptionsUl",
  __ssrInlineRender: true,
  props: {
    removeAddress: { type: Function },
    id: {}
  },
  setup(__props) {
    addressStore();
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<div${ssrRenderAttrs(_attrs)}><ul class="bg-white"><li class="py-3 px-4 cursor-pointer flex items-center hover:bg-gray-100">`);
      _push(ssrRenderComponent(_component_fa_icon, { icon: ["far", "pen-to-square"] }, null, _parent));
      _push(`<span class="px-3 text-sm">\u0648\u06CC\u0631\u0627\u06CC\u0634 \u0622\u062F\u0631\u0633</span></li><li class="py-3 px-4 cursor-pointer flex items-center hover:bg-gray-100">`);
      _push(ssrRenderComponent(_component_fa_icon, {
        icon: ["fas", "trash-can"],
        class: "!text-red-600"
      }, null, _parent));
      _push(`<span class="px-3 text-sm">\u062D\u0630\u0641 \u0622\u062F\u0631\u0633</span></li></ul></div>`);
    };
  }
});
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/addresses/OptionsUl.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "TableOptions",
  __ssrInlineRender: true,
  props: {
    id: {}
  },
  setup(__props) {
    const store = addressStore();
    ref(null);
    const offcanvasRef = ref(null);
    const removeRequestDialogRef = ref(null);
    const showOptions = ref(false);
    const theme = useState("theme");
    const removeAddress = () => {
      if (offcanvasRef.value) {
        offcanvasRef.value.hide();
      }
      removeRequestDialogRef.value.show();
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_AddressesOptionsUl = _sfc_main$3;
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      if (unref(theme) == "desktop") {
        _push(`<div class="relative">`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fas", "ellipsis-vertical"],
          class: "cursor-pointer",
          onClick: ($event) => showOptions.value = !unref(showOptions)
        }, null, _parent));
        if (unref(showOptions)) {
          _push(ssrRenderComponent(_component_AddressesOptionsUl, {
            class: "w-[250px] shadow-md rounded-lg border absolute left-0 top-0",
            removeAddress,
            id: _ctx.id
          }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<div>`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fas", "ellipsis-vertical"],
          class: "cursor-pointer",
          onClick: ($event) => unref(offcanvasRef).show()
        }, null, _parent));
        _push(ssrRenderComponent(_sfc_main$o, {
          direction: "bottom",
          "content-class": "bottom-0 w-full !h-auto",
          ref_key: "offcanvasRef",
          ref: offcanvasRef
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(_component_AddressesOptionsUl, {
                removeAddress,
                id: _ctx.id
              }, null, _parent2, _scopeId));
            } else {
              return [
                createVNode(_component_AddressesOptionsUl, {
                  removeAddress,
                  id: _ctx.id
                }, null, 8, ["id"])
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div>`);
      }
      ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(theme) == "desktop" ? _sfc_main$i : _sfc_main$o), {
        title: "\u062D\u0630\u0641 \u0622\u062F\u0631\u0633",
        ref_key: "removeRequestDialogRef",
        ref: removeRequestDialogRef,
        direction: "bottom",
        "content-class": "w-full !h-auto bottom-0"
      }, {
        footer: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="grid grid-cols-2 gap-2 border-t p-3"${_scopeId}><button class="c-btn"${_scopeId}> \u062D\u0630\u0641 \u0622\u062F\u0631\u0633 </button><button class="c-btn2"${_scopeId}> \u0627\u0646\u0635\u0631\u0627\u0641 </button></div>`);
          } else {
            return [
              createVNode("div", { class: "grid grid-cols-2 gap-2 border-t p-3" }, [
                createVNode("button", {
                  class: "c-btn",
                  onClick: ($event) => {
                    unref(removeRequestDialogRef).hide();
                    unref(store).removeAddress(_ctx.id);
                  }
                }, " \u062D\u0630\u0641 \u0622\u062F\u0631\u0633 ", 8, ["onClick"]),
                createVNode("button", {
                  class: "c-btn2",
                  onClick: ($event) => unref(removeRequestDialogRef).hide()
                }, " \u0627\u0646\u0635\u0631\u0627\u0641 ", 8, ["onClick"])
              ])
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="py-5 md:py-10 px-3"${_scopeId}> \u0622\u06CC\u0627 \u0627\u0632 \u062D\u0630\u0641 \u0627\u06CC\u0646 \u0622\u062F\u0631\u0633 \u0627\u0632 \u0644\u06CC\u0633\u062A \u0622\u062F\u0631\u0633\u200C\u0647\u0627 \u0627\u0637\u0645\u06CC\u0646\u0627\u0646 \u062F\u0627\u0631\u06CC\u062F\u061F </div>`);
          } else {
            return [
              createVNode("div", { class: "py-5 md:py-10 px-3" }, " \u0622\u06CC\u0627 \u0627\u0632 \u062D\u0630\u0641 \u0627\u06CC\u0646 \u0622\u062F\u0631\u0633 \u0627\u0632 \u0644\u06CC\u0633\u062A \u0622\u062F\u0631\u0633\u200C\u0647\u0627 \u0627\u0637\u0645\u06CC\u0646\u0627\u0646 \u062F\u0627\u0631\u06CC\u062F\u061F ")
            ];
          }
        }),
        _: 1
      }), _parent);
      _push(`</div>`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/addresses/TableOptions.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _imports_0 = publicAssetsURL("/images/address.svg");
const _imports_1 = publicAssetsURL("/images/emptyAddress.png");
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "Table",
  __ssrInlineRender: true,
  setup(__props) {
    const store = addressStore();
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_AddressesDetail = _sfc_main$4;
      const _component_AddressesTableOptions = _sfc_main$2;
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      if (unref(store).addresses.length === 0 && !unref(store).loading) {
        _push(`<div class="w-full flex flex-col items-center">`);
        ssrRenderSlot(_ctx.$slots, "empty", {}, null, _push, _parent);
        if (_ctx.$slots["empty"] == void 0) {
          _push(`<div class="flex flex-col items-center w-full"><img${ssrRenderAttr("src", _imports_0)} alt="address"><p> \u0647\u0646\u0648\u0632 \u0622\u062F\u0631\u0633 \u062B\u0628\u062A \u0646\u06A9\u0631\u062F\u0647 \u0627\u06CC\u062F. </p></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<button class="c-btn2 px-4 my-4">`);
        _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "location-dot"] }, null, _parent));
        _push(`<span class="px-3">\u062B\u0628\u062A \u0622\u062F\u0631\u0633 \u062C\u062F\u06CC\u062F</span></button></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="addresses max-md:px-3"><!--[-->`);
      ssrRenderList(unref(store).addresses, (row, key) => {
        _push(`<div class="${ssrRenderClass([{ "border-b": key != unref(store).addresses.length - 1 }, "flex justify-between py-5"])}"><div class="flex flex-col flex-grow w-full"><p class="text-black font-bold">${ssrInterpolate(row.address)}</p>`);
        _push(ssrRenderComponent(_component_AddressesDetail, { data: row }, null, _parent));
        _push(`</div><div class="flex flex-col items-end w-[150px]">`);
        _push(ssrRenderComponent(_component_AddressesTableOptions, {
          id: row.id
        }, null, _parent));
        if (row.staticmap == null) {
          _push(`<img${ssrRenderAttr("src", _imports_1)} class="w-full">`);
        } else {
          _push(`<img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/" + row.staticmap)} class="w-full">`);
        }
        _push(`</div></div>`);
      });
      _push(`<!--]--></div><button class="c-btn px-4 my-4 absolute left-5 bottom-16 lg:hidden">`);
      _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "location-dot"] }, null, _parent));
      _push(`<span class="px-3">\u062B\u0628\u062A \u0622\u062F\u0631\u0633 \u062C\u062F\u06CC\u062F</span></button></div>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/addresses/Table.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "addresses",
  __ssrInlineRender: true,
  setup(__props) {
    const addressState = addressStore();
    const theme = useState("theme");
    return (_ctx, _push, _parent, _attrs) => {
      const _component_UsersLayout = _sfc_main$5;
      const _component_UsersPanelBox = _sfc_main$6;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_AddressesTable = _sfc_main$1;
      const _component_AddressesCreateOrEdit = _sfc_main$7;
      _push(ssrRenderComponent(_component_UsersLayout, _attrs, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_UsersPanelBox, {
              title: unref(theme) == "desktop" ? "\u0622\u062F\u0631\u0633\u200C\u0647\u0627" : void 0,
              class: "address"
            }, {
              leading: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  if (unref(addressState).addresses.length > 0 && unref(theme) == "desktop") {
                    _push3(`<div${_scopeId2}><button class="c-btn2 px-4 my-3 text-sm"${_scopeId2}>`);
                    _push3(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "location-dot"] }, null, _parent3, _scopeId2));
                    _push3(`<span class="px-3"${_scopeId2}>\u062B\u0628\u062A \u0622\u062F\u0631\u0633 \u062C\u062F\u06CC\u062F</span></button></div>`);
                  } else {
                    _push3(`<!---->`);
                  }
                } else {
                  return [
                    unref(addressState).addresses.length > 0 && unref(theme) == "desktop" ? (openBlock(), createBlock("div", { key: 0 }, [
                      createVNode("button", {
                        class: "c-btn2 px-4 my-3 text-sm",
                        onClick: ($event) => unref(addressState).showCreateForm()
                      }, [
                        createVNode(_component_fa_icon, { icon: ["fas", "location-dot"] }),
                        createVNode("span", { class: "px-3" }, "\u062B\u0628\u062A \u0622\u062F\u0631\u0633 \u062C\u062F\u06CC\u062F")
                      ], 8, ["onClick"])
                    ])) : createCommentVNode("", true)
                  ];
                }
              }),
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(ssrRenderComponent(_component_AddressesTable, null, null, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_AddressesCreateOrEdit, null, null, _parent3, _scopeId2));
                } else {
                  return [
                    createVNode(_component_AddressesTable),
                    createVNode(_component_AddressesCreateOrEdit)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_UsersPanelBox, {
                title: unref(theme) == "desktop" ? "\u0622\u062F\u0631\u0633\u200C\u0647\u0627" : void 0,
                class: "address"
              }, {
                leading: withCtx(() => [
                  unref(addressState).addresses.length > 0 && unref(theme) == "desktop" ? (openBlock(), createBlock("div", { key: 0 }, [
                    createVNode("button", {
                      class: "c-btn2 px-4 my-3 text-sm",
                      onClick: ($event) => unref(addressState).showCreateForm()
                    }, [
                      createVNode(_component_fa_icon, { icon: ["fas", "location-dot"] }),
                      createVNode("span", { class: "px-3" }, "\u062B\u0628\u062A \u0622\u062F\u0631\u0633 \u062C\u062F\u06CC\u062F")
                    ], 8, ["onClick"])
                  ])) : createCommentVNode("", true)
                ]),
                default: withCtx(() => [
                  createVNode(_component_AddressesTable),
                  createVNode(_component_AddressesCreateOrEdit)
                ]),
                _: 1
              }, 8, ["title"])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/profile/addresses.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=addresses-MYqpZJfz.mjs.map
