import { c as useNuxtApp, m as useFetch, G as showError, b as useRuntimeConfig, u as useState, e as useRoute, p as productStore, g as __nuxt_component_0$2, D as _sfc_main$n$1, j as useRouter, d as _sfc_main$b$1, h as _sfc_main$k$1, F as _sfc_main$9$1, x as _sfc_main$h$1, a as _sfc_main$o$1, q as useRequestEvent, _ as _sfc_main$i$1, o as _sfc_main$c$1, E as _sfc_main$l$1, k as __nuxt_component_3$1 } from './server.mjs';
import { withAsyncContext, watch, mergeProps, unref, defineComponent, ref, resolveComponent, withCtx, createVNode, createBlock, createCommentVNode, toDisplayString, openBlock, resolveDynamicComponent, isRef, Fragment, renderList, computed, nextTick, mergeModels, useModel, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrInterpolate, ssrRenderClass, ssrRenderVNode, ssrRenderAttr, ssrRenderStyle } from 'vue/server-renderer';
import _sfc_main$n from './DisplayOfferLabel-NawhS09e.mjs';
import { _ as _sfc_main$o } from './NuxtImg-DBEieluz.mjs';
import { u as useSwiper } from './useSwiper.client-kor1rvL-.mjs';
import { g as galleryStore } from './gallery-hwUJSkhT.mjs';
import { _ as _sfc_main$p } from './Component-C6QGchKb.mjs';
import { _ as _sfc_main$q } from './TextInput-BtVMT3NE.mjs';
import { _ as _sfc_main$r } from './Items-CRlozw8Q.mjs';
import { s as specificationsStore } from './specifications-Vu5A47gN.mjs';
import { _ as _sfc_main$u } from './SelectTag-Cc2QTMT4.mjs';
import { _ as _sfc_main$s } from './SendDetail-CCtW5pOV.mjs';
import _sfc_main$l from './ProductSlider-bBkyMPQB.mjs';
import { _ as _sfc_main$t } from './Tabs-CzUlKuXU.mjs';
import { _ as __nuxt_component_3 } from './Skeleton-B5XQTW8R.mjs';
import { _ as _sfc_main$m } from './View-Sprhesqe.mjs';
import { d as destr, J as klona, K as getRequestHeader, L as isEqual, M as setCookie, N as getCookie, O as deleteCookie } from '../_/nitro.mjs';
import { u as useHead } from './v3-CqizLg04.mjs';
import 'pinia';
import 'vue-router';
import 'highcharts';
import 'lodash';
import '@vue/shared';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';
import './user-utils-B9JSuaai.mjs';
import './input-CqSTwEhb.mjs';
import './VerticalView-mV-jyVNN.mjs';
import './Score-BYZAscMc.mjs';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import 'unhead/plugins';

function parse(str, options) {
  if (typeof str !== "string") {
    throw new TypeError("argument str must be a string");
  }
  const obj = {};
  const opt = options || {};
  const dec = opt.decode || decode;
  let index = 0;
  while (index < str.length) {
    const eqIdx = str.indexOf("=", index);
    if (eqIdx === -1) {
      break;
    }
    let endIdx = str.indexOf(";", index);
    if (endIdx === -1) {
      endIdx = str.length;
    } else if (endIdx < eqIdx) {
      index = str.lastIndexOf(";", eqIdx - 1) + 1;
      continue;
    }
    const key = str.slice(index, eqIdx).trim();
    if (opt?.filter && !opt?.filter(key)) {
      index = endIdx + 1;
      continue;
    }
    if (void 0 === obj[key]) {
      let val = str.slice(eqIdx + 1, endIdx).trim();
      if (val.codePointAt(0) === 34) {
        val = val.slice(1, -1);
      }
      obj[key] = tryDecode(val, dec);
    }
    index = endIdx + 1;
  }
  return obj;
}
function decode(str) {
  return str.includes("%") ? decodeURIComponent(str) : str;
}
function tryDecode(str, decode2) {
  try {
    return decode2(str);
  } catch {
    return str;
  }
}

const CookieDefaults = {
  path: "/",
  watch: true,
  decode: (val) => destr(decodeURIComponent(val)),
  encode: (val) => encodeURIComponent(typeof val === "string" ? val : JSON.stringify(val))
};
function useCookie(name, _opts) {
  var _a2, _b;
  var _a;
  const opts = { ...CookieDefaults, ..._opts };
  (_a2 = opts.filter) != null ? _a2 : opts.filter = (key) => key === name;
  const cookies = readRawCookies(opts) || {};
  let delay;
  if (opts.maxAge !== void 0) {
    delay = opts.maxAge * 1e3;
  } else if (opts.expires) {
    delay = opts.expires.getTime() - Date.now();
  }
  const hasExpired = delay !== void 0 && delay <= 0;
  const cookieValue = klona(hasExpired ? void 0 : (_b = cookies[name]) != null ? _b : (_a = opts.default) == null ? void 0 : _a.call(opts));
  const cookie = ref(cookieValue);
  {
    const nuxtApp = useNuxtApp();
    const writeFinalCookieValue = () => {
      if (opts.readonly || isEqual(cookie.value, cookies[name])) {
        return;
      }
      nuxtApp._cookies || (nuxtApp._cookies = {});
      if (name in nuxtApp._cookies) {
        if (isEqual(cookie.value, nuxtApp._cookies[name])) {
          return;
        }
      }
      nuxtApp._cookies[name] = cookie.value;
      writeServerCookie(useRequestEvent(nuxtApp), name, cookie.value, opts);
    };
    const unhook = nuxtApp.hooks.hookOnce("app:rendered", writeFinalCookieValue);
    nuxtApp.hooks.hookOnce("app:error", () => {
      unhook();
      return writeFinalCookieValue();
    });
  }
  return cookie;
}
function readRawCookies(opts = {}) {
  {
    return parse(getRequestHeader(useRequestEvent(), "cookie") || "", opts);
  }
}
function writeServerCookie(event, name, value, opts = {}) {
  if (event) {
    if (value !== null && value !== void 0) {
      return setCookie(event, name, value, opts);
    }
    if (getCookie(event, name) !== void 0) {
      return deleteCookie(event, name, opts);
    }
  }
}
const _sfc_main$k = /* @__PURE__ */ defineComponent({
  __name: "SelectBreadCrumbs",
  __ssrInlineRender: true,
  props: {
    category_id: {}
  },
  setup(__props) {
    const selectedCategories = ref([]);
    const categories = useState("categories");
    const props = __props;
    const createSelectedCategories = function() {
      if (props.category_id) {
        const category = categories.value.find((row) => row.id == props.category_id);
        if (category) {
          selectedCategories.value = [category];
        }
      }
    };
    watch(() => props.category_id, () => {
      createSelectedCategories();
    });
    watch(() => selectedCategories.value, () => {
      if (selectedCategories.value && selectedCategories.value[0]) {
        const category = categories.value.find(
          (row) => row.id == selectedCategories.value[0].parent_id
        );
        if (category) {
          selectedCategories.value.unshift(category);
        }
      }
    }, { deep: true });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0$2;
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "py-2 flex flex-wrap" }, _attrs))}><!--[-->`);
      ssrRenderList(unref(selectedCategories), (category, index) => {
        _push(ssrRenderComponent(_component_nuxt_link, {
          key: category.id,
          to: "/search/" + category.slug,
          class: { "px-3": index != 0 }
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span${_scopeId}>${ssrInterpolate(category.name)}</span>`);
              if (index != unref(selectedCategories).length - 1) {
                _push2(ssrRenderComponent(_component_fa_icon, {
                  icon: ["fas", "angle-left"],
                  class: "px-1.5"
                }, null, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
            } else {
              return [
                createVNode("span", null, toDisplayString(category.name), 1),
                index != unref(selectedCategories).length - 1 ? (openBlock(), createBlock(_component_fa_icon, {
                  key: 0,
                  icon: ["fas", "angle-left"],
                  class: "px-1.5"
                })) : createCommentVNode("", true)
              ];
            }
          }),
          _: 2
        }, _parent));
      });
      _push(`<!--]--></div>`);
    };
  }
});
const _sfc_setup$k = _sfc_main$k.setup;
_sfc_main$k.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/categories/SelectBreadCrumbs.vue");
  return _sfc_setup$k ? _sfc_setup$k(props, ctx) : void 0;
};
const _sfc_main$j = /* @__PURE__ */ defineComponent({
  __name: "SmallSlider",
  __ssrInlineRender: true,
  props: {
    product: {},
    changeMainSlider: { type: Function },
    slideIndex: {},
    commentsMedia: {}
  },
  setup(__props) {
    const swiperRef = ref(null);
    useSwiper(swiperRef);
    const props = __props;
    const { serverUrl } = useRuntimeConfig().public;
    const getCommentMediaSlideIndex = function(key, key2) {
      let totalCommentSlidesBefore = 0;
      for (let i = 0; i < key; i++) {
        totalCommentSlidesBefore += props.commentsMedia[i].files.length;
      }
      return props.product.gallery.length + props.product.videos.length + totalCommentSlidesBefore + key2;
    };
    watch(() => props.slideIndex, () => {
      var _a;
      (_a = swiperRef.value) == null ? void 0 : _a.swiper.slideTo(props.slideIndex);
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<swiper-container${ssrRenderAttrs(mergeProps({
        class: "small-swiper",
        "slides-per-view": "auto",
        "space-between": 10,
        ref_key: "swiperRef",
        ref: swiperRef
      }, _attrs), "swiper-container")}><!--[-->`);
      ssrRenderList(_ctx.product.gallery, (gallery, key) => {
        _push(`<swiper-slide class="${ssrRenderClass([{ "active": _ctx.slideIndex == key }, "item"])}"><img${ssrRenderAttr("src", unref(serverUrl) + "/" + gallery.path)} class="object-cover h-[80px] lg:h-[100px] rounded-md"></swiper-slide>`);
      });
      _push(`<!--]--><!--[-->`);
      ssrRenderList(_ctx.product.videos, (video, key) => {
        _push(`<swiper-slide class="${ssrRenderClass([{ "active": _ctx.slideIndex == _ctx.product.gallery.length + key }, "item"])}"><div class="flex items-center justify-center relative"><img${ssrRenderAttr("src", unref(serverUrl) + "/uploads/" + video.poster)} alt=""><div class="absolute z-10">`);
        _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "play"] }, null, _parent));
        _push(`</div></div></swiper-slide>`);
      });
      _push(`<!--]-->`);
      if (_ctx.commentsMedia && _ctx.commentsMedia.length > 0) {
        _push(`<swiper-slide class="item flex flex-col text-center items-center justify-center">`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fas", "user"],
          class: "text-xl"
        }, null, _parent));
        _push(`<span class="text-xs mt-2">\u062A\u0635\u0627\u0648\u06CC\u0631 \u06A9\u0627\u0631\u0628\u0631\u0627\u0646</span></swiper-slide>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.commentsMedia && _ctx.commentsMedia.length > 0) {
        _push(`<!--[-->`);
        ssrRenderList(_ctx.commentsMedia, (media, key) => {
          _push(`<!--[--><!--[-->`);
          ssrRenderList(media.files, (file, key2) => {
            _push(`<swiper-slide class="${ssrRenderClass([{ "active": _ctx.slideIndex == getCommentMediaSlideIndex(key, key2) }, "item"])}"><img${ssrRenderAttr("src", unref(serverUrl) + "/" + file.path)} class="object-cover h-[80px] rounded-md" alt=""></swiper-slide>`);
          });
          _push(`<!--]--><!--]-->`);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`</swiper-container>`);
    };
  }
});
const _sfc_setup$j = _sfc_main$j.setup;
_sfc_main$j.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/product-page/gallery/SmallSlider.vue");
  return _sfc_setup$j ? _sfc_setup$j(props, ctx) : void 0;
};
function useTabGallery() {
  const swiperRef = ref(null);
  const store = productStore();
  const gallery = galleryStore();
  const theme = useState("theme");
  const boxRef = ref(null);
  const show = () => {
    var _a;
    (_a = boxRef.value) == null ? void 0 : _a.show();
    nextTick(() => {
      var _a2;
      (_a2 = swiperRef.value) == null ? void 0 : _a2.swiper.on("slideChange", () => {
        const activeSlideIndex = swiperRef.value.swiper.activeIndex;
        const slide = swiperRef.value.swiper.slides[activeSlideIndex];
        gallery.onMainSlideChanged(
          slide,
          activeSlideIndex
        );
      });
    });
  };
  const changeMainSlider = (index) => {
    var _a;
    (_a = swiperRef.value) == null ? void 0 : _a.swiper.slideTo(index);
  };
  watch(() => store.activeMediaPath, () => {
    show();
    nextTick(() => {
      gallery.slideShowBasedActivePath(
        store.activeMediaPath
      );
    });
  });
  watch(() => gallery.slideIndex, () => {
    var _a;
    (_a = swiperRef.value) == null ? void 0 : _a.swiper.slideTo(gallery.slideIndex);
  });
  const injectStyles = [
    `.swiper-button-next,
  .swiper-button-prev {
      background-color: white;
      border-radius: 100% ;
      width:35px;
      height:35px;
      border:1px solid #dedede;
  }
  .swiper-button-next svg,
  .swiper-button-prev svg {
     width:20px;
     height:20px;
     color:black;
  }`
  ];
  return {
    show,
    changeMainSlider,
    swiperRef,
    theme,
    boxRef,
    gallery,
    store,
    injectStyles
  };
}
const _sfc_main$i = /* @__PURE__ */ defineComponent({
  __name: "TabSlider",
  __ssrInlineRender: true,
  setup(__props, { expose: __expose }) {
    const { serverUrl } = useRuntimeConfig().public;
    const {
      show,
      swiperRef,
      theme,
      boxRef,
      gallery,
      store,
      injectStyles,
      changeMainSlider
    } = useTabGallery();
    __expose({
      show
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_ProductPageGallerySmallSlider = _sfc_main$j;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "gallery-slider" }, _attrs))}>`);
      ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(theme) == "desktop" ? _sfc_main$i$1 : _sfc_main$o$1), {
        ref_key: "boxRef",
        ref: boxRef,
        class: "text-white"
      }, {
        header: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex justify-between items-center py-3 max-lg:px-4"${_scopeId}><div${_scopeId}></div><div${_scopeId}><ul class="flex border border-gray-600 rounded-lg"${_scopeId}><!--[-->`);
            ssrRenderList(unref(gallery).groups, (group, key) => {
              _push2(`<li class="${ssrRenderClass([{
                "border-r border-r-gray-600": key > 0
              }, "px-7 cursor-pointer"])}"${_scopeId}><span class="py-1.5 text-sm block"${_scopeId}>${ssrInterpolate(group.title)}</span>`);
              if (unref(gallery).activeGroup == group.key) {
                _push2(`<div class="h-1 w-[90%] bg-white rounded-t-md"${_scopeId}></div>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`</li>`);
            });
            _push2(`<!--]--></ul></div>`);
            _push2(ssrRenderComponent(_component_fa_icon, {
              icon: ["fas", "close"],
              onClick: ($event) => unref(boxRef).hide(),
              class: "text-xl cursor-pointer"
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "flex justify-between items-center py-3 max-lg:px-4" }, [
                createVNode("div"),
                createVNode("div", null, [
                  createVNode("ul", { class: "flex border border-gray-600 rounded-lg" }, [
                    (openBlock(true), createBlock(Fragment, null, renderList(unref(gallery).groups, (group, key) => {
                      return openBlock(), createBlock("li", {
                        key,
                        class: [{
                          "border-r border-r-gray-600": key > 0
                        }, "px-7 cursor-pointer"],
                        onClick: ($event) => unref(gallery).changeMediaType(group.key, unref(store).product)
                      }, [
                        createVNode("span", { class: "py-1.5 text-sm block" }, toDisplayString(group.title), 1),
                        unref(gallery).activeGroup == group.key ? (openBlock(), createBlock("div", {
                          key: 0,
                          class: "h-1 w-[90%] bg-white rounded-t-md"
                        })) : createCommentVNode("", true)
                      ], 10, ["onClick"]);
                    }), 128))
                  ])
                ]),
                createVNode(_component_fa_icon, {
                  icon: ["fas", "close"],
                  onClick: ($event) => unref(boxRef).hide(),
                  class: "text-xl cursor-pointer"
                }, null, 8, ["onClick"])
              ])
            ];
          }
        }),
        footer: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="h-[100px] lg:h-[120px] py-[5px] px-4"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_ProductPageGallerySmallSlider, {
              product: unref(store).product,
              changeMainSlider: unref(changeMainSlider),
              slideIndex: unref(gallery).slideIndex,
              commentsMedia: unref(gallery).commentsMedia
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "h-[100px] lg:h-[120px] py-[5px] px-4" }, [
                createVNode(_component_ProductPageGallerySmallSlider, {
                  product: unref(store).product,
                  changeMainSlider: unref(changeMainSlider),
                  slideIndex: unref(gallery).slideIndex,
                  commentsMedia: unref(gallery).commentsMedia
                }, null, 8, ["product", "changeMainSlider", "slideIndex", "commentsMedia"])
              ])
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="relative lg:flex lg:items-center gallery-container"${_scopeId}><swiper-container class="w-full lg:w-1/2"${ssrRenderAttr("navigation", true)}${ssrRenderAttr("injectStyles", unref(injectStyles))}${_scopeId}><!--[-->`);
            ssrRenderList(unref(gallery).files, (file, key) => {
              _push2(`<swiper-slide${ssrRenderAttr("data-tag", file.group)} class="h-full flex items-center"${ssrRenderAttr("data-index", file.dataIndex)}${_scopeId}>`);
              if (file.path.toString().indexOf(".mp4") == -1) {
                _push2(`<img${ssrRenderAttr("src", unref(serverUrl) + "/" + file.path)} class="object-contain"${ssrRenderAttr("alt", unref(store).product.title)}${_scopeId}>`);
              } else {
                _push2(`<video${ssrRenderAttr("src", unref(serverUrl) + "/" + file.path)} controls${_scopeId}></video>`);
              }
              _push2(`</swiper-slide>`);
            });
            _push2(`<!--]--></swiper-container>`);
            if (unref(gallery).selectedComment) {
              _push2(`<div class="user-description-box"${_scopeId}><div class="flex justify-between py-2 lg:py-5"${_scopeId}><span${_scopeId}>${ssrInterpolate(unref(gallery).selectedComment.user)}</span><div${_scopeId}><!--[-->`);
              ssrRenderList(5, (i) => {
                _push2(ssrRenderComponent(_component_fa_icon, {
                  key: i,
                  icon: ["fas", "star"],
                  class: { "text-yellow-500": unref(gallery).selectedComment.score >= i }
                }, null, _parent2, _scopeId));
              });
              _push2(`<!--]--></div></div><div class="comment-body"${_scopeId}>${ssrInterpolate(unref(gallery).selectedComment.body)}</div></div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "relative lg:flex lg:items-center gallery-container" }, [
                createVNode("swiper-container", {
                  class: "w-full lg:w-1/2",
                  navigation: true,
                  injectStyles: unref(injectStyles),
                  ref_key: "swiperRef",
                  ref: swiperRef
                }, [
                  (openBlock(true), createBlock(Fragment, null, renderList(unref(gallery).files, (file, key) => {
                    return openBlock(), createBlock("swiper-slide", {
                      key,
                      "data-tag": file.group,
                      class: "h-full flex items-center",
                      "data-index": file.dataIndex
                    }, [
                      file.path.toString().indexOf(".mp4") == -1 ? (openBlock(), createBlock("img", {
                        key: 0,
                        src: unref(serverUrl) + "/" + file.path,
                        class: "object-contain",
                        alt: unref(store).product.title
                      }, null, 8, ["src", "alt"])) : (openBlock(), createBlock("video", {
                        key: 1,
                        src: unref(serverUrl) + "/" + file.path,
                        controls: ""
                      }, null, 8, ["src"]))
                    ], 8, ["data-tag", "data-index"]);
                  }), 128))
                ], 8, ["injectStyles"]),
                unref(gallery).selectedComment ? (openBlock(), createBlock("div", {
                  key: 0,
                  class: "user-description-box"
                }, [
                  createVNode("div", { class: "flex justify-between py-2 lg:py-5" }, [
                    createVNode("span", null, toDisplayString(unref(gallery).selectedComment.user), 1),
                    createVNode("div", null, [
                      (openBlock(), createBlock(Fragment, null, renderList(5, (i) => {
                        return createVNode(_component_fa_icon, {
                          key: i,
                          icon: ["fas", "star"],
                          class: { "text-yellow-500": unref(gallery).selectedComment.score >= i }
                        }, null, 8, ["class"]);
                      }), 64))
                    ])
                  ]),
                  createVNode("div", { class: "comment-body" }, toDisplayString(unref(gallery).selectedComment.body), 1)
                ])) : createCommentVNode("", true)
              ])
            ];
          }
        }),
        _: 1
      }), _parent);
      _push(`</div>`);
    };
  }
});
const _sfc_setup$i = _sfc_main$i.setup;
_sfc_main$i.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/product-page/gallery/TabSlider.vue");
  return _sfc_setup$i ? _sfc_setup$i(props, ctx) : void 0;
};
const _sfc_main$h = /* @__PURE__ */ defineComponent({
  __name: "Desktop",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    const tabSlider = ref(null);
    galleryStore();
    const { serverUrl } = useRuntimeConfig().public;
    return (_ctx, _push, _parent, _attrs) => {
      const _component_PromotionsDisplayOfferLabel = _sfc_main$n;
      const _component_ProductPageOptions = _sfc_main$n$1;
      const _component_NuxtImg = _sfc_main$o;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_ProductPageGalleryTabSlider = _sfc_main$i;
      _push(`<!--[--><div class="gallery"><div class="w-full">`);
      _push(ssrRenderComponent(_component_PromotionsDisplayOfferLabel, { product: _ctx.product }, null, _parent));
      _push(`</div>`);
      _push(ssrRenderComponent(_component_ProductPageOptions, {
        product: _ctx.product,
        showOn: "desktop"
      }, null, _parent));
      _push(ssrRenderComponent(_component_NuxtImg, {
        src: unref(serverUrl) + "/gallery/" + _ctx.product.image,
        class: "md:w-[300px] lg:w-[90%] mx-auto my-4",
        format: "webp",
        height: 400,
        width: 400,
        onClick: ($event) => {
          var _a;
          return (_a = unref(tabSlider)) == null ? void 0 : _a.show();
        },
        alt: ""
      }, null, _parent));
      _push(`<div class="flex">`);
      if (_ctx.product.videos && _ctx.product.videos.length > 0 && _ctx.product.gallery[0]) {
        _push(`<div class="w-[75px] h-[75px] m-2 border rounded-md p-2 relative cursor-pointer"><div class="filter flex items-center justify-center">`);
        _push(ssrRenderComponent(_component_NuxtImg, {
          src: unref(serverUrl) + "/" + _ctx.product.gallery[0].path,
          class: "w-full object-contain",
          format: "webp",
          height: 75,
          alt: ""
        }, null, _parent));
        _push(`</div><div class="cover">`);
        _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "play"] }, null, _parent));
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<!--[-->`);
      ssrRenderList(_ctx.product.gallery, (gallery2, key) => {
        _push(`<!--[-->`);
        if (key < 5 && key > 0) {
          _push(`<div class="w-[75px] h-[75px] m-2 border rounded-md p-2 relative cursor-pointer"><div class="${ssrRenderClass({ "filter": key == 4 })}">`);
          _push(ssrRenderComponent(_component_NuxtImg, {
            src: unref(serverUrl) + "/" + gallery2.path,
            class: "w-full object-contain",
            format: "webp",
            height: 75,
            alt: ""
          }, null, _parent));
          _push(`</div>`);
          if (key == 4) {
            _push(`<div class="cover">`);
            _push(ssrRenderComponent(_component_fa_icon, {
              icon: ["fas", "ellipsis-h"],
              class: "text-xl"
            }, null, _parent));
            _push(`</div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      });
      _push(`<!--]--></div></div>`);
      _push(ssrRenderComponent(_component_ProductPageGalleryTabSlider, {
        ref_key: "tabSlider",
        ref: tabSlider
      }, null, _parent));
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup$h = _sfc_main$h.setup;
_sfc_main$h.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/product-page/gallery/Desktop.vue");
  return _sfc_setup$h ? _sfc_setup$h(props, ctx) : void 0;
};
const useReportWrongForm = () => {
  const successMessage = ref(null);
  const description = ref(null);
  const selectedItems = ref({});
  const formBox = ref(null);
  const productState = productStore();
  const theme = useState("theme");
  const shopSetting = useState("shopSetting");
  const items = {
    title: "\u0646\u0627\u0645 \u06A9\u0627\u0644\u0627 \u0646\u0627\u062F\u0631\u0633\u062A \u0627\u0633\u062A",
    image: "\u062A\u0635\u0648\u06CC\u0631 \u06A9\u0627\u0644\u0627 \u0646\u0627\u062F\u0631\u0633\u062A \u0627\u0633\u062A",
    description: "\u062A\u0648\u0636\u06CC\u062D\u0627\u062A \u06A9\u0627\u0644\u0627 \u0646\u0627\u062F\u0631\u0633\u062A \u0627\u0633\u062A",
    fake: "\u06A9\u0627\u0644\u0627\u06CC \u063A\u06CC\u0631 \u0627\u0635\u0644",
    specifications: "\u0645\u0634\u062E\u0635\u0627\u062A \u06A9\u0627\u0644\u0627 \u0646\u0627\u062F\u0631\u0633\u062A \u0627\u0633\u062A",
    repetitious: "\u06A9\u0627\u0644\u0627\u06CC \u062A\u06A9\u0631\u0627\u0631\u06CC"
  };
  const completionData = (data) => {
    data["items"] = Object.keys(selectedItems.value).toString();
    return data;
  };
  const result = () => {
    description.value = "";
    selectedItems.value = {};
    successMessage.value = "\u062B\u0628\u062A \u06AF\u0632\u0627\u0631\u0634 \u0628\u0627 \u0645\u0648\u0641\u0642\u06CC\u062A \u0627\u0646\u062C\u0627\u0645 \u0634\u062F";
    setTimeout(() => {
      successMessage.value = null;
    }, 3e3);
  };
  return {
    completionData,
    successMessage,
    description,
    selectedItems,
    formBox,
    productState,
    theme,
    shopSetting,
    items,
    result,
    Modal: _sfc_main$i$1,
    Offcanvas: _sfc_main$o$1
  };
};
const _sfc_main$g = /* @__PURE__ */ defineComponent({
  __name: "Form",
  __ssrInlineRender: true,
  setup(__props) {
    useRouter();
    useState("user");
    const form = ref(null);
    const {
      formBox,
      successMessage,
      productState,
      theme,
      shopSetting,
      selectedItems,
      items,
      description,
      Modal,
      Offcanvas,
      result,
      completionData
    } = useReportWrongForm();
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c, _d;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_FormComponent = _sfc_main$p;
      const _component_FormCheckBox = _sfc_main$b$1;
      const _component_FormTextInput = _sfc_main$q;
      const _component_Loading = _sfc_main$k$1;
      _push(`<!--[-->`);
      if (unref(productState).product) {
        _push(`<div class="text-sm text-gray-500 flex justify-between cursor-pointer pt-5 max-lg:border-t max-lg:mt-3"><div>`);
        _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "square-xmark"] }, null, _parent));
        _push(`<span class="pr-1">\u06AF\u0632\u0627\u0631\u0634 \u0645\u0634\u062E\u0635\u0627\u062A \u06A9\u0627\u0644\u0627 \u06CC\u0627 \u0645\u0648\u0627\u0631\u062F \u0642\u0627\u0646\u0648\u0646\u06CC</span></div><span class="max-lg:hidden">${ssrInterpolate((_a = unref(shopSetting).sku_code) == null ? void 0 : _a.toString().toUpperCase())}-${ssrInterpolate(unref(productState).product.id)}</span>`);
        _push(ssrRenderComponent(_component_fa_icon, {
          class: "lg:hidden",
          icon: ["fas", "angle-left"]
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(theme) == "desktop" ? unref(Modal) : unref(Offcanvas)), {
        ref_key: "formBox",
        ref: formBox,
        title: "\u06AF\u0632\u0627\u0631\u0634 \u0646\u0627\u062F\u0631\u0633\u062A\u06CC \u0645\u0634\u062E\u0635\u0627\u062A",
        "sub-title": ((_b = unref(productState).product) == null ? void 0 : _b.title.length) > 50 ? ((_c = unref(productState).product) == null ? void 0 : _c.title.substring(0, 50)) + "..." : (_d = unref(productState).product) == null ? void 0 : _d.title,
        "content-class": "w-full h-full bottom-0",
        direction: "bottom"
      }, {
        footer: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2;
          if (_push2) {
            _push2(`<div class="px-3 py-2 border-t"${_scopeId}><button class="${ssrRenderClass([[
              unref(description) && unref(description).length > 2 || Object.values(unref(selectedItems)).includes(true) ? "btn-danger" : "btn-secondary"
            ], "btn"])}"${_scopeId}>`);
            if ((_a2 = unref(form)) == null ? void 0 : _a2.loading) {
              _push2(ssrRenderComponent(_component_Loading, null, null, _parent2, _scopeId));
            } else {
              _push2(`<span${_scopeId}>\u0627\u0631\u0633\u0627\u0644</span>`);
            }
            _push2(`</button></div>`);
          } else {
            return [
              createVNode("div", { class: "px-3 py-2 border-t" }, [
                createVNode("button", {
                  class: ["btn", [
                    unref(description) && unref(description).length > 2 || Object.values(unref(selectedItems)).includes(true) ? "btn-danger" : "btn-secondary"
                  ]],
                  onClick: ($event) => {
                    var _a3;
                    return unref(description) && unref(description).length > 2 || Object.values(unref(selectedItems)).includes(true) ? (_a3 = unref(form)) == null ? void 0 : _a3.sendForm() : null;
                  }
                }, [
                  ((_b2 = unref(form)) == null ? void 0 : _b2.loading) ? (openBlock(), createBlock(_component_Loading, { key: 0 })) : (openBlock(), createBlock("span", { key: 1 }, "\u0627\u0631\u0633\u0627\u0644"))
                ], 10, ["onClick"])
              ])
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (unref(successMessage)) {
              _push2(`<div class="alert alert-success"${_scopeId}>${ssrInterpolate(unref(successMessage))}</div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(ssrRenderComponent(_component_FormComponent, {
              "request-url": "report/wrong-product",
              result: unref(result),
              ref_key: "form",
              ref: form,
              "completion-data": unref(completionData)
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                var _a2, _b2;
                if (_push3) {
                  _push3(`<input name="product_id"${ssrRenderAttr("value", (_a2 = unref(productState).product) == null ? void 0 : _a2.id)} class="c-input" type="hidden"${_scopeId2}><ul class="text-sm text-gray-600"${_scopeId2}><!--[-->`);
                  ssrRenderList(unref(items), (item, key) => {
                    _push3(`<li class="base-space"${_scopeId2}>`);
                    _push3(ssrRenderComponent(_component_FormCheckBox, {
                      label: item,
                      modelValue: unref(selectedItems)[key],
                      "onUpdate:modelValue": ($event) => unref(selectedItems)[key] = $event
                    }, null, _parent3, _scopeId2));
                    _push3(`</li>`);
                  });
                  _push3(`<!--]--></ul>`);
                  _push3(ssrRenderComponent(_component_FormTextInput, {
                    type: "textarea",
                    name: "description",
                    label: "\u062A\u0648\u0636\u06CC\u062D\u0627\u062A",
                    "hide-label": "",
                    placeholder: "\u062A\u0648\u0636\u06CC\u062D\u0627\u062A",
                    modelValue: unref(description),
                    "onUpdate:modelValue": ($event) => isRef(description) ? description.value = $event : null
                  }, null, _parent3, _scopeId2));
                } else {
                  return [
                    createVNode("input", {
                      name: "product_id",
                      value: (_b2 = unref(productState).product) == null ? void 0 : _b2.id,
                      class: "c-input",
                      type: "hidden"
                    }, null, 8, ["value"]),
                    createVNode("ul", { class: "text-sm text-gray-600" }, [
                      (openBlock(true), createBlock(Fragment, null, renderList(unref(items), (item, key) => {
                        return openBlock(), createBlock("li", {
                          class: "base-space",
                          key
                        }, [
                          createVNode(_component_FormCheckBox, {
                            label: item,
                            modelValue: unref(selectedItems)[key],
                            "onUpdate:modelValue": ($event) => unref(selectedItems)[key] = $event
                          }, null, 8, ["label", "modelValue", "onUpdate:modelValue"])
                        ]);
                      }), 128))
                    ]),
                    createVNode(_component_FormTextInput, {
                      type: "textarea",
                      name: "description",
                      label: "\u062A\u0648\u0636\u06CC\u062D\u0627\u062A",
                      "hide-label": "",
                      placeholder: "\u062A\u0648\u0636\u06CC\u062D\u0627\u062A",
                      modelValue: unref(description),
                      "onUpdate:modelValue": ($event) => isRef(description) ? description.value = $event : null
                    }, null, 8, ["modelValue", "onUpdate:modelValue"])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              unref(successMessage) ? (openBlock(), createBlock("div", {
                key: 0,
                class: "alert alert-success"
              }, toDisplayString(unref(successMessage)), 1)) : createCommentVNode("", true),
              createVNode(_component_FormComponent, {
                "request-url": "report/wrong-product",
                result: unref(result),
                ref_key: "form",
                ref: form,
                "completion-data": unref(completionData)
              }, {
                default: withCtx(() => {
                  var _a2;
                  return [
                    createVNode("input", {
                      name: "product_id",
                      value: (_a2 = unref(productState).product) == null ? void 0 : _a2.id,
                      class: "c-input",
                      type: "hidden"
                    }, null, 8, ["value"]),
                    createVNode("ul", { class: "text-sm text-gray-600" }, [
                      (openBlock(true), createBlock(Fragment, null, renderList(unref(items), (item, key) => {
                        return openBlock(), createBlock("li", {
                          class: "base-space",
                          key
                        }, [
                          createVNode(_component_FormCheckBox, {
                            label: item,
                            modelValue: unref(selectedItems)[key],
                            "onUpdate:modelValue": ($event) => unref(selectedItems)[key] = $event
                          }, null, 8, ["label", "modelValue", "onUpdate:modelValue"])
                        ]);
                      }), 128))
                    ]),
                    createVNode(_component_FormTextInput, {
                      type: "textarea",
                      name: "description",
                      label: "\u062A\u0648\u0636\u06CC\u062D\u0627\u062A",
                      "hide-label": "",
                      placeholder: "\u062A\u0648\u0636\u06CC\u062D\u0627\u062A",
                      modelValue: unref(description),
                      "onUpdate:modelValue": ($event) => isRef(description) ? description.value = $event : null
                    }, null, 8, ["modelValue", "onUpdate:modelValue"])
                  ];
                }),
                _: 1
              }, 8, ["result", "completion-data"])
            ];
          }
        }),
        _: 1
      }), _parent);
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup$g = _sfc_main$g.setup;
_sfc_main$g.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/ReportWrong/Form.vue");
  return _sfc_setup$g ? _sfc_setup$g(props, ctx) : void 0;
};
const _sfc_main$f = /* @__PURE__ */ defineComponent({
  __name: "Important",
  __ssrInlineRender: true,
  props: {
    productId: {}
  },
  setup(__props) {
    productStore();
    const theme = useState("theme");
    const props = __props;
    const store = specificationsStore();
    const importantItems = computed(() => {
      return Object.values(store.data).filter((item) => {
        return parseInt(item.important.toString()) == 1;
      });
    });
    watch(() => props.productId, () => {
      store.getData(props.productId);
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      if (unref(importantItems).length > 0) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "w-full py-3 important-specifications" }, _attrs))}><div class="flex justify-between items-center max-lg:mb-3"><p class="bold-text text-black font-bold">\u0648\u06CC\u0698\u06AF\u06CC</p>`);
        if (unref(theme) != "desktop") {
          _push(`<span class="cursor-pointer"> \u0645\u0634\u0627\u0647\u062F\u0647 \u0647\u0645\u0647 `);
          _push(ssrRenderComponent(_component_fa_icon, {
            icon: ["fas", "angle-left"],
            class: "pr-1"
          }, null, _parent));
          _push(`</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
        if (unref(theme) == "desktop") {
          _push(`<ul><!--[-->`);
          ssrRenderList(unref(importantItems), (item, key) => {
            _push(`<li><span class="text-gray-600">${ssrInterpolate(item.key)}</span><div class="values"><!--[-->`);
            ssrRenderList(item.values, (value, key2) => {
              _push(`<div>${ssrInterpolate(value)} `);
              if (key2 != item.values.length - 1) {
                _push(`<span> , </span>`);
              } else {
                _push(`<!---->`);
              }
              _push(`</div>`);
            });
            _push(`<!--]--></div></li>`);
          });
          _push(`<!--]--></ul>`);
        } else {
          _push(`<swiper-container slides-per-view="auto"${ssrRenderAttr("space-between", 15)}><!--[-->`);
          ssrRenderList(unref(importantItems), (item, key) => {
            _push(`<swiper-slide class="w-auto border rounded-md px-2 py-1"><div><div class="text-xs text-gray-500 flex justify-between items-center"><span>${ssrInterpolate(item.key)}</span>`);
            _push(ssrRenderComponent(_component_fa_icon, {
              icon: ["fas", "angle-left"],
              class: "pr-2"
            }, null, _parent));
            _push(`</div><div class="flex pt-2 text-black font-bold"><!--[-->`);
            ssrRenderList(item.values, (value, key2) => {
              _push(`<div>${ssrInterpolate(value)} `);
              if (key2 != item.values.length - 1) {
                _push(`<span> , </span>`);
              } else {
                _push(`<!---->`);
              }
              _push(`</div>`);
            });
            _push(`<!--]--></div></div></swiper-slide>`);
          });
          _push(`<!--]--></swiper-container>`);
        }
        if (unref(theme) == "desktop") {
          _push(`<div class="relative flex flex-col items-center pt-5"><div class="w-full h-[1px] bg-gray-300"></div><button class="btn border rounded-md w-auto text-sm mt-[-20px] z-10 bg-white"><span>\u0645\u0634\u0627\u0647\u062F\u0647 \u0647\u0645\u0647 \u0648\u06CC\u0698\u06AF\u06CC\u200C\u0647\u0627</span>`);
          _push(ssrRenderComponent(_component_fa_icon, {
            icon: ["fa", "angle-left"],
            class: "px-2"
          }, null, _parent));
          _push(`</button></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$f = _sfc_main$f.setup;
_sfc_main$f.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/specifications/Important.vue");
  return _sfc_setup$f ? _sfc_setup$f(props, ctx) : void 0;
};
const _sfc_main$e = /* @__PURE__ */ defineComponent({
  __name: "SelectProvince",
  __ssrInlineRender: true,
  props: /* @__PURE__ */ mergeModels({
    name: {},
    label: {}
  }, {
    "modelValue": {},
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props) {
    const provinces = useState("provinces");
    const province_id = useModel(__props, "modelValue");
    return (_ctx, _push, _parent, _attrs) => {
      const _component_FormSelectTag = _sfc_main$u;
      _push(ssrRenderComponent(_component_FormSelectTag, mergeProps({
        items: unref(provinces),
        label: _ctx.label,
        "item-text": "name",
        "item-value": "id",
        name: _ctx.name,
        rules: ["required"],
        modelValue: province_id.value,
        "onUpdate:modelValue": ($event) => province_id.value = $event,
        class: "w-full",
        "use-modal": ""
      }, _attrs), null, _parent));
    };
  }
});
const _sfc_setup$e = _sfc_main$e.setup;
_sfc_main$e.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/area/SelectProvince.vue");
  return _sfc_setup$e ? _sfc_setup$e(props, ctx) : void 0;
};
const useReportPrice = () => {
  const theme = useState("theme");
  const user = useState("user");
  const formBox = ref(null);
  const productState = productStore();
  const successMessage = ref(null);
  const onlineShop = ref(false);
  const formKey = ref(0);
  const form = ref(null);
  const shop_name = ref(null);
  const price = ref(null);
  const result = () => {
    successMessage.value = "\u062B\u0628\u062A \u06AF\u0632\u0627\u0631\u0634 \u0628\u0627 \u0645\u0648\u0641\u0642\u06CC\u062A \u0627\u0646\u062C\u0627\u0645 \u0634\u062F";
    price.value = null;
    shop_name.value = null;
    formKey.value++;
    setTimeout(() => {
      successMessage.value = null;
    }, 3e3);
  };
  watch(() => onlineShop.value, () => {
    formKey.value++;
  });
  return {
    onlineShop,
    successMessage,
    productState,
    Modal: _sfc_main$i$1,
    Offcanvas: _sfc_main$o$1,
    formBox,
    user,
    theme,
    formKey,
    form,
    shop_name,
    price,
    result
  };
};
const _sfc_main$d = /* @__PURE__ */ defineComponent({
  __name: "Form",
  __ssrInlineRender: true,
  setup(__props) {
    useRouter();
    const {
      form,
      theme,
      Modal,
      Offcanvas,
      formBox,
      productState,
      onlineShop,
      formKey,
      successMessage,
      shop_name,
      price,
      result
    } = useReportPrice();
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_FormComponent = _sfc_main$p;
      const _component_FormTextInput = _sfc_main$q;
      const _component_IconsToman = __nuxt_component_3$1;
      const _component_FormCheckBox = _sfc_main$b$1;
      const _component_AreaSelectProvince = _sfc_main$e;
      const _component_Loading = _sfc_main$k$1;
      _push(`<!--[--><div><div class="flex lg:justify-end max-lg:border-t max-lg:mt-3"><button class="text-sm lg: my-5 flex items-center max-lg:justify-between w-full"><span>`);
      _push(ssrRenderComponent(_component_fa_icon, {
        icon: ["fas", "tag"],
        class: "text-gray-700 max-lg:text-gray-500"
      }, null, _parent));
      _push(`<span class="pr-2 max-lg:text-gray-500">\u0642\u06CC\u0645\u062A \u0628\u0647\u062A\u0631\u06CC \u0633\u0631\u0627\u063A \u062F\u0627\u0631\u06CC\u0646\u061F</span></span>`);
      _push(ssrRenderComponent(_component_fa_icon, {
        class: "lg:hidden text-gray-500",
        icon: ["fas", "angle-left"]
      }, null, _parent));
      _push(`</button></div></div>`);
      ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(theme) == "desktop" ? unref(Modal) : unref(Offcanvas)), {
        ref_key: "formBox",
        ref: formBox,
        title: "\u06AF\u0632\u0627\u0631\u0634 \u0642\u06CC\u0645\u062A \u0645\u0646\u0627\u0633\u0628\u200C\u062A\u0631",
        "sub-title": ((_a = unref(productState).product) == null ? void 0 : _a.title.length) > 50 ? ((_b = unref(productState).product) == null ? void 0 : _b.title.substring(0, 50)) + "..." : (_c = unref(productState).product) == null ? void 0 : _c.title,
        "content-class": "w-full h-full bottom-0",
        direction: "bottom",
        class: "report-price-form"
      }, {
        footer: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2, _c2, _d;
          if (_push2) {
            _push2(`<div class="w-full py-2 border-t px-3"${_scopeId}><button class="${ssrRenderClass([[((_a2 = unref(form)) == null ? void 0 : _a2.isValid) ? "btn-danger" : "btn-secondary"], "btn w-full"])}"${_scopeId}>`);
            if (!((_b2 = unref(form)) == null ? void 0 : _b2.loading)) {
              _push2(`<span${_scopeId}>\u062B\u0628\u062A</span>`);
            } else {
              _push2(ssrRenderComponent(_component_Loading, { class: "w-full justify-center" }, null, _parent2, _scopeId));
            }
            _push2(`</button></div>`);
          } else {
            return [
              (openBlock(), createBlock("div", {
                class: "w-full py-2 border-t px-3",
                key: unref(formKey)
              }, [
                createVNode("button", {
                  class: ["btn w-full", [((_c2 = unref(form)) == null ? void 0 : _c2.isValid) ? "btn-danger" : "btn-secondary"]],
                  onClick: ($event) => {
                    var _a3;
                    return (_a3 = unref(form)) == null ? void 0 : _a3.sendForm();
                  }
                }, [
                  !((_d = unref(form)) == null ? void 0 : _d.loading) ? (openBlock(), createBlock("span", { key: 0 }, "\u062B\u0628\u062A")) : (openBlock(), createBlock(_component_Loading, {
                    key: 1,
                    class: "w-full justify-center"
                  }))
                ], 10, ["onClick"])
              ]))
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_FormComponent, {
              result: unref(result),
              class: "px-2 py-5",
              "request-url": "user/report/low-price",
              ref_key: "form",
              ref: form,
              key: unref(formKey)
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                var _a2, _b2;
                if (_push3) {
                  _push3(`<input type="hidden" name="product_id"${ssrRenderAttr("value", (_a2 = unref(productState).product) == null ? void 0 : _a2.id)} class="c-input"${_scopeId2}>`);
                  if (unref(successMessage)) {
                    _push3(`<div class="alert alert-success"${_scopeId2}>${ssrInterpolate(unref(successMessage))}</div>`);
                  } else {
                    _push3(`<!---->`);
                  }
                  _push3(ssrRenderComponent(_component_FormTextInput, {
                    label: "\u0627\u06CC\u0646 \u06A9\u0627\u0644\u0627 \u0631\u0627 \u0628\u0627 \u0686\u0647 \u0642\u06CC\u0645\u062A\u06CC \u062F\u06CC\u062F\u0647\u200C\u0627\u06CC\u062F\u061F",
                    name: "price",
                    rules: ["required"],
                    separator: ",",
                    digit: 3,
                    type: "number",
                    modelValue: unref(price),
                    "onUpdate:modelValue": ($event) => isRef(price) ? price.value = $event : null
                  }, {
                    suffix: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(`<div class="flex items-center px-2"${_scopeId3}>`);
                        _push4(ssrRenderComponent(_component_IconsToman, null, null, _parent4, _scopeId3));
                        _push4(`</div>`);
                      } else {
                        return [
                          createVNode("div", { class: "flex items-center px-2" }, [
                            createVNode(_component_IconsToman)
                          ])
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(`<div class="base-space text-sm"${_scopeId2}>`);
                  _push3(ssrRenderComponent(_component_FormCheckBox, {
                    modelValue: unref(onlineShop),
                    "onUpdate:modelValue": ($event) => isRef(onlineShop) ? onlineShop.value = $event : null,
                    name: "onlineShop",
                    label: "\u062F\u0631 \u0641\u0631\u0648\u0634\u06AF\u0627\u0647 \u0627\u06CC\u0646\u062A\u0631\u0646\u062A\u06CC \u062F\u06CC\u062F\u0647\u200C\u0627\u0645"
                  }, null, _parent3, _scopeId2));
                  _push3(`</div>`);
                  if (!unref(onlineShop)) {
                    _push3(`<!--[-->`);
                    _push3(ssrRenderComponent(_component_FormTextInput, {
                      rules: ["required"],
                      label: "\u0646\u0627\u0645 \u0641\u0631\u0648\u0634\u06AF\u0627\u0647",
                      name: "shop_name",
                      placeholder: "\u0646\u0627\u0645 \u0641\u0631\u0648\u0634\u06AF\u0627\u0647\u06CC \u06A9\u0647 \u06A9\u0627\u0644\u0627 \u0631\u0627 \u0628\u0627 \u0627\u06CC\u0646 \u0642\u06CC\u0645\u062A \u062F\u0631 \u0622\u0646 \u062F\u06CC\u062F\u0647\u200C\u0627\u06CC\u062F",
                      modelValue: unref(shop_name),
                      "onUpdate:modelValue": ($event) => isRef(shop_name) ? shop_name.value = $event : null
                    }, null, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_AreaSelectProvince, {
                      name: "province_id",
                      label: "\u0645\u06A9\u0627\u0646 \u0641\u0631\u0648\u0634\u06AF\u0627\u0647"
                    }, null, _parent3, _scopeId2));
                    _push3(`<!--]-->`);
                  } else {
                    _push3(ssrRenderComponent(_component_FormTextInput, {
                      label: "\u0648\u0628 \u200C\u0633\u0627\u06CC\u062A \u0641\u0631\u0648\u0634\u06AF\u0627\u0647",
                      name: "shop_url",
                      placeholder: "example.com",
                      rules: ["required"]
                    }, null, _parent3, _scopeId2));
                  }
                } else {
                  return [
                    createVNode("input", {
                      type: "hidden",
                      name: "product_id",
                      value: (_b2 = unref(productState).product) == null ? void 0 : _b2.id,
                      class: "c-input"
                    }, null, 8, ["value"]),
                    unref(successMessage) ? (openBlock(), createBlock("div", {
                      key: 0,
                      class: "alert alert-success"
                    }, toDisplayString(unref(successMessage)), 1)) : createCommentVNode("", true),
                    createVNode(_component_FormTextInput, {
                      label: "\u0627\u06CC\u0646 \u06A9\u0627\u0644\u0627 \u0631\u0627 \u0628\u0627 \u0686\u0647 \u0642\u06CC\u0645\u062A\u06CC \u062F\u06CC\u062F\u0647\u200C\u0627\u06CC\u062F\u061F",
                      name: "price",
                      rules: ["required"],
                      separator: ",",
                      digit: 3,
                      type: "number",
                      modelValue: unref(price),
                      "onUpdate:modelValue": ($event) => isRef(price) ? price.value = $event : null
                    }, {
                      suffix: withCtx(() => [
                        createVNode("div", { class: "flex items-center px-2" }, [
                          createVNode(_component_IconsToman)
                        ])
                      ]),
                      _: 1
                    }, 8, ["modelValue", "onUpdate:modelValue"]),
                    createVNode("div", { class: "base-space text-sm" }, [
                      createVNode(_component_FormCheckBox, {
                        modelValue: unref(onlineShop),
                        "onUpdate:modelValue": ($event) => isRef(onlineShop) ? onlineShop.value = $event : null,
                        name: "onlineShop",
                        label: "\u062F\u0631 \u0641\u0631\u0648\u0634\u06AF\u0627\u0647 \u0627\u06CC\u0646\u062A\u0631\u0646\u062A\u06CC \u062F\u06CC\u062F\u0647\u200C\u0627\u0645"
                      }, null, 8, ["modelValue", "onUpdate:modelValue"])
                    ]),
                    !unref(onlineShop) ? (openBlock(), createBlock(Fragment, { key: 1 }, [
                      createVNode(_component_FormTextInput, {
                        rules: ["required"],
                        label: "\u0646\u0627\u0645 \u0641\u0631\u0648\u0634\u06AF\u0627\u0647",
                        name: "shop_name",
                        placeholder: "\u0646\u0627\u0645 \u0641\u0631\u0648\u0634\u06AF\u0627\u0647\u06CC \u06A9\u0647 \u06A9\u0627\u0644\u0627 \u0631\u0627 \u0628\u0627 \u0627\u06CC\u0646 \u0642\u06CC\u0645\u062A \u062F\u0631 \u0622\u0646 \u062F\u06CC\u062F\u0647\u200C\u0627\u06CC\u062F",
                        modelValue: unref(shop_name),
                        "onUpdate:modelValue": ($event) => isRef(shop_name) ? shop_name.value = $event : null
                      }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                      createVNode(_component_AreaSelectProvince, {
                        name: "province_id",
                        label: "\u0645\u06A9\u0627\u0646 \u0641\u0631\u0648\u0634\u06AF\u0627\u0647"
                      })
                    ], 64)) : (openBlock(), createBlock(_component_FormTextInput, {
                      key: 2,
                      label: "\u0648\u0628 \u200C\u0633\u0627\u06CC\u062A \u0641\u0631\u0648\u0634\u06AF\u0627\u0647",
                      name: "shop_url",
                      placeholder: "example.com",
                      rules: ["required"]
                    }))
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              (openBlock(), createBlock(_component_FormComponent, {
                result: unref(result),
                class: "px-2 py-5",
                "request-url": "user/report/low-price",
                ref_key: "form",
                ref: form,
                key: unref(formKey)
              }, {
                default: withCtx(() => {
                  var _a2;
                  return [
                    createVNode("input", {
                      type: "hidden",
                      name: "product_id",
                      value: (_a2 = unref(productState).product) == null ? void 0 : _a2.id,
                      class: "c-input"
                    }, null, 8, ["value"]),
                    unref(successMessage) ? (openBlock(), createBlock("div", {
                      key: 0,
                      class: "alert alert-success"
                    }, toDisplayString(unref(successMessage)), 1)) : createCommentVNode("", true),
                    createVNode(_component_FormTextInput, {
                      label: "\u0627\u06CC\u0646 \u06A9\u0627\u0644\u0627 \u0631\u0627 \u0628\u0627 \u0686\u0647 \u0642\u06CC\u0645\u062A\u06CC \u062F\u06CC\u062F\u0647\u200C\u0627\u06CC\u062F\u061F",
                      name: "price",
                      rules: ["required"],
                      separator: ",",
                      digit: 3,
                      type: "number",
                      modelValue: unref(price),
                      "onUpdate:modelValue": ($event) => isRef(price) ? price.value = $event : null
                    }, {
                      suffix: withCtx(() => [
                        createVNode("div", { class: "flex items-center px-2" }, [
                          createVNode(_component_IconsToman)
                        ])
                      ]),
                      _: 1
                    }, 8, ["modelValue", "onUpdate:modelValue"]),
                    createVNode("div", { class: "base-space text-sm" }, [
                      createVNode(_component_FormCheckBox, {
                        modelValue: unref(onlineShop),
                        "onUpdate:modelValue": ($event) => isRef(onlineShop) ? onlineShop.value = $event : null,
                        name: "onlineShop",
                        label: "\u062F\u0631 \u0641\u0631\u0648\u0634\u06AF\u0627\u0647 \u0627\u06CC\u0646\u062A\u0631\u0646\u062A\u06CC \u062F\u06CC\u062F\u0647\u200C\u0627\u0645"
                      }, null, 8, ["modelValue", "onUpdate:modelValue"])
                    ]),
                    !unref(onlineShop) ? (openBlock(), createBlock(Fragment, { key: 1 }, [
                      createVNode(_component_FormTextInput, {
                        rules: ["required"],
                        label: "\u0646\u0627\u0645 \u0641\u0631\u0648\u0634\u06AF\u0627\u0647",
                        name: "shop_name",
                        placeholder: "\u0646\u0627\u0645 \u0641\u0631\u0648\u0634\u06AF\u0627\u0647\u06CC \u06A9\u0647 \u06A9\u0627\u0644\u0627 \u0631\u0627 \u0628\u0627 \u0627\u06CC\u0646 \u0642\u06CC\u0645\u062A \u062F\u0631 \u0622\u0646 \u062F\u06CC\u062F\u0647\u200C\u0627\u06CC\u062F",
                        modelValue: unref(shop_name),
                        "onUpdate:modelValue": ($event) => isRef(shop_name) ? shop_name.value = $event : null
                      }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                      createVNode(_component_AreaSelectProvince, {
                        name: "province_id",
                        label: "\u0645\u06A9\u0627\u0646 \u0641\u0631\u0648\u0634\u06AF\u0627\u0647"
                      })
                    ], 64)) : (openBlock(), createBlock(_component_FormTextInput, {
                      key: 2,
                      label: "\u0648\u0628 \u200C\u0633\u0627\u06CC\u062A \u0641\u0631\u0648\u0634\u06AF\u0627\u0647",
                      name: "shop_url",
                      placeholder: "example.com",
                      rules: ["required"]
                    }))
                  ];
                }),
                _: 1
              }, 8, ["result"]))
            ];
          }
        }),
        _: 1
      }), _parent);
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup$d = _sfc_main$d.setup;
_sfc_main$d.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/ReportPrice/Form.vue");
  return _sfc_setup$d ? _sfc_setup$d(props, ctx) : void 0;
};
const _sfc_main$c = /* @__PURE__ */ defineComponent({
  __name: "ReturnConditions",
  __ssrInlineRender: true,
  setup(__props) {
    const theme = useState("theme");
    const store = productStore();
    const categories = useState("categories");
    const category = computed(() => {
      if (categories.value) {
        return categories.value.find((category2) => category2.id == store.product.category_id);
      }
      return null;
    });
    return (_ctx, _push, _parent, _attrs) => {
      var _a;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_ReportWrongForm = _sfc_main$g;
      const _component_ReportPriceForm = _sfc_main$d;
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      if (unref(store).product && unref(category)) {
        _push(`<div class="lg:flex text-gray-500 text-sm"><div class="flex items-center">`);
        _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "circle-info"] }, null, _parent));
        _push(`<span class="text-black font-bold lg:hidden pr-2"> \u0634\u0631\u0627\u06CC\u0637 \u0628\u0627\u0632\u06AF\u0634\u062A \u06A9\u0627\u0644\u0627 </span></div><p class="pr-2 max-lg:pr-5"> \u062F\u0631\u062E\u0648\u0627\u0633\u062A \u0645\u0631\u062C\u0648\u0639 \u06A9\u0631\u062F\u0646 \u06A9\u0627\u0644\u0627 \u062F\u0631 \u06AF\u0631\u0648\u0647 ${ssrInterpolate(unref(category).name)} \u0628\u0627 \u062F\u0644\u06CC\u0644 &quot;\u0627\u0646\u0635\u0631\u0627\u0641 \u0627\u0632 \u062E\u0631\u06CC\u062F&quot; \u062A\u0646\u0647\u0627 \u062F\u0631 \u0635\u0648\u0631\u062A\u06CC \u0642\u0627\u0628\u0644 \u062A\u0627\u06CC\u06CC\u062F \u0627\u0633\u062A \u06A9\u0647 \u06A9\u0627\u0644\u0627 \u062F\u0631 \u0634\u0631\u0627\u06CC\u0637 \u0627\u0648\u0644\u06CC\u0647 \u0628\u0627\u0634\u062F (\u062F\u0631 \u0635\u0648\u0631\u062A \u067E\u0644\u0645\u067E \u0628\u0648\u062F\u0646\u060C \u06A9\u0627\u0644\u0627 \u0646\u0628\u0627\u06CC\u062F \u0628\u0627\u0632 \u0634\u062F\u0647 \u0628\u0627\u0634\u062F). </p></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(theme) != "desktop") {
        _push(ssrRenderComponent(_component_ReportWrongForm, null, null, _parent));
      } else {
        _push(`<!---->`);
      }
      if (unref(theme) != "desktop" && ((_a = unref(store).product) == null ? void 0 : _a.status) == 1) {
        _push(ssrRenderComponent(_component_ReportPriceForm, null, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$c = _sfc_main$c.setup;
_sfc_main$c.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/product-page/ReturnConditions.vue");
  return _sfc_setup$c ? _sfc_setup$c(props, ctx) : void 0;
};
const _sfc_main$b = /* @__PURE__ */ defineComponent({
  __name: "SellerPerformanceDetail",
  __ssrInlineRender: true,
  props: {
    title: {},
    value: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "p-3 text-gray-500 flex text-center flex-col" }, _attrs))}><span>${ssrInterpolate(_ctx.value)}</span><span>${ssrInterpolate(_ctx.title)}</span></div>`);
    };
  }
});
const _sfc_setup$b = _sfc_main$b.setup;
_sfc_main$b.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/priceVariation/SellerPerformanceDetail.vue");
  return _sfc_setup$b ? _sfc_setup$b(props, ctx) : void 0;
};
const _sfc_main$a = /* @__PURE__ */ defineComponent({
  __name: "SellerPerformance",
  __ssrInlineRender: true,
  props: {
    variation: {}
  },
  setup(__props) {
    const shopSetting = useState("shopSetting");
    const props = __props;
    const showSellerPerformance = ref(false);
    const sellerBrandName = computed(
      () => {
        var _a;
        return ((_a = props.variation.seller) == null ? void 0 : _a.brandName) || "";
      }
    );
    const sellerIconUrl = computed(() => {
      if (props.variation.seller_id == 0) {
        return `${useRuntimeConfig().public.serverUrl}/${shopSetting.value.icon}`;
      } else if (props.variation.seller.icon) {
        return `${useRuntimeConfig().public.serverUrl}/images/${props.variation.seller.icon}`;
      } else {
        return null;
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_PriceVariationSellerPerformanceDetail = _sfc_main$b;
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      if (unref(shopSetting)) {
        _push(`<div class="py-3 flex cursor-pointer"><div class="relative">`);
        if (unref(sellerIconUrl)) {
          _push(`<img${ssrRenderAttr("src", unref(sellerIconUrl))}${ssrRenderAttr("alt", unref(sellerBrandName))} class="w-14 blend-mode-darken">`);
        } else {
          _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "store"] }, null, _parent));
        }
        _push(`</div><div class="px-3 brand-name">`);
        if (unref(sellerBrandName)) {
          _push(`<span>${ssrInterpolate(unref(sellerBrandName))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="py-3 text-sm"><span class="text-gray-500 px-1">\u0639\u0645\u0644\u06A9\u0631\u062F</span><span class="text-green-500">\u0639\u0627\u0644\u06CC</span></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(showSellerPerformance)) {
        _push(`<div class="performance-details"><div><p class="font-bold text-black"> \u0641\u0631\u0648\u0634\u06AF\u0627\u0647 ${ssrInterpolate(unref(sellerBrandName))}</p><p class="py-3 text-gray-500">\u0639\u0636\u0648 \u0627\u0632 \u06F4 \u0633\u0627\u0644 \u0648 \u06F1\u06F1 \u0645\u0627\u0647</p></div><span class="text-green-500 py-3 flex justify-center text-xl">\u0639\u0627\u0644\u06CC</span><div class="flex justify-between text-sm">`);
        _push(ssrRenderComponent(_component_PriceVariationSellerPerformanceDetail, {
          title: "\u062A\u0627\u0645\u06CC\u0646 \u0628\u0647 \u0645\u0648\u0642\u0639",
          value: "\u06F1\u06F0\u06F0\u066A"
        }, null, _parent));
        _push(ssrRenderComponent(_component_PriceVariationSellerPerformanceDetail, {
          title: "\u062A\u0639\u0647\u062F \u0627\u0631\u0633\u0627\u0644",
          value: "\u06F1\u06F0\u06F0\u066A"
        }, null, _parent));
        _push(ssrRenderComponent(_component_PriceVariationSellerPerformanceDetail, {
          title: "\u0628\u062F\u0648\u0646 \u0645\u0631\u062C\u0648\u0639\u06CC",
          value: "\u06F9\u06F9.\u06F9\u066A"
        }, null, _parent));
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$a = _sfc_main$a.setup;
_sfc_main$a.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/priceVariation/SellerPerformance.vue");
  return _sfc_setup$a ? _sfc_setup$a(props, ctx) : void 0;
};
const _sfc_main$9 = /* @__PURE__ */ defineComponent({
  __name: "Detail",
  __ssrInlineRender: true,
  props: {
    product: {},
    hideCartBtn: { type: Boolean }
  },
  setup(__props) {
    const props = __props;
    const shopSetting = useState("shopSetting");
    const selectedVariationId = useState("variation-id");
    const selectedVariation = ref(null);
    const theme = useState("theme");
    const getSellerCount = () => {
      return props.product.variations.filter((variation) => {
        return selectedVariation.value.param1_id === variation.param1_id && variation.product_count > 0;
      }).length;
    };
    watch(() => selectedVariationId.value, () => {
      selectedVariation.value = props.product.variations.find((variation) => variation.id == selectedVariationId.value);
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_PriceVariationSellerPerformance = _sfc_main$a;
      const _component_PriceVariationPriceBox = _sfc_main$c$1;
      const _component_PriceVariationNotifications = _sfc_main$l$1;
      const _component_CartAddBtn = _sfc_main$h$1;
      const _component_PriceVariationSendDetail = _sfc_main$s;
      if (unref(selectedVariation)) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "variation-detail relative" }, _attrs))}>`);
        if (unref(shopSetting) && unref(shopSetting)["multi-seller"] == "true") {
          _push(`<div class="flex justify-between"><span class="font-bold">\u0641\u0631\u0648\u0634\u0646\u062F\u0647</span><span class="text-blue-400 cursor-pointer">${ssrInterpolate(_ctx.$replaceEnNumber(getSellerCount()))} \u0641\u0631\u0648\u0634\u0646\u062F\u0647 </span></div>`);
        } else {
          _push(`<!---->`);
        }
        if (unref(shopSetting) && unref(shopSetting)["multi-seller"] == "true") {
          _push(ssrRenderComponent(_component_PriceVariationSellerPerformance, { variation: unref(selectedVariation) }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        if (unref(selectedVariation).param3_type) {
          _push(`<div class="py-3 border-b">`);
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(_ctx.$variationParamComponent(unref(selectedVariation).param3_type)), {
            data: unref(selectedVariation).param3
          }, null), _parent);
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        if (unref(selectedVariation).param2_type && !unref(selectedVariation).param3_type) {
          _push(`<div class="py-3 border-b">`);
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(_ctx.$variationParamComponent(unref(selectedVariation).param2_type)), {
            data: unref(selectedVariation).param2
          }, null), _parent);
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="flex justify-end py-4">`);
        _push(ssrRenderComponent(_component_PriceVariationPriceBox, { variation: unref(selectedVariation) }, null, _parent));
        _push(`</div>`);
        if (!_ctx.hideCartBtn) {
          _push(`<div class="my-3">`);
          if (unref(theme) == "desktop") {
            _push(ssrRenderComponent(_component_PriceVariationNotifications, { product: _ctx.product }, null, _parent));
          } else {
            _push(`<!---->`);
          }
          if (unref(selectedVariation)) {
            _push(ssrRenderComponent(_component_CartAddBtn, {
              variation: unref(selectedVariation),
              product: _ctx.product
            }, null, _parent));
          } else {
            _push(`<!---->`);
          }
          _push(ssrRenderComponent(_component_PriceVariationSendDetail, {
            variation: unref(selectedVariation),
            class: "mt-5"
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$9 = _sfc_main$9.setup;
_sfc_main$9.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/priceVariation/Detail.vue");
  return _sfc_setup$9 ? _sfc_setup$9(props, ctx) : void 0;
};
const _sfc_main$8 = /* @__PURE__ */ defineComponent({
  __name: "Information",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    const theme = useState("theme");
    productStore();
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0$2;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_PriceVariationItems = _sfc_main$r;
      const _component_SpecificationsImportant = _sfc_main$f;
      const _component_ProductPageReturnConditions = _sfc_main$c;
      const _component_PriceVariationDetail = _sfc_main$9;
      const _component_NotificationsRequestAvailability = _sfc_main$9$1;
      const _component_ReportPriceForm = _sfc_main$d;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "w-full" }, _attrs))}><div class="flex items-center">`);
      if (_ctx.product.brand) {
        _push(ssrRenderComponent(_component_nuxt_link, {
          to: "/brand/" + _ctx.product.brand.english_name
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (_ctx.product.brand.icon) {
                _push2(`<img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/upload/" + _ctx.product.brand.icon)} alt="" class="w-10"${_scopeId}>`);
              } else {
                _push2(`<!---->`);
              }
            } else {
              return [
                _ctx.product.brand.icon ? (openBlock(), createBlock("img", {
                  key: 0,
                  src: ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/upload/" + _ctx.product.brand.icon,
                  alt: "",
                  class: "w-10"
                }, null, 8, ["src"])) : createCommentVNode("", true)
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<h1 class="pr-1 text-black md:text-xl font-bold" style="${ssrRenderStyle({ width: _ctx.product.brand ? "calc(100% - 40px)" : "100%" })}">${ssrInterpolate(_ctx.product.title)}</h1></div><div class="lg:flex py-3"><div class="max-lg:w-full lg:flex-grow pl-2"><div class="flex relative items-center w-full"><p class="text-sm text-gray-400 bg-white pl-2 z-[5]">${ssrInterpolate(_ctx.product.en_title)}</p><span class="hidden lg:block w-full bg-gray-200 absolute h-[1px]"></span></div><div><ul class="pt-3 flex flex-wrap items-center">`);
      if (_ctx.product.score) {
        _push(`<li class="ml-1 mb-3">`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fas", "star"],
          class: "text-yellow-400"
        }, null, _parent));
        _push(`<span class="pr-1">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.product.score))}</span><span class="text-gray-400 text-xs"> (\u0627\u0632 ${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.product.score_from_sale_count))} \u062E\u0631\u06CC\u062F) </span></li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.product.comment_count) {
        _push(`<li class="mx-3 cursor-pointer mb-3"><button class="bg-gray-100 font-bold rounded-md text-sm px-3 py-1">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.product.comment_count))} \u062F\u06CC\u062F\u06AF\u0627\u0647 `);
        _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "angle-left"] }, null, _parent));
        _push(`</button></li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.product.question_count) {
        _push(`<li class="cursor-pointer mb-3"><button class="bg-gray-100 font-bold rounded-md text-sm px-3 py-1">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.product.question_count))} \u067E\u0631\u0633\u0634 `);
        _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "angle-left"] }, null, _parent));
        _push(`</button></li>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</ul></div>`);
      if (_ctx.product) {
        _push(ssrRenderComponent(_component_PriceVariationItems, { product: _ctx.product }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_component_SpecificationsImportant, {
        "product-id": _ctx.product.id
      }, null, _parent));
      if (unref(theme) == "desktop") {
        _push(ssrRenderComponent(_component_ProductPageReturnConditions, { class: "mt-3 w-full" }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="w-full lg:!w-[320px] flex-shrink-0 flex-grow-0">`);
      if (_ctx.product.status == 1) {
        _push(ssrRenderComponent(_component_PriceVariationDetail, {
          product: _ctx.product,
          "hide-cart-btn": unref(theme) !== "desktop",
          class: "max-lg:!px-0"
        }, null, _parent));
      } else {
        _push(`<!--[-->`);
        if (unref(theme) == "desktop") {
          _push(ssrRenderComponent(_component_NotificationsRequestAvailability, { product: _ctx.product }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      }
      if (unref(theme) == "desktop" && _ctx.product.status == 1) {
        _push(ssrRenderComponent(_component_ReportPriceForm, null, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div>`);
    };
  }
});
const _sfc_setup$8 = _sfc_main$8.setup;
_sfc_main$8.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/product-page/Information.vue");
  return _sfc_setup$8 ? _sfc_setup$8(props, ctx) : void 0;
};
const _sfc_main$7 = /* @__PURE__ */ defineComponent({
  __name: "PurchaseFeatures",
  __ssrInlineRender: true,
  setup(__props) {
    const { serverUrl } = useRuntimeConfig().public;
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex justify-between px-10 my-7" }, _attrs))}><div class="flex items-center"><img${ssrRenderAttr("src", unref(serverUrl) + "/images/express-delivery-grey.svg")} alt="\u0627\uFEE3\uFB91\uFE8E\u0646 \uFE97\uFEA4\uFEEE\uFBFE\uFEDE \u0627\uFB90\uFEB4\uFB59\uFEAE\u0633" class="w-12 h-12"><span class="text-sm p-1.5 text-gray-600">\u0627\uFEE3\uFB91\uFE8E\u0646 \uFE97\uFEA4\uFEEE\uFBFE\uFEDE \u0627\uFB90\uFEB4\uFB59\uFEAE\u0633</span></div><div class="flex items-center"><img${ssrRenderAttr("src", unref(serverUrl) + "/images/cash-on-delivery-grey.svg")} alt="" class="w-12 h-12"><span class="text-sm p-1.5 text-gray-600">\u0627\u0645\u06A9\u0627\u0646 \u067E\u0631\u062F\u0627\u062E\u062A \u062F\u0631 \u0645\u062D\u0644</span></div><div class="flex items-center"><img${ssrRenderAttr("src", unref(serverUrl) + "/images/support-grey.svg")} alt="\u06F7 \u0631\u0648\u0632 \uFEEB\uFED4\uFE98\uFEEA\u060C \u06F2\u06F4 \uFEB3\uFE8E\uFECB\uFE98\uFEEA" class="w-12 h-12"><span class="text-sm p-1.5 text-gray-600">\u06F7 \u0631\u0648\u0632 \uFEEB\uFED4\uFE98\uFEEA\u060C \u06F2\u06F4 \uFEB3\uFE8E\uFECB\uFE98\uFEEA</span></div><div class="flex items-center"><img${ssrRenderAttr("src", unref(serverUrl) + "/images/days-return-grey.svg")} alt="\u06F7\u0647\u0641\u062A \u0631\u0648\u0632 \u0636\u0645\u0627\u0646\u062A \u0628\u0627\u0632\u06AF\u0634\u062A \u06A9\u0627\u0644\u0627" class="w-12 h-12"><span class="text-sm p-1.5 text-gray-600">\u06F7\u0647\u0641\u062A \u0631\u0648\u0632 \u0636\u0645\u0627\u0646\u062A \u0628\u0627\u0632\u06AF\u0634\u062A \u06A9\u0627\u0644\u0627</span></div><div class="flex items-center"><img${ssrRenderAttr("src", unref(serverUrl) + "/images/original-products-grey.svg")} alt="\uFEBF\uFEE4\uFE8E\uFEE7\uFE96 \u0627\uFEBB\uFEDE \uFE91\uFEEE\u062F\u0646 \uFB90\uFE8E\uFEDF\uFE8E" class="w-12 h-12"><span class="text-sm p-1.5 text-gray-600">\uFEBF\uFEE4\uFE8E\uFEE7\uFE96 \u0627\uFEBB\uFEDE \uFE91\uFEEE\u062F\u0646 \uFB90\uFE8E\uFEDF\uFE8E</span></div></div>`);
    };
  }
});
const _sfc_setup$7 = _sfc_main$7.setup;
_sfc_main$7.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/product-page/PurchaseFeatures.vue");
  return _sfc_setup$7 ? _sfc_setup$7(props, ctx) : void 0;
};
const _sfc_main$6 = /* @__PURE__ */ defineComponent({
  __name: "Desktop",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    const props = __props;
    const shopSetting = useState("shopSetting");
    const selectedVariationId = useState("variation-id");
    const variations = computed(() => {
      const find = props.product.variations.find((row) => row.id == selectedVariationId.value);
      if (find) {
        return props.product.variations.filter((row) => row.param1_id == find.param1_id);
      }
      return [];
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_PriceVariationSellerPerformance = _sfc_main$a;
      const _component_PriceVariationSendDetail = _sfc_main$s;
      const _component_CartAddBtn = _sfc_main$h$1;
      if (unref(variations).length > 1) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "py-5" }, _attrs))}><div><h1>\u0641\u0631\u0648\u0634\u0646\u062F\u06AF\u0627\u0646 \u0627\u06CC\u0646 \u06A9\u0627\u0644\u0627</h1><div class="title-line mt-4"></div></div><!--[-->`);
        ssrRenderList(unref(variations), (variation, index) => {
          _push(`<div class="${ssrRenderClass([{ "bg-gray-100 rounded-md": index % 2 === 1 }, "flex px-3 w-full justify-between items-center"])}">`);
          if (unref(shopSetting) && unref(shopSetting)["multi-seller"] == "true") {
            _push(`<div class="w-full">`);
            _push(ssrRenderComponent(_component_PriceVariationSellerPerformance, { variation }, null, _parent));
            _push(`</div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<div class="w-full">`);
          _push(ssrRenderComponent(_component_PriceVariationSendDetail, { variation }, null, _parent));
          _push(`</div><div class="w-full">`);
          if (variation.param2_type && !variation.param3_type) {
            ssrRenderVNode(_push, createVNode(resolveDynamicComponent(_ctx.$variationParamComponent(variation.param2_type)), {
              data: variation.param2
            }, null), _parent);
          } else {
            _push(`<!---->`);
          }
          _push(`</div><div class="px-4 font-bold w-full">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(variation.price2)))} \u062A\u0648\u0645\u0627\u0646 </div><div class="w-[220px] flex-shrink-0">`);
          _push(ssrRenderComponent(_component_CartAddBtn, {
            variation,
            class: "text-xs px-3 !w-auto"
          }, null, _parent));
          _push(`</div></div>`);
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$6 = _sfc_main$6.setup;
_sfc_main$6.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/priceVariation/all-list/Desktop.vue");
  return _sfc_setup$6 ? _sfc_setup$6(props, ctx) : void 0;
};
const _sfc_main$5 = /* @__PURE__ */ defineComponent({
  __name: "ShortDetail",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    const props = __props;
    const selectedVariationId = useState("variation-id");
    const selectedVariation = ref(null);
    watch(() => selectedVariationId.value, () => {
      const variations = props.product.variations;
      selectedVariation.value = variations.find((variation) => variation.id == selectedVariationId.value);
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_PriceVariationPriceBox = _sfc_main$c$1;
      const _component_CartAddBtn = _sfc_main$h$1;
      if (unref(selectedVariation)) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "variation-detail relative" }, _attrs))}><div class="flex items-center py-3"><img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/thumbnails/" + _ctx.product.image)} class="product-small-image"${ssrRenderAttr("alt", _ctx.product.title)}><div class="mx-3"><p class="title-twl lh-25 text-sm">${ssrInterpolate(_ctx.product.title)}</p>`);
        if (unref(selectedVariation).param1_type != null) {
          _push(`<div class="flex items-center">`);
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(_ctx.$variationParamComponent(unref(selectedVariation).param1_type)), {
            data: unref(selectedVariation).param1
          }, null), _parent);
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div><div class="flex justify-end py-4">`);
        _push(ssrRenderComponent(_component_PriceVariationPriceBox, { variation: unref(selectedVariation) }, null, _parent));
        _push(`</div>`);
        if (!_ctx.hideCartBtn) {
          _push(`<div class="my-3">`);
          if (unref(selectedVariation)) {
            _push(ssrRenderComponent(_component_CartAddBtn, {
              variation: unref(selectedVariation)
            }, null, _parent));
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$5 = _sfc_main$5.setup;
_sfc_main$5.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/priceVariation/ShortDetail.vue");
  return _sfc_setup$5 ? _sfc_setup$5(props, ctx) : void 0;
};
const _sfc_main$4 = {
  __name: "Tabs",
  __ssrInlineRender: true,
  setup(__props) {
    const store = productStore();
    const theme = useState("theme");
    const tabsRef = ref(null);
    const top = ref(0);
    const changeTab = (key) => {
      const el = (void 0).querySelector(`#tab-${key}`);
      if (el) {
        el.scrollIntoView({ behavior: "smooth" });
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Tabs = _sfc_main$t;
      const _component_PriceVariationShortDetail = _sfc_main$5;
      _push(ssrRenderComponent(_component_Tabs, mergeProps({
        ref_key: "tabsRef",
        ref: tabsRef,
        items: unref(store).tabs,
        "show-all-content": "",
        id: "product-tabs",
        "changed-tab": changeTab,
        modelValue: unref(store).activeTab,
        "onUpdate:modelValue": ($event) => unref(store).activeTab = $event
      }, _attrs), {
        "all-content": withCtx(({ activeTab }, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="lg:px-4 py-2 flex bg-white z-10"${_scopeId}><div class="tab-content flex-grow w-full"${_scopeId}><!--[-->`);
            ssrRenderList(unref(store).tabs, (tab, key) => {
              _push2(`<div${ssrRenderAttr("id", "tab-" + key)} class="${ssrRenderClass([{ "lg:border-b max-lg:border-b-[8px]": key !== unref(store).tabs.length - 1 }, "lg:pb-5"])}"${_scopeId}>`);
              ssrRenderVNode(_push2, createVNode(resolveDynamicComponent(tab.component), {
                active: key === activeTab,
                class: "max-lg:px-4"
              }, null), _parent2, _scopeId);
              _push2(`</div>`);
            });
            _push2(`<!--]--></div>`);
            if (unref(store).product && parseInt(unref(store).product.status) === 1 && unref(theme) === "desktop") {
              _push2(`<div class="w-[400px]"${_scopeId}><div class="sticky" style="${ssrRenderStyle({ top: unref(top) + "px" })}"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_PriceVariationShortDetail, {
                product: unref(store).product
              }, null, _parent2, _scopeId));
              _push2(`</div></div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "lg:px-4 py-2 flex bg-white z-10" }, [
                createVNode("div", { class: "tab-content flex-grow w-full" }, [
                  (openBlock(true), createBlock(Fragment, null, renderList(unref(store).tabs, (tab, key) => {
                    return openBlock(), createBlock("div", {
                      key,
                      id: "tab-" + key,
                      class: [{ "lg:border-b max-lg:border-b-[8px]": key !== unref(store).tabs.length - 1 }, "lg:pb-5"]
                    }, [
                      (openBlock(), createBlock(resolveDynamicComponent(tab.component), {
                        active: key === activeTab,
                        class: "max-lg:px-4"
                      }, null, 8, ["active"]))
                    ], 10, ["id"]);
                  }), 128))
                ]),
                unref(store).product && parseInt(unref(store).product.status) === 1 && unref(theme) === "desktop" ? (openBlock(), createBlock("div", {
                  key: 0,
                  class: "w-[400px]"
                }, [
                  createVNode("div", {
                    class: "sticky",
                    style: { top: unref(top) + "px" }
                  }, [
                    createVNode(_component_PriceVariationShortDetail, {
                      product: unref(store).product
                    }, null, 8, ["product"])
                  ], 4)
                ])) : createCommentVNode("", true)
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/product-page/Tabs.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "Mobile",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    galleryStore();
    const tabSlider = ref(null);
    const injectStyles = [`
.swiper-pagination{
   left:50px !important;
}
.swiper-pagination-bullet-active{
   background-color:#55f;
   width:20px;
   border-radius: 10px;
}`];
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ProductPageGalleryTabSlider = _sfc_main$i;
      const _component_PromotionsDisplayOfferLabel = _sfc_main$n;
      _push(`<!--[--><swiper-container class="my-5"${ssrRenderAttr("pagination", {
        dynamicBullets: true
      })}${ssrRenderAttr("injectStyles", injectStyles)}><!--[-->`);
      ssrRenderList(_ctx.product.gallery, (gallery2, key) => {
        _push(`<swiper-slide><img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/" + gallery2.path)} class="w-full h-[270px] object-contain" alt=""></swiper-slide>`);
      });
      _push(`<!--]--></swiper-container>`);
      _push(ssrRenderComponent(_component_ProductPageGalleryTabSlider, {
        ref_key: "tabSlider",
        ref: tabSlider
      }, null, _parent));
      _push(ssrRenderComponent(_component_PromotionsDisplayOfferLabel, { product: _ctx.product }, null, _parent));
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/product-page/gallery/Mobile.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "Icon",
  __ssrInlineRender: true,
  props: {
    title: {},
    text: {},
    url: {}
  },
  setup(__props) {
    const props = __props;
    const shareContent = async () => {
      if ((void 0).share) {
        try {
          const shareData = {
            title: props.title,
            text: props.text,
            url: props.url
          };
          await (void 0).share(shareData);
        } catch (error) {
        }
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(ssrRenderComponent(_component_fa_icon, mergeProps({
        icon: ["fas", "share-nodes"],
        onClick: shareContent
      }, _attrs), null, _parent));
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/share/Icon.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "OffcanvasTabs",
  __ssrInlineRender: true,
  setup(__props) {
    const descriptionOffcanvas = ref(null);
    const store = productStore();
    const getTabs = computed(() => {
      return store.tabs.filter((tab) => tab.type == "description");
    });
    watch(() => store.descriptionOffcanvas, () => {
      if (store.descriptionOffcanvas == "show") {
        descriptionOffcanvas.value.show();
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Offcanvas = _sfc_main$o$1;
      const _component_Tabs = _sfc_main$t;
      if (unref(getTabs)) {
        _push(ssrRenderComponent(_component_Offcanvas, mergeProps({
          ref_key: "descriptionOffcanvas",
          ref: descriptionOffcanvas,
          direction: "bottom",
          title: "\u0645\u0634\u062E\u0635\u0627\u062A \u0648 \u0628\u0631\u0631\u0633\u06CC \u06A9\u0627\u0644\u0627",
          "content-class": "!h-full w-full bottom-0 product-description-tabs",
          afterClose: () => {
            unref(store).descriptionOffcanvas = "hide";
          }
        }, _attrs), {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(_component_Tabs, { items: unref(getTabs) }, null, _parent2, _scopeId));
            } else {
              return [
                createVNode(_component_Tabs, { items: unref(getTabs) }, null, 8, ["items"])
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/product-page/OffcanvasTabs.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
function useProduct(global) {
  const shopSetting = useState("shopSetting");
  const theme = useState("theme");
  const route = useRoute();
  const { api, serverUrl, appUrl } = useRuntimeConfig().public;
  let requestUrl = api + "/product/" + route.params["id"];
  if (Object.keys(route.query).length > 0) {
    const queryString = new URLSearchParams(route.query.toString()).toString();
    requestUrl += "?" + queryString;
  }
  const store = productStore();
  const getMeta = (product) => {
    var _a;
    return [
      {
        name: "description",
        content: product.description
      },
      {
        name: "keywords",
        content: product.tags
      },
      {
        property: "og:title",
        content: "\u0641\u0631\u0648\u0634\u06AF\u0627\u0647 \u0627\u06CC\u0646\u062A\u0631\u0646\u062A\u06CC " + ((_a = shopSetting.value) == null ? void 0 : _a.name) + " - " + product.title
      },
      {
        property: "og:description",
        content: product.description
      },
      {
        property: "og:image",
        content: serverUrl + "/thumbnails/" + product.image
      },
      {
        property: "og:url",
        content: appUrl + "/" + global.$getProductPath(product)
      },
      {
        property: "og:type",
        content: "product"
      }
    ];
  };
  const getSimilarProductsSetting = (product) => {
    return product ? {
      title: "\u0645\u062D\u0635\u0648\u0644\u0627\u062A \u0645\u0634\u0627\u0628\u0647",
      column: "n",
      row: "1",
      theme: "vertical-view",
      className: "mb-7",
      "requestUrl": `${api}/shop/similar-products?product_id=${product.id}&category_id=${product.category_id}&brand_id=${product.brand_id}`
    } : null;
  };
  return {
    theme,
    api,
    store,
    requestUrl,
    shopSetting,
    getMeta,
    getSimilarProductsSetting
  };
}
const _sfc_main = {
  __name: "[slug]",
  __ssrInlineRender: true,
  async setup(__props) {
    var _a;
    let __temp, __restore;
    const global = useNuxtApp().vueApp.config.globalProperties;
    const {
      getMeta,
      getSimilarProductsSetting,
      theme,
      store,
      requestUrl,
      shopSetting
    } = useProduct(global);
    const { data: product, status } = ([__temp, __restore] = withAsyncContext(() => useFetch(
      requestUrl,
      {
        credentials: "include",
        server: true,
        lazy: false,
        headers: {
          "X-XSRF-TOKEN": useCookie("XSRF-TOKEN").value
        }
      },
      "$nfE2xavsc5"
    )), __temp = await __temp, __restore(), __temp);
    if (product.value) {
      useHead({
        title: "\u0641\u0631\u0648\u0634\u06AF\u0627\u0647 \u0627\u06CC\u0646\u062A\u0631\u0646\u062A\u06CC " + ((_a = shopSetting.value) == null ? void 0 : _a.name) + " - " + product.value.title,
        meta: getMeta(product.value)
      });
      store.updateProduct(product.value);
    }
    watch(() => status.value, () => {
      if (status.value === "error") {
        showError({
          statusCode: 404,
          statusMessage: "Page Not Found"
        });
      }
    });
    watch(() => product.value, () => {
      var _a2;
      store.updateProduct(product.value);
      useHead({
        title: "\u0641\u0631\u0648\u0634\u06AF\u0627\u0647 \u0627\u06CC\u0646\u062A\u0631\u0646\u062A\u06CC " + ((_a2 = shopSetting.value) == null ? void 0 : _a2.name) + " - " + product.value.title,
        meta: getMeta(product.value)
      });
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_CategoriesSelectBreadCrumbs = _sfc_main$k;
      const _component_ProductPageGalleryDesktop = _sfc_main$h;
      const _component_ReportWrongForm = _sfc_main$g;
      const _component_ProductPageInformation = _sfc_main$8;
      const _component_ProductPagePurchaseFeatures = _sfc_main$7;
      const _component_PriceVariationAllListDesktop = _sfc_main$6;
      const _component_ThemeWidgetsProductSlider = _sfc_main$l;
      const _component_ProductPageTabs = _sfc_main$4;
      const _component_Skeleton = __nuxt_component_3;
      const _component_ProductPageGalleryMobile = _sfc_main$3;
      const _component_ShareIcon = _sfc_main$2;
      const _component_ProductPageReturnConditions = _sfc_main$c;
      const _component_ThemeProductSliderView = _sfc_main$m;
      const _component_ProductPageOffcanvasTabs = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "product-page" }, _attrs))}>`);
      if (unref(theme) === "desktop") {
        _push(`<!--[-->`);
        if (unref(status) === "success" && unref(product)) {
          _push(`<div class="w-full"><div>`);
          _push(ssrRenderComponent(_component_CategoriesSelectBreadCrumbs, {
            category_id: unref(product).category_id,
            class: "text-sm"
          }, null, _parent));
          _push(`</div><div class="w-full flex py-1"><div class="image-box">`);
          _push(ssrRenderComponent(_component_ProductPageGalleryDesktop, { product: unref(product) }, null, _parent));
          _push(ssrRenderComponent(_component_ReportWrongForm, null, null, _parent));
          _push(`</div><div class="information-box pr-3">`);
          _push(ssrRenderComponent(_component_ProductPageInformation, { product: unref(product) }, null, _parent));
          _push(`</div></div>`);
          _push(ssrRenderComponent(_component_ProductPagePurchaseFeatures, { class: "py-10 border-t border-b border-gray-100" }, null, _parent));
          _push(ssrRenderComponent(_component_PriceVariationAllListDesktop, { product: unref(product) }, null, _parent));
          if (unref(getSimilarProductsSetting)(unref(product))) {
            _push(ssrRenderComponent(_component_ThemeWidgetsProductSlider, {
              setting: unref(getSimilarProductsSetting)(unref(product))
            }, null, _parent));
          } else {
            _push(`<!---->`);
          }
          _push(`<div class="relative">`);
          _push(ssrRenderComponent(_component_ProductPageTabs, null, null, _parent));
          _push(`</div></div>`);
        } else {
          _push(`<div class="w-full flex"><div class="image-box">`);
          _push(ssrRenderComponent(_component_Skeleton, { class: "w-full h-[300px] rounded-md" }, null, _parent));
          _push(`</div><div class="flex-grow px-3">`);
          _push(ssrRenderComponent(_component_Skeleton, { class: "w-full h-4 rounded-md" }, null, _parent));
          _push(ssrRenderComponent(_component_Skeleton, { class: "w-[90%] h-4 my-2 rounded-md" }, null, _parent));
          _push(`</div></div>`);
        }
        _push(`<!--]-->`);
      } else {
        _push(`<!--[-->`);
        if (unref(status) === "success" && unref(product)) {
          _push(`<div class="w-full">`);
          _push(ssrRenderComponent(_component_ProductPageGalleryMobile, { product: unref(product) }, null, _parent));
          _push(`<div class="flex justify-between items-center py-2">`);
          _push(ssrRenderComponent(_component_CategoriesSelectBreadCrumbs, {
            category_id: unref(product).category_id,
            class: "text-sm px-3"
          }, null, _parent));
          _push(`<div class="pl-3">`);
          if (unref(product)) {
            _push(ssrRenderComponent(_component_ShareIcon, {
              class: "text-xl text-gray-600 cursor-pointer",
              title: "\u0627\u0634\u062A\u0631\u0627\u06A9 \u06AF\u0630\u0627\u0631\u06CC",
              text: unref(product).title,
              url: _ctx.$getProductPath(unref(product))
            }, null, _parent));
          } else {
            _push(`<!---->`);
          }
          _push(`</div></div>`);
          _push(ssrRenderComponent(_component_ProductPageInformation, {
            product: unref(product),
            class: "px-3 max-lg:border-b-[8px]"
          }, null, _parent));
          _push(ssrRenderComponent(_component_ProductPageReturnConditions, { class: "px-3 max-lg:border-b-[8px] py-5" }, null, _parent));
          _push(`<div class="relative">`);
          _push(ssrRenderComponent(_component_ProductPageTabs, { product: unref(product) }, null, _parent));
          _push(`</div>`);
          _push(ssrRenderComponent(_component_ThemeProductSliderView, {
            title: "\u0645\u062D\u0635\u0648\u0644\u0627\u062A \u0645\u0634\u0627\u0628\u0647",
            column: "n",
            row: "1",
            theme: "vertical-view",
            class: "mb-7",
            "hide-more-link": "",
            "request-url": ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.api + "/shop/similar-products?product_id=" + unref(product).id + "&category_id=" + unref(product).category_id + "&brand_id=" + unref(product).brand_id
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<div class="w-full">`);
          _push(ssrRenderComponent(_component_Skeleton, { class: "w-full h-[300px] rounded-md" }, null, _parent));
          _push(`<div class="w-full mt-3 px-3">`);
          _push(ssrRenderComponent(_component_Skeleton, { class: "w-full h-4 rounded-md" }, null, _parent));
          _push(ssrRenderComponent(_component_Skeleton, { class: "w-[90%] h-4 my-2 rounded-md" }, null, _parent));
          _push(`</div></div>`);
        }
        _push(ssrRenderComponent(_component_ProductPageOffcanvasTabs, null, null, _parent));
        _push(`<!--]-->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/product/[code]-[id]/[slug].vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=_slug_-DYFr3q4n.mjs.map
