import { e as useRoute, c as useNuxtApp, h as _sfc_main$k, g as __nuxt_component_0$2, b as useRuntimeConfig } from './server.mjs';
import { defineComponent, ref, computed, resolveComponent, mergeProps, unref, withCtx, createTextVNode, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderAttr } from 'vue/server-renderer';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Verify",
  __ssrInlineRender: true,
  setup(__props) {
    useRoute();
    const loading = ref(false);
    const order = ref(null);
    const paymentMethods = useNuxtApp().vueApp.config.globalProperties["$payment:methods"];
    const paymentMethod = computed(() => {
      if (order.value && paymentMethods) {
        const method = paymentMethods.find((method2) => method2.name == order.value.payment_method);
        if (method) {
          return method.title;
        }
      }
      return "";
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Loading = _sfc_main$k;
      const _component_nuxt_link = __nuxt_component_0$2;
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "verify-checkout flex flex-col items-center py-10" }, _attrs))}>`);
      if (unref(loading)) {
        _push(ssrRenderComponent(_component_Loading, null, null, _parent));
      } else {
        _push(`<!--[-->`);
        if (unref(order) != null && unref(order).status == "ok") {
          _push(`<div class="content lg:border rounded-lg"><div class="max-md:w-full"><h4 class="text-gray-600">\u0633\u0641\u0627\u0631\u0634 \u0634\u0645\u0627 \u0628\u0627 \u0645\u0648\u0641\u0642\u06CC\u062A \u062B\u0628\u062A \u0634\u062F</h4><ul class="py-3 pa-h-0 ma-0"><li class="py-3"><span>\u0634\u0645\u0627\u0631\u0647 \u0633\u0641\u0627\u0631\u0634 : </span><span class="font-bold">${ssrInterpolate(_ctx.$replaceEnNumber(unref(order).order_code))}</span></li><li class="py-3"><span>\u0631\u0648\u0634 \u067E\u0631\u062F\u0627\u062E\u062A : </span><span class="font-bold">${ssrInterpolate(unref(paymentMethod))}</span></li></ul><div>`);
          _push(ssrRenderComponent(_component_nuxt_link, {
            class: "btn btn-danger p-3 text-sm",
            to: "/profile/orders"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(` \u0648\u06CC\u0631\u0627\u06CC\u0634 \u0648 \u067E\u06CC\u06AF\u06CC\u0631\u06CC \u0633\u0641\u0627\u0631\u0634 `);
              } else {
                return [
                  createTextVNode(" \u0648\u06CC\u0631\u0627\u06CC\u0634 \u0648 \u067E\u06CC\u06AF\u06CC\u0631\u06CC \u0633\u0641\u0627\u0631\u0634 ")
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(ssrRenderComponent(_component_nuxt_link, {
            class: "!text-red-600 mx-2.5 fs-15",
            to: "/"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(` \u0628\u0627\u0632\u06AF\u0634\u062A \u0628\u0647 \u0635\u0641\u062D\u0647 \u0627\u0635\u0644\u06CC `);
              } else {
                return [
                  createTextVNode(" \u0628\u0627\u0632\u06AF\u0634\u062A \u0628\u0647 \u0635\u0641\u062D\u0647 \u0627\u0635\u0644\u06CC ")
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`</div></div><div class="max-md:w-full"><img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.appUrl + "/images/order-success.svg")} alt="order-success"></div></div>`);
        } else {
          _push(`<div class="content lg:border rounded-lg"><div class="max-md:w-full"><h4 class="!text-red-600"> \u0645\u062A\u0627\u0633\u0641\u0627\u0646\u0647 \u067E\u0631\u062F\u0627\u062E\u062A \u0634\u0645\u0627 \u0646\u0627\u0645\u0648\u0641\u0642 \u0628\u0648\u062F! </h4><div class="text-gray-600 py-5">`);
          _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "fa-info"] }, null, _parent));
          _push(`<span> \u0686\u0646\u0627\u0646\u0686\u0647 \u0645\u0628\u0644\u063A\u06CC \u0627\u0632 \u062D\u0633\u0627\u0628 \u0634\u0645\u0627 \u06A9\u0633\u0631 \u0634\u062F\u0647 \u0627\u0633\u062A\u060C \u062A\u0627 \u06F2\u06F4 \u0633\u0627\u0639\u062A \u0622\u06CC\u0646\u062F\u0647 \u0628\u0647 \u062D\u0633\u0627\u0628 \u0634\u0645\u0627 \u0628\u0627\u0632 \u062E\u0648\u0627\u0647\u062F \u06AF\u0634\u062A. </span></div><div><button class="c-btn text-sm px-5"> \u067E\u0631\u062F\u0627\u062E\u062A \u062F\u0648\u0628\u0627\u0631\u0647 </button></div></div><div class="max-md:w-full"><img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.appUrl + "/images/order-Fail.svg")} alt="order-fail"></div></div>`);
        }
        _push(`<!--]-->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/Verify.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as _ };
//# sourceMappingURL=Verify-hxF_WJkP.mjs.map
