import { _ as _sfc_main$1 } from './ProductsSlider-B4X-edAw.mjs';
import { b as useRuntimeConfig, c as useNuxtApp, k as __nuxt_component_3 } from './server.mjs';
import { defineComponent, ref, computed, resolveComponent, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderAttr, ssrInterpolate, ssrRenderComponent } from 'vue/server-renderer';
import { u as useMonthsList } from './MonthsList-B1ySoCWX.mjs';
import { u as useOrderStore } from './index-Co4X6G3O.mjs';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';
import 'pinia';
import 'vue-router';
import 'highcharts';
import 'lodash';
import '@vue/shared';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Summary",
  __ssrInlineRender: true,
  props: {
    submission: {}
  },
  setup(__props) {
    const store = useOrderStore();
    const props = __props;
    const showDetail = ref(false);
    const months = useMonthsList();
    const { serverUrl } = useRuntimeConfig().public;
    const global = useNuxtApp().vueApp.config.globalProperties;
    const getDate = () => {
      let result = "";
      const prefix = `${props.submission.info["name"]}:${props.submission.info["sender"]}`;
      const date = store.formData[`${prefix}_date`];
      const ex = date.toString().split("/");
      if (ex.length == 3 && months[parseInt(ex[1])]) {
        result = `${ex[2]} ${months[parseInt(ex[1])]} ${ex[0]}`;
      }
      return global.$replaceEnNumber(result);
    };
    const getTime = () => {
      const prefix = `${props.submission.info["name"]}:${props.submission.info["sender"]}`;
      return global.$replaceEnNumber(store.formData[`${prefix}_time`]);
    };
    const submissionTotalPrice = computed(() => {
      let price = 0;
      props.submission.products.forEach((product) => {
        price += parseInt((product.variation.price2 * product.count).toString());
      });
      if (props.submission.info.price > 0) {
        price += parseInt(props.submission.info.price.toString());
      }
      return price;
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_OrdersCheckoutProductsSlider = _sfc_main$1;
      const _component_IconsToman = __nuxt_component_3;
      _push(`<div${ssrRenderAttrs(_attrs)}><div class="text-gray-800 flex justify-between items-center w-full"><div class="flex items-center font-bold"><img${ssrRenderAttr("src", unref(serverUrl) + "/" + props.submission.info.icon)} class="w-8" alt=""><span class="px-1.5">${ssrInterpolate(getDate())}</span><span> - \u0628\u0627\u0632\u0647 </span><span class="px-1">${ssrInterpolate(getTime())}</span><div class="bg-gray-100 rounded-xl px-3 py-0.5 text-sm mr-2">${ssrInterpolate(_ctx.$replaceEnNumber(props.submission.products.length))} \u06A9\u0627\u0644\u0627 </div></div><button class="text-sm flex items-center">`);
      if (!unref(showDetail)) {
        _push(`<span>\u062C\u0632\u0626\u06CC\u0627\u062A \u0645\u0631\u0633\u0648\u0644\u0647</span>`);
      } else {
        _push(`<span>\u0628\u0633\u062A\u0646</span>`);
      }
      _push(ssrRenderComponent(_component_fa_icon, {
        icon: ["fas", unref(showDetail) ? "angle-up" : "angle-down"],
        class: "mr-1.5"
      }, null, _parent));
      _push(`</button></div><div class="mt-3 text-sm text-gray-700">${ssrInterpolate(props.submission.info.title)}</div>`);
      if (unref(showDetail)) {
        _push(ssrRenderComponent(_component_OrdersCheckoutProductsSlider, {
          products: props.submission.products,
          "disable-action": ""
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      if (unref(showDetail)) {
        _push(`<div class="flex items-center text-gray-800"><span>\u0645\u0628\u0644\u063A \u0645\u0631\u0633\u0648\u0644\u0647 : </span><span class="mr-1">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(unref(submissionTotalPrice))))}</span>`);
        _push(ssrRenderComponent(_component_IconsToman, { class: "mr-1" }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/custom-delivery/Summary.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=Summary-DyiUFoXX.mjs.map
