import { _ as _sfc_main$1 } from './Tooltip-B8G2HT4W.mjs';
import { u as useState, _ as _sfc_main$i, b as useRuntimeConfig } from './server.mjs';
import { defineComponent, ref, resolveComponent, unref, createSlots, withCtx, createVNode, createBlock, openBlock, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrRenderClass } from 'vue/server-renderer';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';
import 'pinia';
import 'vue-router';
import 'highcharts';
import 'lodash';
import '@vue/shared';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "ShortCode",
  __ssrInlineRender: true,
  props: {
    product: {},
    hideTooltip: { type: Boolean }
  },
  setup(__props) {
    const theme = useState("theme");
    const boxRef = ref(null);
    const copied = ref(false);
    const copyUrl = async () => {
      try {
        await (void 0).clipboard.writeText(
          useRuntimeConfig().public.appUrl + "/product"
        );
        copied.value = true;
        setTimeout(() => {
          copied.value = false;
        }, 5e3);
      } catch (error) {
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Tooltip = _sfc_main$1;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_Modal = _sfc_main$i;
      _push(`<!--[-->`);
      if (unref(theme) == "desktop") {
        _push(ssrRenderComponent(_component_Tooltip, { position: "left" }, createSlots({
          tag: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(_component_fa_icon, {
                icon: ["fas", "share-nodes"],
                class: "text-xl cursor-pointer",
                onClick: ($event) => unref(boxRef).show()
              }, null, _parent2, _scopeId));
            } else {
              return [
                createVNode(_component_fa_icon, {
                  icon: ["fas", "share-nodes"],
                  class: "text-xl cursor-pointer",
                  onClick: ($event) => unref(boxRef).show()
                }, null, 8, ["onClick"])
              ];
            }
          }),
          _: 2
        }, [
          _ctx.hideTooltip == false ? {
            name: "content",
            fn: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<div${_scopeId}>\u0627\u0634\u062A\u0631\u0627\u06A9 \u06AF\u0630\u0627\u0631\u06CC</div>`);
              } else {
                return [
                  createVNode("div", null, "\u0627\u0634\u062A\u0631\u0627\u06A9 \u06AF\u0630\u0627\u0631\u06CC")
                ];
              }
            }),
            key: "0"
          } : void 0
        ]), _parent));
      } else {
        _push(`<div class="flex items-center">`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fas", "share-nodes"],
          class: "text-xl cursor-pointer"
        }, null, _parent));
        _push(`<span class="pr-3">\u0627\u0634\u062A\u0631\u0627\u06A9 \u06AF\u0630\u0627\u0631\u06CC</span></div>`);
      }
      _push(ssrRenderComponent(_component_Modal, {
        title: "\u0627\u0634\u062A\u0631\u0627\u06A9\u200C\u06AF\u0630\u0627\u0631\u06CC",
        ref_key: "boxRef",
        ref: boxRef
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="px-3 pt-4"${_scopeId}><p${_scopeId}>\u0627\u06CC\u0646 \u06A9\u0627\u0644\u0627 \u0631\u0627 \u0628\u0627 \u062F\u0648\u0633\u062A\u0627\u0646 \u062E\u0648\u062F \u0628\u0647 \u0627\u0634\u062A\u0631\u0627\u06A9 \u0628\u06AF\u0630\u0627\u0631\u06CC\u062F!</p><div class="py-5 flex justify-end"${_scopeId}><button class="${ssrRenderClass([[unref(copied) ? "c-btn" : "btn-secondary"], "w-auto btn text-sm h-10"])}"${_scopeId}>`);
            if (!unref(copied)) {
              _push2(`<span${_scopeId}>\u06A9\u067E\u06CC \u06A9\u0631\u062F\u0646 \u0644\u06CC\u0646\u06A9</span>`);
            } else {
              _push2(`<span${_scopeId}>\u06A9\u067E\u06CC \u0634\u062F</span>`);
            }
            _push2(`</button></div></div>`);
          } else {
            return [
              createVNode("div", { class: "px-3 pt-4" }, [
                createVNode("p", null, "\u0627\u06CC\u0646 \u06A9\u0627\u0644\u0627 \u0631\u0627 \u0628\u0627 \u062F\u0648\u0633\u062A\u0627\u0646 \u062E\u0648\u062F \u0628\u0647 \u0627\u0634\u062A\u0631\u0627\u06A9 \u0628\u06AF\u0630\u0627\u0631\u06CC\u062F!"),
                createVNode("div", { class: "py-5 flex justify-end" }, [
                  createVNode("button", {
                    class: ["w-auto btn text-sm h-10", [unref(copied) ? "c-btn" : "btn-secondary"]],
                    onClick: ($event) => copyUrl()
                  }, [
                    !unref(copied) ? (openBlock(), createBlock("span", { key: 0 }, "\u06A9\u067E\u06CC \u06A9\u0631\u062F\u0646 \u0644\u06CC\u0646\u06A9")) : (openBlock(), createBlock("span", { key: 1 }, "\u06A9\u067E\u06CC \u0634\u062F"))
                  ], 10, ["onClick"])
                ])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/share/ShortCode.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=ShortCode-DvK4WNDb.mjs.map
