import { u as useState, g as __nuxt_component_0$2, _ as _sfc_main$i, a as _sfc_main$o, x as _sfc_main$h, o as _sfc_main$c } from './server.mjs';
import { _ as _sfc_main$1 } from './Items-CRlozw8Q.mjs';
import { defineComponent, ref, watch, resolveComponent, withCtx, createVNode, resolveDynamicComponent, unref, toDisplayString, createBlock, createCommentVNode, openBlock, useSSRContext } from 'vue';
import { ssrRenderClass, ssrRenderComponent, ssrInterpolate, ssrRenderVNode } from 'vue/server-renderer';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "SelectVariationBtn",
  __ssrInlineRender: true,
  props: {
    product: {},
    btnClass: {},
    text: {},
    hideIcon: { type: Boolean }
  },
  setup(__props) {
    const theme = useState("theme");
    const boxRef = ref(null);
    const variations = ref();
    const selectedVariation = ref(null);
    const selectedVariationId = useState("variation-id");
    const setSelectedVariation = () => {
      selectedVariation.value = variations.value.find((variation) => variation.id == selectedVariationId.value);
    };
    watch(() => variations.value, () => {
      setSelectedVariation();
    });
    watch(() => selectedVariationId.value, () => {
      setSelectedVariation();
    });
    return (_ctx, _push, _parent, _attrs) => {
      var _a;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_nuxt_link = __nuxt_component_0$2;
      const _component_PriceVariationItems = _sfc_main$1;
      const _component_CartAddBtn = _sfc_main$h;
      const _component_PriceVariationPriceBox = _sfc_main$c;
      _push(`<!--[-->`);
      if (_ctx.product.status == 1) {
        _push(`<button class="${ssrRenderClass(_ctx.btnClass)}">`);
        if (!_ctx.hideIcon) {
          _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "fa-cart-shopping"] }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<span class="${ssrRenderClass({ "pr-3": !_ctx.hideIcon })}">${ssrInterpolate((_a = _ctx.text) != null ? _a : "\u0627\u0641\u0632\u0648\u062F\u0646 \u0628\u0647 \u0633\u0628\u062F \u062E\u0631\u06CC\u062F")}</span></button>`);
      } else {
        _push(ssrRenderComponent(_component_nuxt_link, {
          to: "/product2",
          class: "w-full"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<button class="${ssrRenderClass([_ctx.btnClass, "w-full"])}"${_scopeId}> \u06A9\u0627\u0644\u0627\u0647\u0627\u06CC \u0645\u0634\u0627\u0628\u0647 </button>`);
            } else {
              return [
                createVNode("button", {
                  class: [_ctx.btnClass, "w-full"]
                }, " \u06A9\u0627\u0644\u0627\u0647\u0627\u06CC \u0645\u0634\u0627\u0628\u0647 ", 2)
              ];
            }
          }),
          _: 1
        }, _parent));
      }
      ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(theme) == "desktop" ? _sfc_main$i : _sfc_main$o), {
        title: "\u0627\u0646\u062A\u062E\u0627\u0628 \u062C\u0632\u0626\u06CC\u0627\u062A",
        "content-class": "bottom-0 w-full !h-auto",
        ref_key: "boxRef",
        ref: boxRef,
        direction: "bottom"
      }, {
        footer: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (unref(selectedVariationId) && unref(selectedVariation)) {
              _push2(`<div class="flex justify-between items-center py-2 px-3 border-t"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_CartAddBtn, {
                variation: unref(selectedVariation),
                class: "!text-sm w-auto",
                "disable-description": ""
              }, null, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_PriceVariationPriceBox, { variation: unref(selectedVariation) }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              unref(selectedVariationId) && unref(selectedVariation) ? (openBlock(), createBlock("div", {
                key: 0,
                class: "flex justify-between items-center py-2 px-3 border-t"
              }, [
                createVNode(_component_CartAddBtn, {
                  variation: unref(selectedVariation),
                  class: "!text-sm w-auto",
                  "disable-description": ""
                }, null, 8, ["variation"]),
                createVNode(_component_PriceVariationPriceBox, { variation: unref(selectedVariation) }, null, 8, ["variation"])
              ])) : createCommentVNode("", true)
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="px-3 py-4"${_scopeId}><div class="bg-gray-100 rounded-md my-3 px-3 py-2"${_scopeId}>${ssrInterpolate(_ctx.product.title)}</div>`);
            _push2(ssrRenderComponent(_component_PriceVariationItems, {
              product: { ..._ctx.product, ...{ variations: unref(variations) } }
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "px-3 py-4" }, [
                createVNode("div", { class: "bg-gray-100 rounded-md my-3 px-3 py-2" }, toDisplayString(_ctx.product.title), 1),
                createVNode(_component_PriceVariationItems, {
                  product: { ..._ctx.product, ...{ variations: unref(variations) } }
                }, null, 8, ["product"])
              ])
            ];
          }
        }),
        _: 1
      }), _parent);
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/priceVariation/SelectVariationBtn.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as _ };
//# sourceMappingURL=SelectVariationBtn-nIKCeOxT.mjs.map
